import { u as unsubscribe_stores, f as bind_props, s as store_get, e as escape_html } from "./index3.js";
import { h as Avatar, B as Button } from "./client.svelte.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { t } from "./index.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { L as Label } from "./Label.js";
import { S as Switch } from "./Switch.js";
import { M as Modal } from "./Modal.js";
import { M as MarkdownEditor } from "./MarkdownEditor.js";
import { D as Duration } from "./Duration.js";
import { C as CommunityLink } from "./CommunityLink.js";
function BanModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { open = false, user: item = void 0, community, banned } = $$props;
    let reason = "";
    let deleteData = false;
    let expires = -1;
    let loading = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        title: banned ? store_get($$store_subs ??= {}, "$t", t)("moderation.ban.unbanning") : store_get($$store_subs ??= {}, "$t", t)("moderation.ban.banning"),
        get open() {
          return open;
        },
        set open($$value) {
          open = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          if (item) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<form class="flex flex-col gap-4"><div class="flex items-center gap-1">`);
            Avatar($$renderer4, { url: item.avatar, alt: item.name, width: 24 });
            $$renderer4.push(`<!----> <span class="font-bold">${escape_html(item.name)}</span></div> `);
            if (community) {
              $$renderer4.push("<!--[-->");
              CommunityLink($$renderer4, { community, avatar: true });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> `);
            MarkdownEditor($$renderer4, {
              required: true,
              label: store_get($$store_subs ??= {}, "$t", t)("moderation.reason"),
              get value() {
                return reason;
              },
              set value($$value) {
                reason = $$value;
                $$settled = false;
              }
            });
            $$renderer4.push(`<!----> `);
            if (!banned) {
              $$renderer4.push("<!--[-->");
              {
                let description = function($$renderer5) {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.ban.warning"))}`);
                };
                Switch($$renderer4, {
                  get checked() {
                    return deleteData;
                  },
                  set checked($$value) {
                    deleteData = $$value;
                    $$settled = false;
                  },
                  description,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.ban.deleteData"))}`);
                  },
                  $$slots: { description: true, default: true }
                });
              }
              $$renderer4.push(`<!----> `);
              Label($$renderer4, {
                text: store_get($$store_subs ??= {}, "$t", t)("moderation.ban.expires"),
                children: ($$renderer5) => {
                  Duration($$renderer5, {
                    get value() {
                      return expires;
                    },
                    set value($$value) {
                      expires = $$value;
                      $$settled = false;
                    }
                  });
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> `);
            Button($$renderer4, {
              submit: true,
              color: "primary",
              loading,
              disabled: loading,
              size: "lg",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></form>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { open, user: item });
  });
}
export {
  BanModal as default
};
//# sourceMappingURL=BanModal.js.map
