import { l as spread_props, e as escape_html, s as store_get, k as stringify, u as unsubscribe_stores, f as bind_props, a as attr_class, j as attr_style, c as clsx, b as attr, d as ensure_array_like } from "./index3.js";
import { p as page } from "./index4.js";
import { p as profile, w as isCommentView, s as site, B as Button, I as placeholders, a6 as Language, a3 as Minus, o as Plus, U as UserLink, q as publishedToDate, i as Markdown } from "./client.svelte.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { t } from "./index.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { I as Icon } from "./Icon.js";
import { B as Bookmark } from "./Bookmark.js";
import { s as shouldShowVoteColor, B as BookmarkSlash, a as save, d as deleteItem, b as Pencil } from "./PostVote.js";
import { S as ShieldCheck } from "./ShieldCheck.js";
import { T as Trash } from "./Trash.js";
import { M as Modal } from "./Modal.js";
import { s as settings } from "./settings.svelte.js";
import { R as RelativeDate, f as formatRelativeDate } from "./RelativeDate.js";
import { C as ChatBubbleOvalLeft } from "./ChatBubbleOvalLeft.js";
import { E as EllipsisHorizontal } from "./EllipsisHorizontal.js";
import { F as Flag } from "./Flag.js";
import { P as PencilSquare } from "./PencilSquare.js";
import { S as Share } from "./Share.js";
import { M as Menu, a as MenuButton } from "./MenuButton.js";
import { A as ArrowsUpDown } from "./ArrowsUpDown.js";
import { F as Fire } from "./Fire.js";
import { M as Megaphone } from "./Megaphone.js";
import { N as Newspaper } from "./Newspaper.js";
import { S as ShieldExclamation } from "./ShieldExclamation.js";
import "clsx";
import { M as MenuDivider } from "./MenuDivider.js";
import { a as remove, b as ban, f as feature, v as viewVotes, c as report } from "./moderation.js";
import { F as FormattedNumber } from "./FormattedNumber.js";
import { C as ChevronDown } from "./ChevronDown.js";
import { C as ChevronUp } from "./ChevronUp.js";
import { M as MarkdownEditor } from "./MarkdownEditor.js";
import { X as XMark } from "./XMark.js";
const Microphone = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M8 1a2 2 0 0 0-2 2v4a2 2 0 1 0 4 0V3a2 2 0 0 0-2-2Z"
      },
      {
        "d": "M4.5 7A.75.75 0 0 0 3 7a5.001 5.001 0 0 0 4.25 4.944V13.5h-1.5a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-1.5v-1.556A5.001 5.001 0 0 0 13 7a.75.75 0 0 0-1.5 0 3.5 3.5 0 1 1-7 0Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M7 4a3 3 0 0 1 6 0v6a3 3 0 1 1-6 0V4Z"
      },
      {
        "d": "M5.5 9.643a.75.75 0 0 0-1.5 0V10c0 3.06 2.29 5.585 5.25 5.954V17.5h-1.5a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-1.5v-1.546A6.001 6.001 0 0 0 16 10v-.357a.75.75 0 0 0-1.5 0V10a4.5 4.5 0 0 1-9 0v-.357Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M12 18.75a6 6 0 0 0 6-6v-1.5m-6 7.5a6 6 0 0 1-6-6v-1.5m6 7.5v3.75m-3.75 0h7.5M12 15.75a3 3 0 0 1-3-3V4.5a3 3 0 1 1 6 0v8.25a3 3 0 0 1-3 3Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M8.25 4.5a3.75 3.75 0 1 1 7.5 0v8.25a3.75 3.75 0 1 1-7.5 0V4.5Z"
      },
      {
        "d": "M6 10.5a.75.75 0 0 1 .75.75v1.5a5.25 5.25 0 1 0 10.5 0v-1.5a.75.75 0 0 1 1.5 0v1.5a6.751 6.751 0 0 1-6 6.709v2.291h3a.75.75 0 0 1 0 1.5h-7.5a.75.75 0 0 1 0-1.5h3v-2.291a6.751 6.751 0 0 1-6-6.709v-1.5A.75.75 0 0 1 6 10.5Z"
      }
    ]
  }
};
function CommentModerationMenu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { item = void 0, target, $$slots, $$events, ...rest } = $$props;
    Menu($$renderer2, spread_props([
      rest,
      {
        placement: "bottom",
        target,
        children: ($$renderer3) => {
          if (profile.isMod(item.community) || profile.isAdmin) {
            $$renderer3.push("<!--[-->");
            MenuDivider($$renderer3, {
              hidden: true,
              children: ($$renderer4) => {
                if (!item.community.local && !profile.isMod(item.community)) {
                  $$renderer4.push("<!--[-->");
                  $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.labelInstanceOnly"))}`);
                } else {
                  $$renderer4.push("<!--[!-->");
                  $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.label"))}`);
                }
                $$renderer4.push(`<!--]-->`);
              }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "danger-subtle",
              onclick: () => remove(item),
              icon: Trash,
              children: ($$renderer4) => {
                if (isCommentView(item)) {
                  $$renderer4.push("<!--[-->");
                  $$renderer4.push(`${escape_html(item.comment.removed ? store_get($$store_subs ??= {}, "$t", t)("moderation.restore") : store_get($$store_subs ??= {}, "$t", t)("moderation.remove"))}`);
                } else {
                  $$renderer4.push("<!--[!-->");
                }
                $$renderer4.push(`<!--]-->`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            if (profile.current?.user && profile.current.user?.local_user_view.person.id != item.creator.id) {
              $$renderer3.push("<!--[-->");
              MenuButton($$renderer3, {
                color: "danger-subtle",
                onclick: () => ban(item.creator_banned_from_community, item.creator, item.community),
                icon: ShieldExclamation,
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(item.creator_banned_from_community ? store_get($$store_subs ??= {}, "$t", t)("moderation.ban.unbanFromCommunity") : store_get($$store_subs ??= {}, "$t", t)("moderation.ban.banFromCommunity"))}`);
                },
                $$slots: { default: true }
              });
            } else {
              $$renderer3.push("<!--[!-->");
              MenuButton($$renderer3, {
                color: "success-subtle",
                onclick: async () => {
                  if (!profile.current.jwt) return;
                  item.comment = (await feature(!item.comment.distinguished, item.comment, profile.current.jwt)).comment_view.comment;
                },
                icon: Megaphone,
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(item.comment.distinguished ? store_get($$store_subs ??= {}, "$t", t)("moderation.unfeature") : store_get($$store_subs ??= {}, "$t", t)("moderation.feature"))}`);
                },
                $$slots: { default: true }
              });
            }
            $$renderer3.push(`<!--]--> `);
            MenuButton($$renderer3, {
              color: "success-subtle",
              href: `/modlog?comment=${stringify(item.comment.id)}`,
              children: ($$renderer4) => {
                Icon($$renderer4, { src: Newspaper, size: "16", micro: true });
                $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.modlog.comment"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "success-subtle",
              href: `/modlog?user=${stringify(item.creator.id)}`,
              children: ($$renderer4) => {
                Icon($$renderer4, { src: Newspaper, size: "16", micro: true });
                $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.modlog.user"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "blue-subtle",
              onclick: () => viewVotes(item),
              children: ($$renderer4) => {
                Icon($$renderer4, { src: ArrowsUpDown, size: "16", micro: true });
                $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.votes"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!---->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (profile.isAdmin) {
            $$renderer3.push("<!--[-->");
            MenuDivider($$renderer3, {
              showLabel: true,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("admin.label"))}`);
              }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "danger-subtle",
              onclick: () => remove(item, true),
              icon: Fire,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("admin.purge"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!---->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      }
    ]));
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { item });
  });
}
function CommentVote($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { vote = 0, upvotes = void 0, downvotes = void 0, comment } = $$props;
    let voteRatio = Math.floor((upvotes ?? 0) / ((upvotes ?? 0) + (downvotes ?? 0)) * 100);
    function voteButton($$renderer3, votes, target, vote2) {
      const targetNum = target == "upvote" ? 1 : -1;
      $$renderer3.push(`<button${attr_class(
        clsx([
          "flex items-center gap-0.5 transition-colors relative cursor-pointer px-1.5 py-1",
          "first:rounded-l-3xl last:rounded-r-3xl",
          "last:flex-row-reverse",
          vote2 == targetNum ? shouldShowVoteColor(vote2, target == "upvote" ? "upvotes" : "downvotes") : "btn-tertiary"
        ]),
        "svelte-qvcm8h"
      )}${attr("aria-pressed", vote2 == targetNum)}${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)(target == "upvote" ? "post.actions.vote.upvote" : "post.actions.vote.downvote"))}>`);
      Icon($$renderer3, {
        src: target == "upvote" ? ChevronUp : ChevronDown,
        size: "18",
        micro: true
      });
      $$renderer3.push(`<!----> <div class="grid text-sm z-20"><!---->`);
      {
        $$renderer3.push(`<span style="grid-column: 1; grid-row: 1;"${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)(target == "upvote" ? "aria.vote.upvotes" : "aria.vote.downvotes", { default: votes }))}>`);
        FormattedNumber($$renderer3, { number: votes ?? 0 });
        $$renderer3.push(`<!----></span>`);
      }
      $$renderer3.push(`<!----></div></button>`);
    }
    $$renderer2.push(`<div${attr_class(
      clsx([
        "h-full relative flex items-center overflow-hidden rounded-full font-medium",
        voteRatio < 85 && settings.voteRatioBar && "vote-ratio",
        "divide-x divide-slate-200 dark:divide-zinc-800 border border-slate-200 dark:border-zinc-800"
      ]),
      "svelte-qvcm8h"
    )}${attr_style(`--vote-ratio: ${stringify(voteRatio)}%;`)}>`);
    voteButton($$renderer2, upvotes, "upvote", vote);
    $$renderer2.push(`<!----> `);
    if (site.data?.site_view.local_site.enable_downvotes ?? true) {
      $$renderer2.push("<!--[-->");
      voteButton($$renderer2, downvotes, "downvote", vote);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { vote, upvotes, downvotes });
  });
}
function CommentActions($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { comment = void 0, replying = false, disabled = false, onedit } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div${attr_class(clsx([
        "flex flex-row items-center gap-0.5 w-full",
        settings.posts.reverseActions && "flex-row-reverse"
      ]))}>`);
      CommentVote($$renderer3, {
        upvotes: comment.counts.upvotes,
        downvotes: comment.counts.downvotes,
        vote: comment.my_vote,
        comment: comment.comment
      });
      $$renderer3.push(`<!----> `);
      Button($$renderer3, {
        color: "tertiary",
        rounding: "pill",
        size: "sm",
        class: "text-slate-500 dark:text-zinc-400 gap-1!",
        onclick: () => replying = !replying,
        disabled: comment.post.locked || disabled || !profile.current.jwt,
        icon: ChatBubbleOvalLeft,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("comment.reply"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if (profile.current?.user && (profile.isMod(comment.community) || profile.isAdmin)) {
        $$renderer3.push("<!--[-->");
        {
          let target = function($$renderer4, attachment) {
            Button($$renderer4, {
              class: "dark:text-zinc-400 text-slate-600",
              color: "tertiary",
              size: "square-md",
              rounding: "pill",
              icon: ShieldCheck,
              "aria-label": store_get($$store_subs ??= {}, "$t", t)("moderation.label")
            });
          };
          CommentModerationMenu($$renderer3, {
            get item() {
              return comment;
            },
            set item($$value) {
              comment = $$value;
              $$settled = false;
            },
            target,
            $$slots: { target: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      {
        let target = function($$renderer4, attachment) {
          Button($$renderer4, {
            title: store_get($$store_subs ??= {}, "$t", t)("comment.actions.label"),
            color: "tertiary",
            rounding: "pill",
            size: "square-md",
            class: "text-slate-600 dark:text-zinc-400",
            icon: EllipsisHorizontal
          });
        };
        Menu($$renderer3, {
          placement: "bottom",
          target,
          children: ($$renderer4) => {
            MenuButton($$renderer4, {
              onclick: () => {
                if (navigator.share) navigator.share?.({ url: comment.comment.ap_id });
                else navigator.clipboard.writeText(comment.comment.ap_id);
              },
              icon: Share,
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.actions.more.share"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            if (profile.current?.jwt) {
              $$renderer4.push("<!--[-->");
              if (comment.creator.id == profile.current.user?.local_user_view.person.id) {
                $$renderer4.push("<!--[-->");
                MenuButton($$renderer4, {
                  onclick: () => onedit?.(comment),
                  icon: PencilSquare,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.actions.more.edit"))}`);
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> `);
              MenuButton($$renderer4, {
                onclick: async () => {
                  if (profile.current?.jwt) comment.saved = await save(comment, !comment.saved);
                },
                icon: comment.saved ? BookmarkSlash : Bookmark,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(comment.saved ? store_get($$store_subs ??= {}, "$t", t)("post.actions.unsave") : store_get($$store_subs ??= {}, "$t", t)("post.actions.save"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              if (profile.current?.user && profile.current.jwt && profile.current.user.local_user_view.person.id == comment.creator.id) {
                $$renderer4.push("<!--[-->");
                MenuButton($$renderer4, {
                  color: "danger-subtle",
                  onclick: async () => {
                    if (profile.current?.jwt) comment.comment.deleted = await deleteItem(comment, !comment.comment.deleted);
                  },
                  icon: Trash,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(comment.comment.deleted ? store_get($$store_subs ??= {}, "$t", t)("post.actions.more.restore") : store_get($$store_subs ??= {}, "$t", t)("post.actions.more.delete"))}`);
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> `);
              if (profile.current.jwt && profile.current.user?.local_user_view.person.id != comment.creator.id) {
                $$renderer4.push("<!--[-->");
                MenuButton($$renderer4, {
                  onclick: () => report(comment),
                  color: "danger-subtle",
                  icon: Flag,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.report"))}`);
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { target: true, default: true }
        });
      }
      $$renderer3.push(`<!----> <div class="flex-1 w-full"></div></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { comment, replying });
  });
}
function CommentForm($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      postId,
      parentId = void 0,
      locked = false,
      banned = false,
      rows = 7,
      placeholder = void 0,
      value = "",
      actions = true,
      preview: previewAction = true,
      editing = false,
      oncancel,
      oncomment,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    let loading = false;
    let language = void 0;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<form class="flex flex-col gap-2 relative">`);
      {
        $$renderer3.push("<!--[!-->");
        MarkdownEditor($$renderer3, spread_props([
          rest,
          {
            rows,
            placeholder: locked ? store_get($$store_subs ??= {}, "$t", t)("comment.locked") : banned ? store_get($$store_subs ??= {}, "$t", t)("comment.banned") : placeholder ?? placeholders.get("comment"),
            disabled: locked || loading || banned,
            previewButton: previewAction,
            get value() {
              return value;
            },
            set value($$value) {
              value = $$value;
              $$settled = false;
            },
            children: ($$renderer4) => {
              {
                let target = function($$renderer5, attachment) {
                  Button($$renderer5, {
                    size: "custom",
                    rounding: "xl",
                    class: "w-7.5 h-7.5",
                    color: language != void 0 ? "primary" : "ghost",
                    title: store_get($$store_subs ??= {}, "$t", t)("form.profile.languages.title"),
                    children: ($$renderer6) => {
                      Icon($$renderer6, { src: Language, size: "14", micro: true });
                    },
                    $$slots: { default: true }
                  });
                };
                Menu($$renderer4, {
                  target,
                  children: ($$renderer5) => {
                    if (site.data) {
                      $$renderer5.push("<!--[-->");
                      MenuButton($$renderer5, {
                        class: "min-h-[16px] py-0",
                        onclick: () => language = void 0,
                        children: ($$renderer6) => {
                          Icon($$renderer6, { src: XMark, size: "16", micro: true });
                          $$renderer6.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.post.unset"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer5.push(`<!----> <!--[-->`);
                      const each_array = ensure_array_like(site.data?.all_languages);
                      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                        let languageOption = each_array[$$index];
                        MenuButton($$renderer5, {
                          class: "min-h-[16px] py-0",
                          onclick: () => {
                            language = languageOption.id;
                          },
                          children: ($$renderer6) => {
                            $$renderer6.push(`<!---->${escape_html(languageOption.name)}`);
                          },
                          $$slots: { default: true }
                        });
                      }
                      $$renderer5.push(`<!--]-->`);
                    } else {
                      $$renderer5.push("<!--[!-->");
                    }
                    $$renderer5.push(`<!--]-->`);
                  },
                  $$slots: { target: true, default: true }
                });
              }
              $$renderer4.push(`<!----> <div class="flex-1"></div> `);
              if (actions) {
                $$renderer4.push("<!--[-->");
                Button($$renderer4, {
                  size: "custom",
                  title: store_get($$store_subs ??= {}, "$t", t)("common.cancel"),
                  onclick: () => oncancel?.(true),
                  color: "tertiary",
                  class: "w-8 h-8",
                  rounding: "xl",
                  children: ($$renderer5) => {
                    Icon($$renderer5, {
                      src: XMark,
                      size: "16",
                      micro: true,
                      class: "text-slate-600 dark:text-zinc-400"
                    });
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> `);
                Button($$renderer4, {
                  submit: true,
                  color: "primary",
                  rounding: "xl",
                  loading,
                  disabled: locked || loading || banned,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!---->`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { default: true }
          }
        ]));
      }
      $$renderer3.push(`<!--]--></form>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { value });
  });
}
function Comment($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      node = void 0,
      actions = true,
      meta = true,
      replying = false,
      open = true,
      contentClass = "",
      class: clazz = "",
      metaSuffix,
      children
    } = $$props;
    let editing = false;
    let newComment = node.comment_view.comment.content;
    let editingLoad = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (editing) {
        $$renderer3.push("<!--[-->");
        {
          let customTitle = function($$renderer4) {
            $$renderer4.push(`<div>${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.edit"))}</div>`);
          };
          Modal($$renderer3, {
            get open() {
              return editing;
            },
            set open($$value) {
              editing = $$value;
              $$settled = false;
            },
            customTitle,
            children: ($$renderer4) => {
              $$renderer4.push(`<form class="contents">`);
              CommentForm($$renderer4, {
                postId: node.comment_view.comment.id,
                actions: false,
                preview: true,
                get value() {
                  return newComment;
                },
                set value($$value) {
                  newComment = $$value;
                  $$settled = false;
                }
              });
              $$renderer4.push(`<!----> `);
              Button($$renderer4, {
                submit: true,
                color: "primary",
                size: "lg",
                loading: editingLoad,
                disabled: editingLoad,
                class: "w-full",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></form>`);
            },
            $$slots: { customTitle: true, default: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <li${attr_class(clsx(["py-3 relative", clazz]), "svelte-1te8jrp")}${attr("id", node.comment_view.comment.id.toString())}>`);
      if (meta) {
        $$renderer3.push("<!--[-->");
        const creatorIsOp = node.comment_view.creator.id == node.comment_view.post.creator_id;
        $$renderer3.push(`<label${attr("for", `comment-expand-${stringify(node.comment_view.comment.id)}`)} class="flex flex-row cursor-pointer gap-2 items-center group text-sm flex-wrap w-full z-0 group relative svelte-1te8jrp"><div${attr_class(clsx([
          "absolute -inset-0.5 right-1 group-hover:right-0 group-hover:-inset-1.5 opacity-0 group-hover:opacity-100 transition-all",
          "bg-slate-100 dark:bg-zinc-900 -z-10 rounded-full inline-flex items-center justify-end"
        ]))}>`);
        if (node.comment_view.counts.child_count > 0) {
          $$renderer3.push("<!--[-->");
          const children2 = node.comment_view.counts.child_count;
          $$renderer3.push(`<div${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("aria.comments.children", { childCount: children2 }))} class="font-medium">${escape_html(children2)}</div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> <div${attr_class(clsx([
          !open && "rotate-90",
          "transition-all duration-500 ease-out my-auto h-full w-8 grid place-items-center"
        ]))}>`);
        Icon($$renderer3, { src: open ? Minus : Plus, size: "16", micro: true });
        $$renderer3.push(`<!----></div></div> `);
        metaSuffix?.($$renderer3);
        $$renderer3.push(`<!----> <span${attr_class(clsx([
          "flex flex-row gap-1 items-center",
          creatorIsOp && "text-blue-600 dark:text-blue-400 font-bold"
        ]))}>`);
        {
          let extraBadges = function($$renderer4) {
            if (node.comment_view.creator_is_moderator) {
              $$renderer4.push("<!--[-->");
              Icon($$renderer4, {
                src: ShieldCheck,
                size: "16",
                micro: true,
                class: "text-green-500",
                "aria-label": store_get($$store_subs ??= {}, "$t", t)("class.moderator")
              });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> `);
            if (node.comment_view.creator_is_admin) {
              $$renderer4.push("<!--[-->");
              Icon($$renderer4, {
                src: ShieldCheck,
                size: "16",
                micro: true,
                class: "text-red-500",
                "aria-label": store_get($$store_subs ??= {}, "$t", t)("class.admin")
              });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          };
          UserLink($$renderer3, {
            inComment: true,
            avatarSize: 20,
            avatar: true,
            user: node.comment_view.creator,
            extraBadges
          });
        }
        $$renderer3.push(`<!----> `);
        if (creatorIsOp) {
          $$renderer3.push("<!--[-->");
          Icon($$renderer3, {
            mini: true,
            size: "16",
            src: Microphone,
            class: "text-blue-500 dark:text-blue-400"
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></span> `);
        RelativeDate($$renderer3, {
          class: "text-slate-600 dark:text-zinc-400",
          date: publishedToDate(node.comment_view.comment.published)
        });
        $$renderer3.push(`<!----> <span class="text-slate-600 dark:text-zinc-400 flex flex-row gap-2 ml-1">`);
        if (node.comment_view.comment.updated) {
          $$renderer3.push("<!--[-->");
          const edited = store_get($$store_subs ??= {}, "$t", t)("post.meta.lastEdited", {
            default: formatRelativeDate(publishedToDate(node.comment_view.comment.updated), { style: "long" })
          });
          $$renderer3.push(`<div${attr("title", edited)}>`);
          Icon($$renderer3, { src: Pencil, micro: true, size: "14" });
          $$renderer3.push(`<!----></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (node.comment_view.comment.deleted) {
          $$renderer3.push("<!--[-->");
          Icon($$renderer3, {
            src: Trash,
            solid: true,
            size: "12",
            "aria-label": store_get($$store_subs ??= {}, "$t", t)("post.badges.deleted"),
            class: "text-red-600 dark:text-red-500"
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (node.comment_view.comment.removed) {
          $$renderer3.push("<!--[-->");
          Icon($$renderer3, {
            src: Trash,
            solid: true,
            size: "12",
            "aria-label": store_get($$store_subs ??= {}, "$t", t)("post.badges.removed"),
            class: "text-green-600 dark:text-green-500"
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (node.comment_view.saved) {
          $$renderer3.push("<!--[-->");
          Icon($$renderer3, {
            src: Bookmark,
            solid: true,
            size: "12",
            "aria-label": store_get($$store_subs ??= {}, "$t", t)("post.badges.saved"),
            class: "text-yellow-600 dark:text-yellow-500"
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></span> `);
        if (settings.debugInfo) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<span class="text-slate-600 dark:text-zinc-400 font-mono ml-auto">#${escape_html(node.comment_view.comment.id)}</span>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></label>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <input class="appearance-none absolute top-0 left-0 h-8 w-full pointer-events-none comment-expand svelte-1te8jrp" type="checkbox"${attr("id", `comment-expand-${stringify(node.comment_view.comment.id)}`)}${attr("checked", open, true)}/> <div${attr_class(clsx(["expand max-w-full", contentClass]), "svelte-1te8jrp")}${attr("inert", !open, true)}><div id="comment-content" class="svelte-1te8jrp"><div${attr_class(clsx([
        "flex flex-col whitespace-pre-wrap max-w-full gap-1 mt-1 relative w-full"
      ]))}>`);
      Markdown($$renderer3, {
        source: node.comment_view.comment.content,
        noStyle: true,
        class: [
          "text-[15px] sm:text-base text-slate-700 dark:text-zinc-300 *:leading-[1.6] break-words space-y-3",
          node.comment_view.comment.distinguished ? "material-success px-3 py-1.5 rounded-xl max-w-max" : page.url.hash.slice(1) == node.comment_view.comment.id.toString() && "material-info px-3 py-1.5 rounded-xl max-w-max"
        ]
      });
      $$renderer3.push(`<!----> `);
      if (actions) {
        $$renderer3.push("<!--[-->");
        CommentActions($$renderer3, {
          comment: node.comment_view,
          onedit: () => editing = true,
          disabled: node.comment_view.banned_from_community || node.comment_view.post.locked,
          get replying() {
            return replying;
          },
          set replying($$value) {
            replying = $$value;
            $$settled = false;
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> `);
      if (replying) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div>`);
        CommentForm($$renderer3, {
          label: store_get($$store_subs ??= {}, "$t", t)("comment.reply"),
          postId: node.comment_view.post.id,
          parentId: node.comment_view.comment.id,
          oncomment: (e) => {
            node.children = [
              {
                children: [],
                comment_view: e.comment_view,
                depth: node.depth + 1,
                expanded: true
              },
              ...node.children
            ];
            replying = false;
          },
          oncancel: () => replying = false
        });
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      children?.($$renderer3);
      $$renderer3.push(`<!----></div></div></li>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { node, replying, open });
  });
}
export {
  Comment as C,
  CommentForm as a
};
//# sourceMappingURL=Comment.js.map
