import { a as attr_class, c as clsx, k as stringify, e as escape_html, s as store_get, l as spread_props, u as unsubscribe_stores } from "./index3.js";
import { t } from "./index.js";
import { q as publishedToDate, B as Button } from "./client.svelte.js";
import { I as Icon } from "./Icon.js";
import { A as ArrowUturnUp } from "./ArrowUturnUp.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import "./settings.svelte.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { P as PostMeta } from "./PostVote.js";
import { C as Comment } from "./Comment.js";
function CommentItem($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      comment,
      community = false,
      meta = true,
      class: clazz = "",
      commentClass = "",
      actions = true,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    $$renderer2.push(`<div${attr_class(clsx(["flex flex-col flex-1 rounded-none list-none", clazz]))} color="none" padding="none">`);
    if (meta) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="flex flex-row justify-between items-center gap-2"><div class="flex flex-col gap-2">`);
      PostMeta($$renderer2, {
        badges: {
          nsfw: comment.post.nsfw,
          removed: comment.post.removed,
          admin: false,
          moderator: false,
          saved: false,
          deleted: comment.post.deleted,
          featured: comment.post.featured_community || comment.post.featured_local,
          locked: comment.post.locked
        },
        published: publishedToDate(comment.comment.published),
        community: community ? comment.community : void 0,
        title: comment.post.name,
        id: comment.post.id,
        titleClass: "text-sm text-slate-500 dark:text-zinc-400"
      });
      $$renderer2.push(`<!----></div> `);
      Button($$renderer2, {
        color: "primary",
        rounding: "pill",
        size: "sm",
        href: `/comment/${stringify(comment.comment.id)}`,
        class: "self-start",
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.jump"))} `);
          Icon($$renderer3, { src: ArrowUturnUp, size: "14", micro: true });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    Comment($$renderer2, spread_props([
      {
        postId: comment.post.id,
        node: {
          children: [],
          comment_view: comment,
          depth: 1,
          expanded: true
        },
        replying: false,
        meta,
        actions
      },
      rest,
      { class: commentClass }
    ]));
    $$renderer2.push(`<!----></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  CommentItem as C
};
//# sourceMappingURL=CommentItem.js.map
