import { a as attr_class, c as clsx, b as attr, e as escape_html } from "./index3.js";
import { h as Avatar } from "./client.svelte.js";
function CommonItem($$renderer, $$props) {
  let {
    href,
    icon,
    title,
    detail,
    children,
    orientation = "horizontal"
  } = $$props;
  $$renderer.push(`<div${attr_class(clsx([
    "flex gap-2 p-5",
    orientation == "horizontal" ? "flex-row items-center" : "flex-col items-staRT"
  ]))}>`);
  Avatar($$renderer, {
    url: icon,
    alt: title,
    width: detail ? 32 : 24,
    circle: false
  });
  $$renderer.push(`<!----> <a class="flex-1 flex flex-col group"${attr("href", href)}><h3 class="font-medium text-base overflow-hidden text-ellipsis leading-5">${escape_html(title)}</h3> <p class="text-sm text-slate-600 dark:text-zinc-400">${escape_html(detail)}</p></a> <div class="flex flex-row gap-2 items-center">`);
  children?.($$renderer);
  $$renderer.push(`<!----></div></div>`);
}
export {
  CommonItem as C
};
//# sourceMappingURL=CommonItem.js.map
