import { d as ensure_array_like, a as attr_class, j as attr_style, c as clsx, k as stringify } from "./index3.js";
import "./client.svelte.js";
function CommonList($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    const sizeDelay = { lg: 120, md: 80, sm: 40, xs: 0 };
    let {
      items,
      item: itemSnippet,
      children,
      animate = true,
      size = "sm",
      class: clazz,
      selected
    } = $$props;
    $$renderer2.push(`<ul class="svelte-1frsf38">`);
    if (items) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<!--[-->`);
      const each_array = ensure_array_like(items);
      for (let index = 0, $$length = each_array.length; index < $$length; index++) {
        let item = each_array[index];
        $$renderer2.push(`<li${attr_class(
          clsx([
            "group/li",
            animate && "animate",
            size == "xs" && "xs",
            selected?.(item) && "selected",
            clazz
          ]),
          "svelte-1frsf38"
        )}${attr_style(`--i: ${stringify(index < 10 ? index * sizeDelay[size] : 0)}ms;`)}>`);
        itemSnippet?.($$renderer2, item, index);
        $$renderer2.push(`<!----></li>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    children?.($$renderer2);
    $$renderer2.push(`<!----></ul>`);
  });
}
export {
  CommonList as C
};
//# sourceMappingURL=CommonList.js.map
