import { s as store_get, e as escape_html, u as unsubscribe_stores, f as bind_props, g as await_block, a as attr_class, c as clsx, k as stringify, b as attr } from "./index3.js";
import { E as EntityHeader } from "./EntityHeader.js";
import { B as Button, p as profile, o as Plus, c as client, f as fullCommunityName, N as NoSymbol, E as Expandable, i as Markdown, u as userLink, y as Spinner, a as getClient, t as toast, e as errorMessage, a1 as removeToast } from "./client.svelte.js";
import { t } from "./index.js";
import { s as settings } from "./settings.svelte.js";
import { I as ItemList } from "./ItemList.js";
import { L as LabelStat } from "./LabelStat.js";
import { E as EndPlaceholder } from "./EndPlaceholder.js";
import { S as SidebarButton } from "./SidebarButton.js";
import { I as Icon } from "./Icon.js";
import { C as Check } from "./Check.js";
import { C as Cog6Tooth } from "./Cog6Tooth.js";
import { E as EllipsisHorizontal } from "./EllipsisHorizontal.js";
import { F as Fire } from "./Fire.js";
import { N as Newspaper } from "./Newspaper.js";
import { S as ShieldCheck } from "./ShieldCheck.js";
import { T as Tag } from "./Tag.js";
import { M as Modal } from "./Modal.js";
import { m as modal, a as action } from "./modal2.js";
import { M as Menu, a as MenuButton } from "./MenuButton.js";
import { a as addSubscription } from "./index6.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { T as TextInput } from "./TextInput.js";
const BuildingOffice2 = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M1.75 2a.75.75 0 0 0 0 1.5H2v9h-.25a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 .75-.75v-1.5a.75.75 0 0 1 .75-.75h1.5a.75.75 0 0 1 .75.75v1.5c0 .414.336.75.75.75h.5a.75.75 0 0 0 .75-.75V3.5h.25a.75.75 0 0 0 0-1.5h-7.5ZM3.5 5.5A.5.5 0 0 1 4 5h.5a.5.5 0 0 1 .5.5V6a.5.5 0 0 1-.5.5H4a.5.5 0 0 1-.5-.5v-.5Zm.5 2a.5.5 0 0 0-.5.5v.5A.5.5 0 0 0 4 9h.5a.5.5 0 0 0 .5-.5V8a.5.5 0 0 0-.5-.5H4Zm2-2a.5.5 0 0 1 .5-.5H7a.5.5 0 0 1 .5.5V6a.5.5 0 0 1-.5.5h-.5A.5.5 0 0 1 6 6v-.5Zm.5 2A.5.5 0 0 0 6 8v.5a.5.5 0 0 0 .5.5H7a.5.5 0 0 0 .5-.5V8a.5.5 0 0 0-.5-.5h-.5ZM11.5 6a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h2.75a.75.75 0 0 0 0-1.5H14v-5h.25a.75.75 0 0 0 0-1.5H11.5Zm.5 1.5h.5a.5.5 0 0 1 .5.5v.5a.5.5 0 0 1-.5.5H12a.5.5 0 0 1-.5-.5V8a.5.5 0 0 1 .5-.5Zm0 2.5a.5.5 0 0 0-.5.5v.5a.5.5 0 0 0 .5.5h.5a.5.5 0 0 0 .5-.5v-.5a.5.5 0 0 0-.5-.5H12Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M1 2.75A.75.75 0 0 1 1.75 2h10.5a.75.75 0 0 1 0 1.5H12v13.75a.75.75 0 0 1-.75.75h-1.5a.75.75 0 0 1-.75-.75v-2.5a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0-.75.75v2.5a.75.75 0 0 1-.75.75h-2.5a.75.75 0 0 1 0-1.5H2v-13h-.25A.75.75 0 0 1 1 2.75ZM4 5.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1ZM4.5 9a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1ZM8 5.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1ZM8.5 9a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1ZM14.25 6a.75.75 0 0 0-.75.75V17a1 1 0 0 0 1 1h3.75a.75.75 0 0 0 0-1.5H18v-9h.25a.75.75 0 0 0 0-1.5h-4Zm.5 3.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1Zm.5 3.5a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M2.25 21h19.5m-18-18v18m10.5-18v18m6-13.5V21M6.75 6.75h.75m-.75 3h.75m-.75 3h.75m3-6h.75m-.75 3h.75m-.75 3h.75M6.75 21v-3.375c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21M3 3h12m-.75 4.5H21m-3.75 3.75h.008v.008h-.008v-.008Zm0 3h.008v.008h-.008v-.008Zm0 3h.008v.008h-.008v-.008Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3 2.25a.75.75 0 0 0 0 1.5v16.5h-.75a.75.75 0 0 0 0 1.5H15v-18a.75.75 0 0 0 0-1.5H3ZM6.75 19.5v-2.25a.75.75 0 0 1 .75-.75h3a.75.75 0 0 1 .75.75v2.25a.75.75 0 0 1-.75.75h-3a.75.75 0 0 1-.75-.75ZM6 6.75A.75.75 0 0 1 6.75 6h.75a.75.75 0 0 1 0 1.5h-.75A.75.75 0 0 1 6 6.75ZM6.75 9a.75.75 0 0 0 0 1.5h.75a.75.75 0 0 0 0-1.5h-.75ZM6 12.75a.75.75 0 0 1 .75-.75h.75a.75.75 0 0 1 0 1.5h-.75a.75.75 0 0 1-.75-.75ZM10.5 6a.75.75 0 0 0 0 1.5h.75a.75.75 0 0 0 0-1.5h-.75Zm-.75 3.75A.75.75 0 0 1 10.5 9h.75a.75.75 0 0 1 0 1.5h-.75a.75.75 0 0 1-.75-.75ZM10.5 12a.75.75 0 0 0 0 1.5h.75a.75.75 0 0 0 0-1.5h-.75ZM16.5 6.75v15h5.25a.75.75 0 0 0 0-1.5H21v-12a.75.75 0 0 0 0-1.5h-4.5Zm1.5 4.5a.75.75 0 0 1 .75-.75h.008a.75.75 0 0 1 .75.75v.008a.75.75 0 0 1-.75.75h-.008a.75.75 0 0 1-.75-.75v-.008Zm.75 2.25a.75.75 0 0 0-.75.75v.008c0 .414.336.75.75.75h.008a.75.75 0 0 0 .75-.75v-.008a.75.75 0 0 0-.75-.75h-.008ZM18 17.25a.75.75 0 0 1 .75-.75h.008a.75.75 0 0 1 .75.75v.008a.75.75 0 0 1-.75.75h-.008a.75.75 0 0 1-.75-.75v-.008Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function CommunityFlair($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { flair: passedFlair = "", community, onsubmit } = $$props;
    let flair = passedFlair;
    let loading = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<form class="contents">`);
      TextInput($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("nav.commands.content"),
        required: true,
        get value() {
          return flair;
        },
        set value($$value) {
          flair = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      Button($$renderer3, {
        loading,
        submit: true,
        color: "primary",
        size: "lg",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></form>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
async function block(id, block2) {
  try {
    const loading = toast({ content: ``, loading: true });
    await getClient().blockCommunity({ community_id: id, block: block2 });
    removeToast(loading);
    toast({
      content: !block2 ? t.get("toast.unblockedCommunity") : t.get("toast.blockedCommunity"),
      type: "success"
    });
    return block2;
  } catch (err) {
    toast({ content: errorMessage(err), type: "error" });
    return !block2;
  }
}
async function purgeCommunity(id) {
  const purgeToast = toast({ content: "", loading: true });
  try {
    await client().purgeCommunity({ community_id: id });
    removeToast(purgeToast);
    toast({ content: t.get("toast.purgedCommunity"), type: "success" });
  } catch (err) {
    toast({ content: errorMessage(err), type: "error" });
  }
}
async function blockInstance(id) {
  try {
    const loading = toast({ content: ``, loading: true });
    await getClient().blockInstance({ instance_id: id, block: true });
    removeToast(loading);
    toast({
      content: `Successfully blocked that instance.`,
      type: "success"
    });
  } catch (err) {
    toast({ content: errorMessage(err), type: "error" });
  }
}
function CommunityCard($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let loading = { subscribing: false };
    async function subscribe(community) {
      if (!profile.current?.jwt) return;
      loading.subscribing = true;
      const subscribed = community.subscribed == "Subscribed" || community.subscribed == "Pending";
      try {
        await getClient().followCommunity({ community_id: community.community.id, follow: !subscribed });
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
      community.subscribed = subscribed ? "NotSubscribed" : "Subscribed";
      addSubscription(community.community, !subscribed);
      loading.subscribing = false;
    }
    let setFlair = false;
    let { community_view = void 0, moderators = [], class: clazz = "" } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      await_block(
        $$renderer3,
        community_view,
        () => {
          $$renderer3.push(`<div class="w-full h-full grid place-items-center" role="status"${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("aria.loading"))}>`);
          Spinner($$renderer3, { width: 24 });
          $$renderer3.push(`<!----></div>`);
        },
        (community_view2) => {
          Modal($$renderer3, {
            title: store_get($$store_subs ??= {}, "$t", t)("cards.community.flair"),
            get open() {
              return setFlair;
            },
            set open($$value) {
              setFlair = $$value;
              $$settled = false;
            },
            children: ($$renderer4) => {
              CommunityFlair($$renderer4, {
                community: community_view2.community.id,
                onsubmit: () => setFlair = !setFlair
              });
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> <aside${attr_class(clsx([
            "min-w-full pt-0 text-slate-600 dark:text-zinc-400 flex flex-col gap-1",
            clazz
          ]))}>`);
          {
            let nameDetail = function($$renderer4) {
              $$renderer4.push(`<!---->!${escape_html(fullCommunityName(community_view2.community.name, community_view2.community.actor_id))}`);
            };
            EntityHeader($$renderer3, {
              name: community_view2.community.title,
              avatar: community_view2.community.icon,
              banner: community_view2.community.banner,
              avatarCircle: false,
              nameDetail,
              $$slots: { nameDetail: true }
            });
          }
          $$renderer3.push(`<!----> `);
          EndPlaceholder($$renderer3, {
            size: "xs",
            margin: "sm",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.post.community"))}`);
            }
          });
          $$renderer3.push(`<!----> `);
          if (profile.current?.jwt) {
            $$renderer3.push("<!--[-->");
            const subscribed = profile.current.user?.follows.some((i) => i.community.id == community_view2.community.id);
            Button($$renderer3, {
              disabled: loading.subscribing,
              loading: loading.subscribing,
              size: "md",
              color: subscribed ? "secondary" : "primary",
              onclick: () => subscribe(community_view2),
              class: "px-4 relative z-[inherit]",
              alignment: "left",
              icon: community_view2.subscribed == "Subscribed" ? Check : Plus,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(subscribed ? store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribed") : store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribe"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            if (client().setFlair) {
              $$renderer3.push("<!--[-->");
              SidebarButton($$renderer3, {
                onclick: () => setFlair = !setFlair,
                icon: Tag,
                label: store_get($$store_subs ??= {}, "$t", t)("cards.community.flair")
              });
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]-->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (profile.isMod(community_view2.community)) {
            $$renderer3.push("<!--[-->");
            SidebarButton($$renderer3, {
              href: `/c/${stringify(fullCommunityName(community_view2.community.name, community_view2.community.actor_id))}/settings`,
              icon: Cog6Tooth,
              label: store_get($$store_subs ??= {}, "$t", t)("routes.profile.edit")
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          {
            let target = function($$renderer4, attachment) {
              SidebarButton($$renderer4, {
                label: store_get($$store_subs ??= {}, "$t", t)("post.actions.more.label"),
                icon: EllipsisHorizontal
              });
            };
            Menu($$renderer3, {
              placement: "bottom-start",
              target,
              children: ($$renderer4) => {
                MenuButton($$renderer4, {
                  href: `/modlog?community=${stringify(community_view2.community.id)}`,
                  children: ($$renderer5) => {
                    Icon($$renderer5, { src: Newspaper, size: "16", mini: true });
                    $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.modlog"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer4.push(`<!----> `);
                if (profile.current?.jwt) {
                  $$renderer4.push("<!--[-->");
                  if (profile.isMod(community_view2.community)) {
                    $$renderer4.push("<!--[-->");
                    MenuButton($$renderer4, {
                      color: "success-subtle",
                      href: `/moderation?community=${stringify(community_view2.community.id)}`,
                      children: ($$renderer5) => {
                        Icon($$renderer5, { src: ShieldCheck, size: "16", micro: true });
                        $$renderer5.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.feed"))}`);
                      },
                      $$slots: { default: true }
                    });
                  } else {
                    $$renderer4.push("<!--[!-->");
                  }
                  $$renderer4.push(`<!--]--> `);
                  MenuButton($$renderer4, {
                    color: "danger-subtle",
                    size: "lg",
                    onclick: () => block(community_view2.community.id, !community_view2.blocked),
                    icon: NoSymbol,
                    children: ($$renderer5) => {
                      $$renderer5.push(`<!---->${escape_html(community_view2.blocked ? store_get($$store_subs ??= {}, "$t", t)("cards.community.unblock") : store_get($$store_subs ??= {}, "$t", t)("cards.community.block"))}`);
                    },
                    $$slots: { default: true }
                  });
                  $$renderer4.push(`<!----> `);
                  if (profile.current?.user) {
                    $$renderer4.push("<!--[-->");
                    MenuButton($$renderer4, {
                      color: "danger-subtle",
                      size: "lg",
                      onclick: () => blockInstance(community_view2.community.instance_id),
                      icon: BuildingOffice2,
                      children: ($$renderer5) => {
                        $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.blockInstance"))}`);
                      },
                      $$slots: { default: true }
                    });
                  } else {
                    $$renderer4.push("<!--[!-->");
                  }
                  $$renderer4.push(`<!--]--> `);
                  if (profile.isAdmin) {
                    $$renderer4.push("<!--[-->");
                    MenuButton($$renderer4, {
                      color: "danger-subtle",
                      onclick: () => modal({
                        title: store_get($$store_subs ??= {}, "$t", t)("admin.purgeCommunity.title"),
                        body: `${community_view2.community.title}: ${store_get($$store_subs ??= {}, "$t", t)("admin.purgeCommunity.warning")}`,
                        actions: [
                          action({
                            close: true,
                            content: store_get($$store_subs ??= {}, "$t", t)("common.cancel")
                          }),
                          action({
                            action: () => purgeCommunity(community_view2.community.id),
                            close: true,
                            content: store_get($$store_subs ??= {}, "$t", t)("admin.purge"),
                            type: "danger",
                            icon: Fire
                          })
                        ],
                        dismissable: true,
                        type: "error"
                      }),
                      icon: Fire,
                      children: ($$renderer5) => {
                        $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("admin.purge"))}`);
                      },
                      $$slots: { default: true }
                    });
                  } else {
                    $$renderer4.push("<!--[!-->");
                  }
                  $$renderer4.push(`<!--]-->`);
                } else {
                  $$renderer4.push("<!--[!-->");
                }
                $$renderer4.push(`<!--]-->`);
              },
              $$slots: { target: true, default: true }
            });
          }
          $$renderer3.push(`<!----> `);
          EndPlaceholder($$renderer3, {
            size: "xs",
            margin: "sm",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.site.stats"))}`);
            }
          });
          $$renderer3.push(`<!----> <div class="flex flex-row gap-4 flex-wrap px-3">`);
          LabelStat($$renderer3, {
            label: store_get($$store_subs ??= {}, "$t", t)("cards.community.members"),
            content: community_view2.counts.subscribers.toString(),
            formatted: true
          });
          $$renderer3.push(`<!----> `);
          LabelStat($$renderer3, {
            label: store_get($$store_subs ??= {}, "$t", t)("content.posts"),
            content: community_view2.counts.posts.toString(),
            formatted: true
          });
          $$renderer3.push(`<!----> `);
          LabelStat($$renderer3, {
            label: store_get($$store_subs ??= {}, "$t", t)("cards.community.activeDay"),
            content: community_view2.counts.users_active_day.toString(),
            formatted: true
          });
          $$renderer3.push(`<!----></div> `);
          EndPlaceholder($$renderer3, {
            size: "xs",
            margin: "sm",
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.info"))}`);
            }
          });
          $$renderer3.push(`<!----> <div class="space-y-3 px-1.5 text-sm">`);
          {
            let title = function($$renderer4) {
              $$renderer4.push(`<span class="px-2 py-1 w-full">${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.site.about"))}</span>`);
            };
            Expandable($$renderer3, {
              get open() {
                return settings.expand.about;
              },
              set open($$value) {
                settings.expand.about = $$value;
                $$settled = false;
              },
              title,
              children: ($$renderer4) => {
                Markdown($$renderer4, { source: community_view2.community.description });
              },
              $$slots: { title: true, default: true }
            });
          }
          $$renderer3.push(`<!----> `);
          if (moderators && moderators.length > 0) {
            $$renderer3.push("<!--[-->");
            {
              let title = function($$renderer4) {
                $$renderer4.push(`<span class="px-2 py-1 w-full">${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.moderators"))}</span>`);
              };
              Expandable($$renderer3, {
                get open() {
                  return settings.expand.team;
                },
                set open($$value) {
                  settings.expand.team = $$value;
                  $$settled = false;
                },
                title,
                children: ($$renderer4) => {
                  ItemList($$renderer4, {
                    items: moderators.map((i) => ({
                      id: i.moderator.id,
                      name: i.moderator.display_name || i.moderator.name,
                      url: userLink(i.moderator),
                      avatar: i.moderator.avatar,
                      instance: new URL(i.moderator.actor_id).hostname
                    }))
                  });
                },
                $$slots: { title: true, default: true }
              });
            }
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div></aside>`);
        }
      );
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { community_view });
  });
}
export {
  BuildingOffice2 as B,
  CommunityCard as C,
  CommunityFlair as a,
  block as b,
  blockInstance as c,
  purgeCommunity as p
};
//# sourceMappingURL=CommunityCard.js.map
