import { f as bind_props, e as escape_html, s as store_get, d as ensure_array_like, u as unsubscribe_stores } from "./index3.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { M as Material, s as site, b as Badge, o as Plus, B as Button } from "./client.svelte.js";
import { t } from "./index.js";
import { M as MarkdownEditor } from "./MarkdownEditor.js";
import { I as ImageInputUpload } from "./ImageInputUpload.js";
import { H as Header } from "./Header.js";
import { L as Label } from "./Label.js";
import { T as TextInput } from "./TextInput.js";
import { S as Select, O as Option } from "./Select.js";
import { S as Switch } from "./Switch.js";
import { I as Icon } from "./Icon.js";
import { G as GlobeAlt } from "./GlobeAlt.js";
import { M as MapPin } from "./MapPin.js";
import { M as Menu, a as MenuButton } from "./MenuButton.js";
import "./settings.svelte.js";
import "openapi-fetch";
import "@dicebear/core";
import "@dicebear/initials";
function CommunityForm($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      edit = void 0,
      formData: passedFormData = {
        name: "",
        displayName: "",
        sidebar: "",
        nsfw: false,
        postsLockedToModerators: false,
        submitting: false,
        visibility: "Public",
        languages: void 0
      },
      formtitle
    } = $$props;
    let formData = passedFormData;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<form class="flex flex-col gap-4 h-full w-full">`);
      if (formtitle) {
        $$renderer3.push("<!--[-->");
        formtitle($$renderer3);
        $$renderer3.push(`<!---->`);
      } else {
        $$renderer3.push("<!--[!-->");
        Header($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.post.community"))}`);
          }
        });
      }
      $$renderer3.push(`<!--]--> `);
      TextInput($$renderer3, {
        required: true,
        label: store_get($$store_subs ??= {}, "$t", t)("form.name"),
        oninput: () => {
          formData.name = formData.name.toLowerCase().replaceAll(" ", "_");
        },
        disabled: edit != void 0,
        get value() {
          return formData.name;
        },
        set value($$value) {
          formData.name = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      TextInput($$renderer3, {
        required: true,
        label: store_get($$store_subs ??= {}, "$t", t)("form.profile.displayName"),
        get value() {
          return formData.displayName;
        },
        set value($$value) {
          formData.displayName = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> <div class="flex flex-row gap-4 flex-wrap *:flex-1">`);
      ImageInputUpload($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.icon"),
        get imageUrl() {
          return formData.icon;
        },
        set imageUrl($$value) {
          formData.icon = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      ImageInputUpload($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.banner"),
        get imageUrl() {
          return formData.banner;
        },
        set imageUrl($$value) {
          formData.banner = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----></div> `);
      MarkdownEditor($$renderer3, {
        previewButton: true,
        label: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.sidebar"),
        get value() {
          return formData.sidebar;
        },
        set value($$value) {
          formData.sidebar = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      Switch($$renderer3, {
        get checked() {
          return formData.nsfw;
        },
        set checked($$value) {
          formData.nsfw = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.badges.nsfw"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Switch($$renderer3, {
        get checked() {
          return formData.postsLockedToModerators;
        },
        set checked($$value) {
          formData.postsLockedToModerators = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->Only moderators can post`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Select($$renderer3, {
        label: "Visibility",
        class: "w-max",
        get value() {
          return formData.visibility;
        },
        set value($$value) {
          formData.visibility = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          Option($$renderer4, {
            icon: GlobeAlt,
            value: "Public",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->Public`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Option($$renderer4, {
            icon: MapPin,
            value: "LocalOnly",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->Local Only`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> <div class="space-y-1">`);
      Label($$renderer3, {
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.profile.languages.title"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      Material($$renderer3, {
        rounding: "xl",
        color: "uniform",
        class: "dark:bg-zinc-950",
        children: ($$renderer4) => {
          if (site.data) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<div class="flex gap-2 flex-wrap flex-row">`);
            {
              let target = function($$renderer5, attachment) {
                $$renderer5.push(`<button type="button">`);
                Badge($$renderer5, {
                  color: "blue-subtle",
                  children: ($$renderer6) => {
                    Icon($$renderer6, { src: Plus, micro: true, size: "14" });
                    $$renderer6.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.add"))}`);
                  },
                  $$slots: { default: true }
                });
                $$renderer5.push(`<!----></button>`);
              };
              Menu($$renderer4, {
                class: "gap-px",
                target,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!--[-->`);
                  const each_array = ensure_array_like(site.data.all_languages.filter((l) => !formData.languages?.includes(l.id)));
                  for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                    let language = each_array[$$index];
                    MenuButton($$renderer5, {
                      class: "min-h-[16px] py-0",
                      onclick: () => {
                        formData.languages = [...formData.languages ?? [], language.id];
                      },
                      children: ($$renderer6) => {
                        $$renderer6.push(`<!---->${escape_html(language.name)}`);
                      },
                      $$slots: { default: true }
                    });
                  }
                  $$renderer5.push(`<!--]-->`);
                },
                $$slots: { target: true, default: true }
              });
            }
            $$renderer4.push(`<!----> <!--[-->`);
            const each_array_1 = ensure_array_like(formData.languages ?? []);
            for (let index = 0, $$length = each_array_1.length; index < $$length; index++) {
              let languageId = each_array_1[index];
              const language = site.data.all_languages.find((l) => l.id == languageId);
              $$renderer4.push(`<button type="button" class="hover:brightness-150 transition-all">`);
              Badge($$renderer4, {
                class: "cursor-pointer",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(language?.name)}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></button>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div> `);
      Button($$renderer3, {
        submit: true,
        color: "primary",
        size: "lg",
        class: "mt-auto",
        loading: formData.submitting,
        disabled: formData.submitting,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(edit ? store_get($$store_subs ??= {}, "$t", t)("common.save") : store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></form>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { formData: passedFormData });
  });
}
export {
  CommunityForm as C
};
//# sourceMappingURL=CommunityForm.js.map
