import { u as unsubscribe_stores, f as bind_props, s as store_get, l as spread_props, k as stringify, a as attr_class, c as clsx, e as escape_html } from "./index3.js";
import { E as Expandable, u as userLink, p as profile, c as client, B as Button, f as fullCommunityName, N as NoSymbol, q as publishedToDate, o as Plus } from "./client.svelte.js";
import { t } from "./index.js";
import { s as settings } from "./settings.svelte.js";
import { E as EntityHeader } from "./EntityHeader.js";
import { I as ItemList } from "./ItemList.js";
import { I as Icon } from "./Icon.js";
import { a as CommunityFlair, b as block, B as BuildingOffice2, c as blockInstance, p as purgeCommunity } from "./CommunityCard.js";
import { C as Check } from "./Check.js";
import { C as Cog6Tooth } from "./Cog6Tooth.js";
import { E as EllipsisHorizontal } from "./EllipsisHorizontal.js";
import { F as Fire } from "./Fire.js";
import { N as Newspaper } from "./Newspaper.js";
import { S as ShieldCheck } from "./ShieldCheck.js";
import { T as Tag } from "./Tag.js";
import { M as Modal } from "./Modal.js";
import { m as modal, a as action } from "./modal2.js";
import { M as Menu, a as MenuButton } from "./MenuButton.js";
import { f as formatRelativeDate } from "./RelativeDate.js";
import { S as Subscribe } from "./Subscribe.js";
function CommunityHeader($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      community = void 0,
      subscribed = void 0,
      counts = void 0,
      moderators = [],
      blocked = false,
      banner = !(settings.nsfwBlur && community.nsfw),
      class: clazz = "",
      compact,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    let setFlair = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        title: store_get($$store_subs ??= {}, "$t", t)("cards.community.flair"),
        get open() {
          return setFlair;
        },
        set open($$value) {
          setFlair = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          CommunityFlair($$renderer4, {
            community: community.id,
            onsubmit: () => setFlair = !setFlair
          });
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      {
        let nameDetail = function($$renderer4) {
          $$renderer4.push(`<button class="text-sm flex gap-0 items-center">!${escape_html(fullCommunityName(community.name, community.actor_id))}</button>`);
        };
        EntityHeader($$renderer3, spread_props([
          rest,
          {
            compact,
            banner: banner ? community.banner : void 0,
            avatar: community.icon,
            name: community.title,
            url: `/c/${stringify(fullCommunityName(community.name, community.actor_id))}`,
            stats: counts ? [
              {
                name: store_get($$store_subs ??= {}, "$t", t)("cards.community.members"),
                value: counts.subscribers.toString()
              },
              {
                name: store_get($$store_subs ??= {}, "$t", t)("content.posts"),
                value: counts.posts.toString()
              },
              {
                name: store_get($$store_subs ??= {}, "$t", t)("cards.community.activeDay"),
                value: counts.users_active_day.toString()
              },
              {
                name: store_get($$store_subs ??= {}, "$t", t)("stats.created"),
                format: false,
                value: formatRelativeDate(publishedToDate(community.published), { style: "short" }).toString()
              }
            ] : [],
            bio: community.description,
            class: ["tracking-normal", clazz],
            nameDetail,
            children: ($$renderer4) => {
              if (moderators.length > 0) {
                $$renderer4.push("<!--[-->");
                {
                  let title = function($$renderer5) {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.moderators"))} <hr class="flex-1 border-slate-200 dark:border-zinc-800 mx-3"/>`);
                  };
                  Expandable($$renderer4, {
                    class: [compact == "lg" && "lg:hidden"],
                    title,
                    children: ($$renderer5) => {
                      ItemList($$renderer5, {
                        items: moderators.map((m) => ({
                          id: m.moderator.id,
                          name: m.moderator.name,
                          url: userLink(m.moderator),
                          avatar: m.moderator.avatar,
                          instance: new URL(m.moderator.actor_id).hostname
                        }))
                      });
                    },
                    $$slots: { title: true, default: true }
                  });
                }
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> <div${attr_class(clsx([
                "flex items-center gap-2 h-max w-max",
                compact == "lg" && "lg:hidden"
              ]))}>`);
              if (profile.current?.jwt) {
                $$renderer4.push("<!--[-->");
                {
                  let children = function($$renderer5, { subscribe, subscribing }) {
                    Button($$renderer5, {
                      disabled: subscribing,
                      loading: subscribing,
                      color: subscribed == "NotSubscribed" ? "primary" : "secondary",
                      onclick: async () => {
                        subscribed = (await subscribe())?.community_view.subscribed ?? "NotSubscribed";
                      },
                      class: "relative z-[inherit]",
                      size: "lg",
                      icon: subscribed != "NotSubscribed" ? Check : Plus,
                      children: ($$renderer6) => {
                        $$renderer6.push(`<!---->${escape_html(subscribed == "Subscribed" || subscribed == "Pending" ? store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribed") : store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribe"))}`);
                      },
                      $$slots: { default: true }
                    });
                  };
                  Subscribe($$renderer4, {
                    community: {
                      community,
                      banned_from_community: false,
                      blocked: false,
                      counts,
                      subscribed
                    },
                    children
                  });
                }
                $$renderer4.push(`<!----> `);
                if (client().setFlair) {
                  $$renderer4.push("<!--[-->");
                  Button($$renderer4, {
                    size: "square-lg",
                    onclick: () => setFlair = !setFlair,
                    "aria-label": store_get($$store_subs ??= {}, "$t", t)("cards.community.flair"),
                    children: ($$renderer5) => {
                      Icon($$renderer5, { src: Tag, size: "16", micro: true });
                    },
                    $$slots: { default: true }
                  });
                } else {
                  $$renderer4.push("<!--[!-->");
                }
                $$renderer4.push(`<!--]-->`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> `);
              if (profile.current?.user && profile.current.user.moderates.map((c) => c.community.id).includes(community.id)) {
                $$renderer4.push("<!--[-->");
                Button($$renderer4, {
                  color: "secondary",
                  size: "square-lg",
                  href: `/c/${stringify(fullCommunityName(community.name, community.actor_id))}/settings`,
                  children: ($$renderer5) => {
                    Icon($$renderer5, { src: Cog6Tooth, size: "16", mini: true });
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> `);
              {
                let target = function($$renderer5, attachment) {
                  Button($$renderer5, { size: "square-lg", icon: EllipsisHorizontal });
                };
                Menu($$renderer4, {
                  placement: "top-end",
                  target,
                  children: ($$renderer5) => {
                    MenuButton($$renderer5, {
                      href: `/modlog?community=${stringify(community.id)}`,
                      children: ($$renderer6) => {
                        Icon($$renderer6, { src: Newspaper, size: "16", mini: true });
                        $$renderer6.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.modlog"))}`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer5.push(`<!----> `);
                    if (profile.isMod(community)) {
                      $$renderer5.push("<!--[-->");
                      MenuButton($$renderer5, {
                        color: "success-subtle",
                        href: `/moderation?community=${stringify(community.id)}`,
                        children: ($$renderer6) => {
                          Icon($$renderer6, { src: ShieldCheck, size: "16", micro: true });
                          $$renderer6.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.feed"))}`);
                        },
                        $$slots: { default: true }
                      });
                    } else {
                      $$renderer5.push("<!--[!-->");
                    }
                    $$renderer5.push(`<!--]--> `);
                    if (profile.current?.jwt) {
                      $$renderer5.push("<!--[-->");
                      MenuButton($$renderer5, {
                        color: "danger-subtle",
                        size: "lg",
                        onclick: () => block(community.id, !blocked),
                        icon: NoSymbol,
                        children: ($$renderer6) => {
                          $$renderer6.push(`<!---->${escape_html(blocked ? store_get($$store_subs ??= {}, "$t", t)("cards.community.unblock") : store_get($$store_subs ??= {}, "$t", t)("cards.community.block"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer5.push(`<!----> `);
                      MenuButton($$renderer5, {
                        color: "danger-subtle",
                        size: "lg",
                        onclick: () => blockInstance(community.instance_id),
                        icon: BuildingOffice2,
                        children: ($$renderer6) => {
                          $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.blockInstance"))}`);
                        },
                        $$slots: { default: true }
                      });
                      $$renderer5.push(`<!----> `);
                      if (profile.isAdmin) {
                        $$renderer5.push("<!--[-->");
                        MenuButton($$renderer5, {
                          color: "danger-subtle",
                          onclick: () => modal({
                            title: store_get($$store_subs ??= {}, "$t", t)("admin.purgeCommunity.title"),
                            body: `${community.title}: ${store_get($$store_subs ??= {}, "$t", t)("admin.purgeCommunity.warning")}`,
                            actions: [
                              action({
                                close: true,
                                content: store_get($$store_subs ??= {}, "$t", t)("common.cancel")
                              }),
                              action({
                                action: () => purgeCommunity(community.id),
                                close: true,
                                content: store_get($$store_subs ??= {}, "$t", t)("admin.purge"),
                                type: "danger",
                                icon: Fire
                              })
                            ],
                            dismissable: true,
                            type: "error"
                          }),
                          icon: Fire,
                          children: ($$renderer6) => {
                            $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("admin.purge"))}`);
                          },
                          $$slots: { default: true }
                        });
                      } else {
                        $$renderer5.push("<!--[!-->");
                      }
                      $$renderer5.push(`<!--]-->`);
                    } else {
                      $$renderer5.push("<!--[!-->");
                    }
                    $$renderer5.push(`<!--]-->`);
                  },
                  $$slots: { target: true, default: true }
                });
              }
              $$renderer4.push(`<!----></div>`);
            },
            $$slots: { nameDetail: true, default: true }
          }
        ]));
      }
      $$renderer3.push(`<!---->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { community, subscribed });
  });
}
export {
  CommunityHeader as default
};
//# sourceMappingURL=CommunityHeader.js.map
