import { k as stringify, s as store_get, a as attr_class, c as clsx, e as escape_html, u as unsubscribe_stores, f as bind_props } from "./index3.js";
import { N as NoSymbol, B as Button, S as SvelteURL, f as fullCommunityName, o as Plus, c as client, p as profile } from "./client.svelte.js";
import { t, c as locale } from "./index.js";
import { C as CommonItem } from "./CommonItem.js";
import { I as Icon } from "./Icon.js";
import { C as Check } from "./Check.js";
import { E as ExclamationTriangle } from "./ExclamationTriangle.js";
import { I as InformationCircle } from "./InformationCircle.js";
import { M as MapPin } from "./MapPin.js";
import { T as Trash } from "./Trash.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { m as modal } from "./modal2.js";
import { S as Subscribe } from "./Subscribe.js";
import { a as addSubscription } from "./index6.js";
import { C as CommunityCard } from "./CommunityCard.js";
function CommunityItem($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      community = void 0,
      view = "compact",
      showCounts = true,
      resolveObject,
      children
    } = $$props;
    function communityInfo($$renderer3) {
      CommunityCard($$renderer3, { community_view: community });
    }
    CommonItem($$renderer2, {
      icon: community.community.icon,
      href: `/c/${stringify(fullCommunityName(community.community.name, community.community.actor_id))}`,
      title: community.community.title,
      detail: `${stringify(new SvelteURL(community.community.actor_id).hostname)}${stringify(!showCounts ? ` • ${Intl.NumberFormat(store_get($$store_subs ??= {}, "$locale", locale), { notation: "compact" }).format(community.counts.subscribers)}` : "")}`,
      orientation: view == "cozy" ? "vertical" : "horizontal",
      children: ($$renderer3) => {
        if (!children) {
          $$renderer3.push("<!--[-->");
          if (community.community.deleted) {
            $$renderer3.push("<!--[-->");
            Icon($$renderer3, {
              src: Trash,
              class: "text-red-500 inline",
              micro: true,
              size: "14",
              title: store_get($$store_subs ??= {}, "$t", t)("post.badges.deleted")
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (community.community.nsfw) {
            $$renderer3.push("<!--[-->");
            Icon($$renderer3, {
              src: ExclamationTriangle,
              class: "text-red-500 inline",
              micro: true,
              size: "14",
              title: store_get($$store_subs ??= {}, "$t", t)("post.badges.nsfw")
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (community.banned_from_community) {
            $$renderer3.push("<!--[-->");
            Icon($$renderer3, {
              src: NoSymbol,
              class: "text-red-500 inline",
              micro: true,
              size: "14",
              title: store_get($$store_subs ??= {}, "$t", t)("comment.banned")
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (community.community.visibility == "LocalOnly") {
            $$renderer3.push("<!--[-->");
            Icon($$renderer3, {
              src: MapPin,
              class: "text-green-500 inline",
              micro: true,
              size: "14",
              title: store_get($$store_subs ??= {}, "$t", t)("routes.admin.config.listingType.local")
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          Button($$renderer3, {
            rounding: "xl",
            color: "ghost",
            onclick: () => modal({
              title: store_get($$store_subs ??= {}, "$t", t)("form.post.community"),
              snippet: communityInfo
            }),
            "aria-label": store_get($$store_subs ??= {}, "$t", t)("common.info"),
            size: "square-md",
            children: ($$renderer4) => {
              Icon($$renderer4, { src: InformationCircle, size: "16", mini: true });
            },
            $$slots: { default: true }
          });
          $$renderer3.push(`<!----> `);
          {
            let children2 = function($$renderer4, { subscribe, subscribing }) {
              const subscribed = community.subscribed == "Subscribed" || community.subscribed == "Pending";
              Button($$renderer4, {
                disabled: subscribing || !profile.current?.jwt,
                loading: subscribing,
                onclick: async () => {
                  const object = resolveObject && await client().resolveObject({ q: community.community.actor_id });
                  const res = object ? await subscribe(object.community?.community.id) : await subscribe();
                  if (res) {
                    const newSubscribed = res.community_view.subscribed != "NotSubscribed" ? "Subscribed" : "NotSubscribed";
                    community.subscribed = newSubscribed;
                    addSubscription(community.community, newSubscribed == "Subscribed");
                  }
                },
                size: "custom",
                title: subscribed ? store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribed") : store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribe"),
                color: subscribed ? "secondary" : "primary",
                rounding: "xl",
                class: [
                  subscribed && "text-slate-600 dark:text-zinc-400",
                  " h-8.5 rounded-full",
                  view == "compact" ? "aspect-square @md:px-2 @md:min-w-30 @md:aspect-auto" : "px-3"
                ],
                icon: subscribed ? Check : Plus,
                children: ($$renderer5) => {
                  $$renderer5.push(`<span${attr_class(clsx([view == "compact" && "hidden", "@md:block"]))}>`);
                  if (subscribed) {
                    $$renderer5.push("<!--[-->");
                    $$renderer5.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribed"))}`);
                  } else {
                    $$renderer5.push("<!--[!-->");
                    $$renderer5.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.community.subscribe"))}`);
                  }
                  $$renderer5.push(`<!--]--></span>`);
                },
                $$slots: { default: true }
              });
            };
            Subscribe($$renderer3, { community, children: children2 });
          }
          $$renderer3.push(`<!---->`);
        } else {
          $$renderer3.push("<!--[!-->");
          children?.($$renderer3);
          $$renderer3.push(`<!---->`);
        }
        $$renderer3.push(`<!--]-->`);
      }
    });
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { community });
  });
}
export {
  CommunityItem as C
};
//# sourceMappingURL=CommunityItem.js.map
