import { m as attributes, c as clsx, e as escape_html, a as attr_class, s as store_get, u as unsubscribe_stores, k as stringify } from "./index3.js";
import { t } from "./index.js";
import { s as settings } from "./settings.svelte.js";
import { m as communityLink, h as Avatar } from "./client.svelte.js";
import { I as Icon } from "./Icon.js";
import { E as ExclamationTriangle } from "./ExclamationTriangle.js";
function CommunityLink($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      community,
      avatar = false,
      name = true,
      avatarSize = 24,
      showInstance = settings.showInstances.community,
      displayName = true,
      badges = { nsfw: false },
      class: clazz = "",
      instanceClass = "",
      $$slots,
      $$events,
      ...rest
    } = $$props;
    $$renderer2.push(`<a${attributes(
      {
        ...rest,
        class: clsx([
          "items-center inline-flex flex-row gap-2 hover:underline max-w-full min-w-0",
          clazz
        ]),
        href: communityLink(community),
        "data-sveltekit-preload-data": "tap"
      },
      "svelte-svi9gd"
    )}>`);
    if (avatar && !badges.nsfw) {
      $$renderer2.push("<!--[-->");
      Avatar($$renderer2, { url: community.icon, alt: community.name, width: avatarSize });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (name) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<span class="flex gap-0 items-center max-w-full min-w-0 shrink"><span class="font-medium username-text svelte-svi9gd">${escape_html(displayName ? community.title : community.name)}</span> `);
      if (showInstance) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<span${attr_class(`text-slate-500 dark:text-zinc-500 font-normal instance-text shrink ${stringify(instanceClass || "")}`, "svelte-svi9gd")}>@${escape_html(new URL(community.actor_id).hostname)}</span>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></span>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (badges) {
      $$renderer2.push("<!--[-->");
      if (badges.nsfw) {
        $$renderer2.push("<!--[-->");
        Icon($$renderer2, {
          src: ExclamationTriangle,
          size: "14",
          micro: true,
          title: store_get($$store_subs ??= {}, "$t", t)("post.badges.nsfw"),
          class: "text-red-600 dark:text-red-400"
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></a>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  CommunityLink as C
};
//# sourceMappingURL=CommunityLink.js.map
