import { a as attr_class, d as ensure_array_like, b as attr, e as escape_html, f as bind_props } from "./index3.js";
import "./client.svelte.js";
import "./index.js";
import { M as Modal } from "./Modal.js";
import "clsx";
function DebugTree_1($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { object, isParent = false } = $$props;
    $$renderer2.push(`<ul${attr_class("leading-8", void 0, { "ml-4": !isParent })}><!--[-->`);
    const each_array = ensure_array_like(Object.keys(object));
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let key = each_array[$$index];
      $$renderer2.push(`<details${attr("open", false, true)}><summary class="cursor-pointer"><code>${escape_html(key)}</code></summary> `);
      if (typeof object[key] === "object") {
        $$renderer2.push("<!--[-->");
        DebugTree_1($$renderer2, { object: object[key], isParent: false });
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<pre class="break-words">${escape_html(object[key])}</pre>`);
      }
      $$renderer2.push(`<!--]--></details>`);
    }
    $$renderer2.push(`<!--]--></ul>`);
  });
}
function DebugObject($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { object, open = false, title } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      {
        let customTitle = function($$renderer4) {
          $$renderer4.push(`<span>`);
          if (title) {
            $$renderer4.push("<!--[-->");
            title($$renderer4);
            $$renderer4.push(`<!---->`);
          } else {
            $$renderer4.push("<!--[!-->");
            $$renderer4.push(`Debug`);
          }
          $$renderer4.push(`<!--]--></span>`);
        };
        Modal($$renderer3, {
          get open() {
            return open;
          },
          set open($$value) {
            open = $$value;
            $$settled = false;
          },
          customTitle,
          children: ($$renderer4) => {
            DebugTree_1($$renderer4, { object, isParent: true });
          },
          $$slots: { customTitle: true, default: true }
        });
      }
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { open });
  });
}
export {
  DebugObject as default
};
//# sourceMappingURL=DebugObject.js.map
