import { f as bind_props, s as store_get, e as escape_html, u as unsubscribe_stores } from "./index3.js";
import { t } from "./index.js";
import "./client.svelte.js";
import { T as TextInput } from "./TextInput.js";
import { S as Select, O as Option } from "./Select.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
function Duration($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { value = void 0, max, min = 0 } = $$props;
    let number = 0;
    let duration = value == -1 ? "permanent" : "day";
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="flex flex-row items-end gap-2">`);
      if (duration != "permanent") {
        $$renderer3.push("<!--[-->");
        TextInput($$renderer3, {
          min,
          max,
          type: "number",
          label: "Number",
          class: "w-24",
          get value() {
            return number;
          },
          set value($$value) {
            number = $$value;
            $$settled = false;
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      Select($$renderer3, {
        baseClass: "flex-1",
        label: store_get($$store_subs ??= {}, "$t", t)("form.time.duration"),
        get value() {
          return duration;
        },
        set value($$value) {
          duration = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          Option($$renderer4, {
            value: "minute",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.time.minutes"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Option($$renderer4, {
            value: "hour",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.time.hours"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Option($$renderer4, {
            value: "day",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.time.days"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Option($$renderer4, {
            value: "month",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.time.months"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Option($$renderer4, {
            value: "year",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.time.years"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Option($$renderer4, {
            value: "permanent",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.time.permanent"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { value });
  });
}
export {
  Duration as D
};
//# sourceMappingURL=Duration.js.map
