import { a as attr_class, c as clsx, i as element } from "./index3.js";
function EndPlaceholder($$renderer, $$props) {
  const sizes = { xs: "text-xs", sm: "text-sm", md: "text-base", lg: "text-lg" };
  const margins = {
    none: "",
    sm: "mt-3 mb-1 px-3",
    md: "mt-4 mb-2",
    lg: "mt-6 mb-2",
    "bottom-sm": "mb-1 px-3",
    "bottom-md": "mb-2",
    "bottom-lg": "mb-3"
  };
  const colors = { subtle: "text-slate-600 dark:text-zinc-400", none: "" };
  let {
    class: clazz = "",
    children,
    action,
    border = true,
    size = "sm",
    color = "subtle",
    margin = "none",
    element: element$1 = "h3",
    alignment = "default"
  } = $$props;
  function divider($$renderer2) {
    $$renderer2.push(`<div${attr_class(clsx([
      "flex-1 border-slate-200/70 dark:border-zinc-800 border-b",
      !border && "opacity-0"
    ]))}></div>`);
  }
  $$renderer.push(`<div${attr_class(clsx([
    "flex flex-row items-center gap-2 flex-wrap",
    sizes[size],
    colors[color],
    margins[margin],
    clazz
  ]))}>`);
  if (alignment == "center") {
    $$renderer.push("<!--[-->");
    divider($$renderer);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--> `);
  if (children) {
    $$renderer.push("<!--[-->");
    element(
      $$renderer,
      element$1,
      () => {
        $$renderer.push(` class="font-medium text-left flex flex-row gap-1 items-center"`);
      },
      () => {
        children?.($$renderer);
        $$renderer.push(`<!---->`);
      }
    );
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--> `);
  if (alignment == "default") {
    $$renderer.push("<!--[-->");
    divider($$renderer);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--> `);
  action?.($$renderer);
  $$renderer.push(`<!----> `);
  if (alignment == "center") {
    $$renderer.push("<!--[-->");
    divider($$renderer);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--></div>`);
}
export {
  EndPlaceholder as E
};
//# sourceMappingURL=EndPlaceholder.js.map
