import { a as attr_class, c as clsx, m as attributes, b as attr, i as element, e as escape_html, d as ensure_array_like } from "./index3.js";
import { M as Material, _ as Blobs, h as Avatar } from "./client.svelte.js";
import "./settings.svelte.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import "./index.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { P as PostBody } from "./PostBody.js";
import { L as LabelStat } from "./LabelStat.js";
const wrapClass = {
  wrap: "",
  "no-wrap": "overflow-hidden text-ellipsis whitespace-nowrap",
  force: "break-words"
};
function TextProps($$renderer, $$props) {
  let { wrap = "wrap", class: clazz = "", children } = $$props;
  let classes = `${wrapClass[wrap]} ${clazz ?? ""}`;
  $$renderer.push(`<span${attr_class(clsx(classes))}>`);
  children?.($$renderer);
  $$renderer.push(`<!----></span>`);
}
function EntityHeader($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      avatar,
      name,
      bio,
      banner,
      url,
      stats = [],
      class: clazz = "",
      nameDetail,
      actions,
      children,
      compact,
      avatarCircle = true,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    $$renderer2.push(`<div${attributes(
      {
        ...rest,
        class: clsx(["z-10 text-sm w-full space-y-4 @container", clazz])
      },
      "svelte-5c4wgm"
    )}>`);
    {
      let pfp = function($$renderer3, width) {
        Avatar($$renderer3, {
          width,
          url: avatar,
          alt: name,
          circle: avatarCircle,
          class: [
            "relative",
            banner !== null && "-mt-4 @md:-mt-8",
            !avatarCircle && "rounded-xl @md:rounded-3xl!"
          ]
        });
      };
      Material($$renderer2, {
        padding: "xl",
        rounding: "3xl",
        class: "flex flex-col gap-2 @lg:gap-4",
        pfp,
        children: ($$renderer3) => {
          if (banner !== null) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="relative overflow-hidden rounded-t-[inherit] -m-6 mask-b-from-0 h-32 @lg:h-48">`);
            if (banner) {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<img${attr("src", banner)} class="w-full object-cover h-full bg-white dark:bg-zinc-900" height="192" alt="User banner"/>`);
            } else {
              $$renderer3.push("<!--[!-->");
              $$renderer3.push(`<div class="scale-150 h-full">`);
              Blobs($$renderer3, { seed: name });
              $$renderer3.push(`<!----></div>`);
            }
            $$renderer3.push(`<!--]--></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> <div class="contents @md:hidden">`);
          pfp($$renderer3, 48);
          $$renderer3.push(`<!----></div> <div class="hidden @md:contents">`);
          pfp($$renderer3, 72);
          $$renderer3.push(`<!----></div> <div class="space-y-1">`);
          element(
            $$renderer3,
            url ? "a" : "h1",
            () => {
              $$renderer3.push(`${attr("href", url)}${attr_class(clsx([
                "text-xl @md:text-2xl font-medium tracking-tight",
                url && "hover:underline hover:text-primary-900 dark:hover:text-primary-100"
              ]))}`);
            },
            () => {
              $$renderer3.push(`${escape_html(name)}`);
            }
          );
          $$renderer3.push(` `);
          if (nameDetail) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<p class="flex items-center gap-0 text-sm text-slate-600 dark:text-zinc-400 max-w-full w-max">`);
            TextProps($$renderer3, {
              wrap: "no-wrap",
              children: ($$renderer4) => {
                nameDetail?.($$renderer4);
                $$renderer4.push(`<!---->`);
              }
            });
            $$renderer3.push(`<!----></p>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div>`);
        },
        $$slots: { pfp: true, default: true }
      });
    }
    $$renderer2.push(`<!----> `);
    if (actions || stats.length > 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="space-y-4"><div class="flex flex-col flex-1">`);
      if (actions) {
        $$renderer2.push("<!--[-->");
        actions?.($$renderer2);
        $$renderer2.push(`<!---->`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div> `);
      if (stats.length > 0) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div${attr_class(clsx([
          compact == "lg" && "lg:hidden",
          compact == "always" ? "hidden" : "flex",
          "text-sm flex-row flex-wrap overflow-hidden gap-4 h-full"
        ]))}><!--[-->`);
        const each_array = ensure_array_like(stats);
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let stat = each_array[$$index];
          LabelStat($$renderer2, {
            label: stat.name,
            content: stat.value,
            labelClass: "text-sm",
            contentClass: "text-lg"
          });
        }
        $$renderer2.push(`<!--]--></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (bio) {
      $$renderer2.push("<!--[-->");
      PostBody($$renderer2, {
        body: bio,
        class: [
          compact == "lg" && "lg:hidden",
          compact == "always" && "hidden",
          "relative"
        ],
        clickThrough: false
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (children) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="space-y-3 py-4 pt-0 mt-4">`);
      children?.($$renderer2);
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
  });
}
export {
  EntityHeader as E
};
//# sourceMappingURL=EntityHeader.js.map
