import { a as attr_class, c as clsx, e as escape_html, d as ensure_array_like } from "./index3.js";
import { o as onDestroy } from "./index-server.js";
import { I as Icon } from "./Icon.js";
import { E as ExclamationTriangle } from "./ExclamationTriangle.js";
let errors = [];
function clearErrorScope(scope) {
  errors = errors.filter((error) => error.scope != scope);
}
function ErrorContainer($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    onDestroy(() => {
      clearErrorScope(scope);
    });
    let { scope, message, children, class: clazz = "" } = $$props;
    let scopedErrors = errors.filter((e) => e.scope == scope || e.scope == "global");
    if (scopedErrors.length > 0 || message) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attr_class(clsx(["flex flex-col gap-4", clazz]), "svelte-188sv7y")}><div class="info-container material-error svelte-188sv7y">`);
      Icon($$renderer2, {
        src: ExclamationTriangle,
        size: "20",
        micro: true,
        class: "inline-block rounded-lg clear-both float-left mr-2"
      });
      $$renderer2.push(`<!----> `);
      if (message) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`${escape_html(message)}`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      children?.($$renderer2);
      $$renderer2.push(`<!----> <!--[-->`);
      const each_array = ensure_array_like(scopedErrors);
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let error = each_array[$$index];
        $$renderer2.push(`<p>${escape_html(error.message)}</p>`);
      }
      $$renderer2.push(`<!--]--></div></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
  });
}
export {
  ErrorContainer as E
};
//# sourceMappingURL=ErrorContainer.js.map
