import { a as attr_class, j as attr_style, b as attr, c as clsx, s as store_get, u as unsubscribe_stores } from "./index3.js";
import { t } from "./index.js";
function Header($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const sizes = {
      sm: "text-2xl",
      md: "text-3xl",
      lg: "text-4xl",
      xl: "text-6xl"
    };
    let {
      pageHeader = false,
      style = "",
      class: clazz = "",
      size = "lg",
      children,
      extended
    } = $$props;
    $$renderer2.push(`<header${attr_class(clsx([
      pageHeader && `w-[calc(100%+1.5rem)] sm:w-[calc(100%+3rem)]
  bg-slate-50 dark:bg-zinc-950 -mx-3 sm:-mx-6 sm:px-6 sm:pb-6 px-4 pb-4 -mt-64 pt-64
   border-b border-slate-100 dark:border-zinc-900 font-display margin z-0 mb-3 sm:mb-6`
    ]))}${attr_style(style)}${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("aria.element.pageHeader"))}>`);
    if (children) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<h1${attr_class(clsx([
        sizes[size],
        "flex gap-2 w-full tracking-tight font-medium",
        clazz
      ]))}>`);
      children?.($$renderer2);
      $$renderer2.push(`<!----></h1>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (extended) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="flex flex-col gap-3 mt-3">`);
      extended?.($$renderer2);
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></header>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  Header as H
};
//# sourceMappingURL=Header.js.map
