import { m as attributes, d as ensure_array_like } from "./index3.js";
function Icon($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      src,
      size = "24",
      mini = false,
      micro = false,
      solid = false,
      variant = null,
      class: className,
      style = "",
      $$slots,
      $$events,
      ...rest
    } = $$props;
    let selectedVariant = variant || (micro ? "micro" : mini ? "mini" : solid ? "solid" : "outline");
    let icon = src?.[selectedVariant] || src?.outline || {};
    let svgAttributes = icon ? {
      ...icon.a,
      ...className && { class: className },
      ...style && { style }
    } : {};
    $$renderer2.push(`<svg${attributes(
      {
        ...svgAttributes,
        xmlns: "http://www.w3.org/2000/svg",
        width: size,
        height: size,
        "aria-hidden": "true",
        ...rest
      },
      void 0,
      void 0,
      void 0,
      3
    )}><!--[-->`);
    const each_array = ensure_array_like(icon?.path ?? []);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let a = each_array[$$index];
      $$renderer2.push(`<path${attributes({ ...a }, void 0, void 0, void 0, 3)}></path>`);
    }
    $$renderer2.push(`<!--]--></svg>`);
  });
}
export {
  Icon as I
};
//# sourceMappingURL=Icon.js.map
