import { u as unsubscribe_stores, f as bind_props, s as store_get, e as escape_html } from "./index3.js";
import { t } from "./index.js";
import { B as Button } from "./client.svelte.js";
import { T as TextInput } from "./TextInput.js";
import { M as Modal } from "./Modal.js";
import "clsx";
import { I as ImageAttachForm } from "./MarkdownEditor.js";
import { S as Switch } from "./Switch2.js";
function ImageInputModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { open = void 0, imageUrl: passedImageUrl = void 0 } = $$props;
    let imageUrl = passedImageUrl;
    let customUrl = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        title: store_get($$store_subs ??= {}, "$t", t)("form.post.uploadImage"),
        get open() {
          return open;
        },
        set open($$value) {
          open = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="flex justify-between gap-1 flex-wrap">`);
          Switch($$renderer4, {
            options: [false, true],
            optionNames: [
              store_get($$store_subs ??= {}, "$t", t)("common.attach"),
              store_get($$store_subs ??= {}, "$t", t)("content.url")
            ],
            get selected() {
              return customUrl;
            },
            set selected($$value) {
              customUrl = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            onclick: () => {
              passedImageUrl = void 0;
              open = false;
            },
            size: "xs",
            rounding: "xl",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.remove"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></div> `);
          if (customUrl) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<form class="contents">`);
            TextInput($$renderer4, {
              label: store_get($$store_subs ??= {}, "$t", t)("content.url"),
              pattern: "http(s)?:\\/\\/(.*).(png|jpg|gif|avif|webp|jpeg|jxl|svg|bmp)",
              get value() {
                return imageUrl;
              },
              set value($$value) {
                imageUrl = $$value;
                $$settled = false;
              }
            });
            $$renderer4.push(`<!----> `);
            Button($$renderer4, {
              submit: true,
              color: "primary",
              size: "lg",
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></form>`);
          } else {
            $$renderer4.push("<!--[!-->");
            ImageAttachForm($$renderer4, {
              multiple: false,
              onupload: (uploaded) => {
                open = false;
                passedImageUrl = uploaded[0];
              }
            });
          }
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { open, imageUrl: passedImageUrl });
  });
}
export {
  ImageInputModal as I
};
//# sourceMappingURL=ImageInputModal.js.map
