import { f as bind_props, e as escape_html, a as attr_class, c as clsx, b as attr, s as store_get, u as unsubscribe_stores } from "./index3.js";
import { t } from "./index.js";
import { I as Icon } from "./Icon.js";
import { D as DocumentPlus } from "./MarkdownEditor.js";
import { o as Plus } from "./client.svelte.js";
import { L as Label } from "./Label.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { I as ImageInputModal } from "./ImageInputModal.js";
function ImageInputUpload($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { imageUrl: passedImageUrl = void 0, label } = $$props;
    let imageUrl = passedImageUrl;
    let open = false;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div>`);
      Label($$renderer3, {
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(label)}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> <button${attr_class(clsx([
        "flex flex-col items-center justify-center px-8 py-4 mx-auto w-full rounded-xl",
        "border border-slate-200 dark:border-zinc-800 border-dashed hover:border-slate-300 hover:dark:border-zinc-700",
        "cursor-pointer min-h-36 transition-colors bg-white dark:bg-zinc-950 relative"
      ]))} type="button">`);
      if (imageUrl) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div>`);
        Icon($$renderer3, {
          src: Plus,
          class: "text-slate-400 dark:text-zinc-500 absolute top-0 left-0 m-2",
          size: "20",
          micro: true
        });
        $$renderer3.push(`<!----></div> <img${attr("src", imageUrl)} alt="" class="rounded-md mx-auto h-full"/>`);
      } else {
        $$renderer3.push("<!--[!-->");
        Icon($$renderer3, {
          src: DocumentPlus,
          class: "text-slate-400 dark:text-zinc-500",
          size: "36",
          solid: true
        });
        $$renderer3.push(`<!----> <p class="text-slate-600 dark:text-zinc-400 font-medium">${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.attach"))}</p>`);
      }
      $$renderer3.push(`<!--]--> `);
      ImageInputModal($$renderer3, {
        get open() {
          return open;
        },
        set open($$value) {
          open = $$value;
          $$settled = false;
        },
        get imageUrl() {
          return passedImageUrl;
        },
        set imageUrl($$value) {
          passedImageUrl = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----></button></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { imageUrl: passedImageUrl });
  });
}
export {
  ImageInputUpload as I
};
//# sourceMappingURL=ImageInputUpload.js.map
