import { a as attr_class, c as clsx, e as escape_html, s as store_get, u as unsubscribe_stores } from "./index3.js";
import { t } from "./index.js";
import { i as Markdown, E as Expandable, b as Badge, u as userLink } from "./client.svelte.js";
import { s as settings } from "./settings.svelte.js";
import { E as EntityHeader } from "./EntityHeader.js";
import { I as ItemList } from "./ItemList.js";
import { L as LabelStat } from "./LabelStat.js";
import { E as EndPlaceholder } from "./EndPlaceholder.js";
import { S as SidebarButton } from "./SidebarButton.js";
import { I as Icon } from "./Icon.js";
import { N as Newspaper } from "./Newspaper.js";
import { S as ServerStack } from "./ServerStack.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { P as Popover } from "./Popover.js";
const BuildingOffice = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3.75 2a.75.75 0 0 0 0 1.5H4v9h-.25a.75.75 0 0 0 0 1.5H6a.5.5 0 0 0 .5-.5v-3A.5.5 0 0 1 7 10h2a.5.5 0 0 1 .5.5v3a.5.5 0 0 0 .5.5h2.25a.75.75 0 0 0 0-1.5H12v-9h.25a.75.75 0 0 0 0-1.5h-8.5ZM6.5 4a.5.5 0 0 0-.5.5V5a.5.5 0 0 0 .5.5H7a.5.5 0 0 0 .5-.5v-.5A.5.5 0 0 0 7 4h-.5ZM6 7a.5.5 0 0 1 .5-.5H7a.5.5 0 0 1 .5.5v.5A.5.5 0 0 1 7 8h-.5a.5.5 0 0 1-.5-.5V7Zm3-3a.5.5 0 0 0-.5.5V5a.5.5 0 0 0 .5.5h.5A.5.5 0 0 0 10 5v-.5a.5.5 0 0 0-.5-.5H9Zm-.5 3a.5.5 0 0 1 .5-.5h.5a.5.5 0 0 1 .5.5v.5a.5.5 0 0 1-.5.5H9a.5.5 0 0 1-.5-.5V7Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M4 16.5v-13h-.25a.75.75 0 0 1 0-1.5h12.5a.75.75 0 0 1 0 1.5H16v13h.25a.75.75 0 0 1 0 1.5h-3.5a.75.75 0 0 1-.75-.75v-2.5a.75.75 0 0 0-.75-.75h-2.5a.75.75 0 0 0-.75.75v2.5a.75.75 0 0 1-.75.75h-3.5a.75.75 0 0 1 0-1.5H4Zm3-11a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1ZM7.5 9a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1ZM11 5.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-1Zm.5 3.5a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M3.75 21h16.5M4.5 3h15M5.25 3v18m13.5-18v18M9 6.75h1.5m-1.5 3h1.5m-1.5 3h1.5m3-6H15m-1.5 3H15m-1.5 3H15M9 21v-3.375c0-.621.504-1.125 1.125-1.125h3.75c.621 0 1.125.504 1.125 1.125V21"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M4.5 2.25a.75.75 0 0 0 0 1.5v16.5h-.75a.75.75 0 0 0 0 1.5h16.5a.75.75 0 0 0 0-1.5h-.75V3.75a.75.75 0 0 0 0-1.5h-15ZM9 6a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm-.75 3.75A.75.75 0 0 1 9 9h1.5a.75.75 0 0 1 0 1.5H9a.75.75 0 0 1-.75-.75ZM9 12a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm3.75-5.25A.75.75 0 0 1 13.5 6H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM13.5 9a.75.75 0 0 0 0 1.5H15A.75.75 0 0 0 15 9h-1.5Zm-.75 3.75a.75.75 0 0 1 .75-.75H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM9 19.5v-2.25a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 .75.75v2.25a.75.75 0 0 1-.75.75h-4.5A.75.75 0 0 1 9 19.5Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function InstanceCard($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { site, taglines, admins, version, class: clazz = "" } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<aside${attr_class(clsx([
        "w-full text-slate-600 dark:text-zinc-400 flex flex-col gap-4 text-sm",
        clazz
      ]))}>`);
      EntityHeader($$renderer3, {
        name: site.site.name,
        avatar: site.site.icon,
        banner: site.site.banner || null,
        compact: "always",
        avatarCircle: false
      });
      $$renderer3.push(`<!----> <div class="flex flex-col gap-1">`);
      if (taglines && taglines.length > 0) {
        $$renderer3.push("<!--[-->");
        Markdown($$renderer3, {
          class: "px-3",
          source: taglines[Math.floor(Math.random() * taglines.length)].content
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      EndPlaceholder($$renderer3, {
        size: "xs",
        margin: "sm",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.instance"))}`);
        }
      });
      $$renderer3.push(`<!----> `);
      SidebarButton($$renderer3, {
        href: "/modlog",
        label: store_get($$store_subs ??= {}, "$t", t)("routes.modlog.title"),
        icon: Newspaper
      });
      $$renderer3.push(`<!----> `);
      SidebarButton($$renderer3, {
        href: "/legal",
        label: store_get($$store_subs ??= {}, "$t", t)("routes.legal.title"),
        icon: BuildingOffice
      });
      $$renderer3.push(`<!----> `);
      SidebarButton($$renderer3, {
        href: "/instances",
        label: store_get($$store_subs ??= {}, "$t", t)("routes.instances"),
        icon: ServerStack
      });
      $$renderer3.push(`<!----> `);
      EndPlaceholder($$renderer3, {
        size: "xs",
        margin: "sm",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.site.stats"))}`);
        }
      });
      $$renderer3.push(`<!----> <div class="flex flex-row gap-4 flex-wrap px-3">`);
      LabelStat($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("content.users"),
        content: site.counts.users.toString(),
        formatted: true
      });
      $$renderer3.push(`<!----> `);
      LabelStat($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("content.posts"),
        content: site.counts.posts.toString(),
        formatted: true
      });
      $$renderer3.push(`<!----> `);
      LabelStat($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("content.comments"),
        content: site.counts.comments.toString(),
        formatted: true
      });
      $$renderer3.push(`<!----> `);
      {
        let target = function($$renderer4, attachment) {
          $$renderer4.push(`<button class="text-left cursor-pointer">`);
          LabelStat($$renderer4, {
            label: store_get($$store_subs ??= {}, "$t", t)("cards.community.activeDay"),
            content: site.counts.users_active_day.toString(),
            formatted: true
          });
          $$renderer4.push(`<!----></button>`);
        };
        Popover($$renderer3, {
          openOnHover: true,
          placement: "bottom-end",
          target,
          children: ($$renderer4) => {
            $$renderer4.push(`<div class="flex flex-row gap-4 flex-wrap px-3">`);
            LabelStat($$renderer4, {
              label: store_get($$store_subs ??= {}, "$t", t)("filter.sort.top.time.week"),
              content: site.counts.users_active_week.toString(),
              formatted: true
            });
            $$renderer4.push(`<!----> `);
            LabelStat($$renderer4, {
              label: store_get($$store_subs ??= {}, "$t", t)("filter.sort.top.time.month"),
              content: site.counts.users_active_month.toString(),
              formatted: true
            });
            $$renderer4.push(`<!----> `);
            LabelStat($$renderer4, {
              label: store_get($$store_subs ??= {}, "$t", t)("filter.sort.top.time.6months"),
              content: site.counts.users_active_half_year.toString(),
              formatted: true
            });
            $$renderer4.push(`<!----></div>`);
          },
          $$slots: { target: true, default: true }
        });
      }
      $$renderer3.push(`<!----> `);
      LabelStat($$renderer3, {
        label: store_get($$store_subs ??= {}, "$t", t)("content.communities"),
        content: site.counts.communities.toString(),
        formatted: true
      });
      $$renderer3.push(`<!----></div> `);
      EndPlaceholder($$renderer3, {
        size: "xs",
        margin: "sm",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("common.info"))}`);
        }
      });
      $$renderer3.push(`<!----> <div class="space-y-3 px-1.5 text-sm">`);
      {
        let title = function($$renderer4) {
          $$renderer4.push(`<span class="flex items-center gap-1 py-1 px-2 w-full">${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.site.about"))}</span>`);
        };
        Expandable($$renderer3, {
          get open() {
            return settings.expand.about;
          },
          set open($$value) {
            settings.expand.about = $$value;
            $$settled = false;
          },
          title,
          children: ($$renderer4) => {
            Markdown($$renderer4, { source: site.site.description });
            $$renderer4.push(`<!----> <div class="my-4"></div> `);
            Markdown($$renderer4, { source: site.site.sidebar });
            $$renderer4.push(`<!----> `);
            if (version) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="w-max">`);
              Badge($$renderer4, {
                label: "Lemmy version",
                children: ($$renderer5) => {
                  Icon($$renderer5, { src: ServerStack, micro: true, size: "14" });
                  $$renderer5.push(`<!----> ${escape_html(version)}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { title: true, default: true }
        });
      }
      $$renderer3.push(`<!----> `);
      if (admins) {
        $$renderer3.push("<!--[-->");
        {
          let title = function($$renderer4) {
            $$renderer4.push(`<span class="flex items-center gap-1 py-1 px-2 w-full">${escape_html(store_get($$store_subs ??= {}, "$t", t)("cards.site.admins"))}</span>`);
          };
          Expandable($$renderer3, {
            get open() {
              return settings.expand.team;
            },
            set open($$value) {
              settings.expand.team = $$value;
              $$settled = false;
            },
            title,
            children: ($$renderer4) => {
              ItemList($$renderer4, {
                items: admins.map((i) => ({
                  id: i.person.id,
                  name: i.person.display_name || i.person.name,
                  url: userLink(i.person),
                  avatar: i.person.avatar,
                  instance: new URL(i.person.actor_id).hostname
                }))
              });
            },
            $$slots: { title: true, default: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div></div></aside>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  InstanceCard as I
};
//# sourceMappingURL=InstanceCard.js.map
