import { e as escape_html } from "./index3.js";
import "clsx";
import { B as Button, h as Avatar } from "./client.svelte.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { C as CommonList } from "./CommonList.js";
import "./settings.svelte.js";
import "openapi-fetch";
import "@sveltejs/kit";
import "lemmy-js-client";
function ItemList($$renderer, $$props) {
  let { items, link = true, action } = $$props;
  {
    let item = function($$renderer2, item2) {
      Button($$renderer2, {
        class: "font-normal w-full h-max block gap-2",
        gap: "lg",
        color: "none",
        alignment: "left",
        href: link ? item2.url : void 0,
        children: ($$renderer3) => {
          $$renderer3.push(`<div class="flex-none">`);
          Avatar($$renderer3, {
            url: item2.avatar,
            alt: item2.name,
            title: item2.name,
            width: 24,
            circle: item2.circle ?? false
          });
          $$renderer3.push(`<!----></div> <div class="flex flex-col max-w-full break-words"><span>${escape_html(item2.name)}</span> `);
          if (item2.instance) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<span class="text-xs text-slate-600 dark:text-zinc-400">${escape_html(item2.instance)}</span>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div> `);
          if (action) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="flex-1"></div> `);
            action($$renderer3, item2);
            $$renderer3.push(`<!---->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    };
    CommonList($$renderer, {
      animate: false,
      class: "px-1 py-0.5",
      size: "xs",
      items,
      item
    });
  }
}
export {
  ItemList as I
};
//# sourceMappingURL=ItemList.js.map
