import { i as element, e as escape_html, m as attributes, c as clsx } from "./index3.js";
function Label($$renderer, $$props) {
  let {
    for: forID = void 0,
    text = void 0,
    class: clazz = "",
    customText,
    children,
    $$slots,
    $$events,
    ...rest
  } = $$props;
  element(
    $$renderer,
    text || customText ? "label" : "h3",
    () => {
      $$renderer.push(`${attributes({
        ...rest,
        for: forID,
        class: clsx([
          "text-sm text-slate-800 dark:text-zinc-200 font-medium",
          clazz
        ])
      })}`);
    },
    () => {
      if (text) {
        $$renderer.push("<!--[-->");
        $$renderer.push(`<div class="inline-block">${escape_html(text)}</div>`);
      } else {
        $$renderer.push("<!--[!-->");
        if (customText) {
          $$renderer.push("<!--[-->");
          customText?.($$renderer);
          $$renderer.push(`<!---->`);
        } else {
          $$renderer.push("<!--[!-->");
        }
        $$renderer.push(`<!--]-->`);
      }
      $$renderer.push(`<!--]--> `);
      children?.($$renderer);
      $$renderer.push(`<!---->`);
    }
  );
}
export {
  Label as L
};
//# sourceMappingURL=Label.js.map
