import { a as attr_class, e as escape_html, c as clsx } from "./index3.js";
import { F as FormattedNumber } from "./FormattedNumber.js";
function LabelStat($$renderer, $$props) {
  let {
    label,
    content,
    formatted = false,
    labelClass = "",
    contentClass = "",
    class: clazz = "",
    formatOptions
  } = $$props;
  if (content != "-1") {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<dl${attr_class(clsx(["flex flex-col", clazz]))}><dt${attr_class(clsx(["text-slate-600 dark:text-zinc-400 text-xs", labelClass]))}>${escape_html(label)}</dt> <dd${attr_class(clsx(["text-base", contentClass]))}>`);
    if (formatted) {
      $$renderer.push("<!--[-->");
      FormattedNumber($$renderer, { number: Number(content), options: formatOptions });
    } else {
      $$renderer.push("<!--[!-->");
      $$renderer.push(`${escape_html(content)}`);
    }
    $$renderer.push(`<!--]--></dd></dl>`);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]-->`);
}
export {
  LabelStat as L
};
//# sourceMappingURL=LabelStat.js.map
