import { m as attributes, c as clsx } from "./index3.js";
const parseURL = (href) => {
  try {
    return new URL(href);
  } catch {
    return void 0;
  }
};
function Link($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      href,
      highlight = false,
      children,
      class: clazz = "",
      icon,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    $$renderer2.push(`<a${attributes({
      ...rest,
      href,
      class: clsx([
        "hover:underline max-w-full inline-flex items-center gap-1",
        highlight && "text-blue-600 dark:text-blue-400",
        clazz
      ])
    })}>`);
    icon?.($$renderer2);
    $$renderer2.push(`<!----> `);
    children?.($$renderer2);
    $$renderer2.push(`<!----></a>`);
  });
}
export {
  Link as L,
  parseURL as p
};
//# sourceMappingURL=Link2.js.map
