import { f as bind_props, l as spread_props, e as escape_html, s as store_get, u as unsubscribe_stores } from "./index3.js";
import { p as page } from "./index4.js";
import { p as profile, P as PiefedClient, j as searchParam } from "./client.svelte.js";
import { t } from "./index.js";
import { I as Icon } from "./Icon.js";
import { C as ChartBar } from "./Sort.js";
import { G as GlobeAmericas } from "./GlobeAmericas.js";
import { M as MapPin } from "./MapPin.js";
import { N as Newspaper } from "./Newspaper.js";
import { S as ShieldCheck } from "./ShieldCheck.js";
import { S as Select, O as Option } from "./Select.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
function Location($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      selected = void 0,
      navigate = true,
      showLabel = true,
      children,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      {
        let customLabel = function($$renderer4) {
          if (showLabel) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<span class="flex items-center gap-1">`);
            Icon($$renderer4, { src: GlobeAmericas, size: "16", micro: true });
            $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.label"))}</span>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]-->`);
        };
        Select($$renderer3, spread_props([
          rest,
          {
            onchange: () => {
              if (navigate) searchParam(page.url, "type", selected, "page", "cursor");
            },
            get value() {
              return selected;
            },
            set value($$value) {
              selected = $$value;
              $$settled = false;
            },
            customLabel,
            children: ($$renderer4) => {
              Option($$renderer4, {
                value: "All",
                icon: GlobeAmericas,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.all"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              if (profile.client instanceof PiefedClient) {
                $$renderer4.push("<!--[-->");
                Option($$renderer4, {
                  value: "Popular",
                  icon: ChartBar,
                  children: ($$renderer5) => {
                    $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.popular"))}`);
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]--> `);
              Option($$renderer4, {
                value: "Local",
                icon: MapPin,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.local"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Option($$renderer4, {
                value: "Subscribed",
                disabled: profile.current?.jwt == void 0,
                icon: Newspaper,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.subscribed"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              Option($$renderer4, {
                value: "ModeratorView",
                disabled: !profile.isMod(),
                icon: ShieldCheck,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.moderator"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              children?.($$renderer4);
              $$renderer4.push(`<!---->`);
            },
            $$slots: { customLabel: true, default: true }
          }
        ]));
      }
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { selected });
  });
}
export {
  Location as L
};
//# sourceMappingURL=Location.js.map
