import { f as bind_props, l as spread_props, a as attr_class, c as clsx } from "./index3.js";
import { offset, shift, flip } from "@floating-ui/dom";
import { B as Button } from "./client.svelte.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { P as Popover } from "./Popover.js";
import { I as Icon } from "./Icon.js";
import { C as ChevronRight } from "./ChevronRight.js";
function Menu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      openOnHover = false,
      open = false,
      placement = "bottom-start",
      middleware = [offset(6), shift({ padding: 6 }), flip()],
      strategy = "absolute",
      target,
      children,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      {
        let popover = function($$renderer4) {
          $$renderer4.push(`<div class="w-full max-w-sm max-h-128 overflow-auto list-none shadow-lg rounded-xl"><div class="flex flex-col p-1 list-none bg-white/80 dark:bg-zinc-900/90 rounded-xl border border-slate-200 dark:border-zinc-800 gap-px" role="menu">`);
          children?.($$renderer4, open);
          $$renderer4.push(`<!----></div></div>`);
        };
        Popover($$renderer3, spread_props([
          { openOnHover, placement, middleware, strategy, target },
          rest,
          {
            popoverClass: "rounded-xl w-full backdrop-blur-md max-w-72",
            get open() {
              return open;
            },
            set open($$value) {
              open = $$value;
              $$settled = false;
            },
            popover,
            $$slots: { popover: true }
          }
        ]));
      }
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { open });
  });
}
function MenuButton($$renderer, $$props) {
  let {
    color = "tertiary",
    alignment = "left",
    href = void 0,
    disabled = false,
    class: clazz = "",
    icon,
    prefix: passedPrefix,
    children,
    suffix: passedSuffix,
    nest,
    $$slots,
    $$events,
    ...rest
  } = $$props;
  {
    let prefix = function($$renderer2) {
      $$renderer2.push(`<div${attr_class(clsx([
        "contents shrink-0",
        color == "tertiary" && "text-slate-600 dark:text-zinc-400"
      ]))}>`);
      if (icon) {
        $$renderer2.push("<!--[-->");
        Icon($$renderer2, { src: icon, micro: true, size: "16" });
      } else {
        $$renderer2.push("<!--[!-->");
        passedPrefix?.($$renderer2);
        $$renderer2.push(`<!---->`);
      }
      $$renderer2.push(`<!--]--></div>`);
    }, suffix = function($$renderer2) {
      passedSuffix?.($$renderer2);
      $$renderer2.push(`<!----> `);
      if (nest) {
        $$renderer2.push("<!--[-->");
        Icon($$renderer2, { src: ChevronRight, size: "16", micro: true, class: "ml-auto" });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    };
    Button($$renderer, spread_props([
      rest,
      {
        color,
        type: "none",
        size: "custom",
        rounding: "none",
        class: [
          "w-full px-3 py-1.5 min-h-7 duration-75 hover:cursor-default font-normal rounded-lg flex items-center gap-1 text-sm",
          disabled && "opacity-70 pointer-events-none cursor-not-allowed",
          color == "tertiary" && "dark:hover:bg-zinc-800/70",
          clazz
        ],
        alignment,
        href,
        disabled,
        "data-autoclose": nest ? "false" : "true",
        shadow: "none",
        role: "menuitem",
        prefix,
        suffix,
        children: ($$renderer2) => {
          children?.($$renderer2);
          $$renderer2.push(`<!---->`);
        },
        $$slots: { prefix: true, suffix: true, default: true }
      }
    ]));
  }
}
export {
  Menu as M,
  MenuButton as a
};
//# sourceMappingURL=MenuButton.js.map
