import { a as attr_class, c as clsx } from "./index3.js";
function MenuDivider($$renderer, $$props) {
  let { showLabel = false, hidden = false, children } = $$props;
  $$renderer.push(`<div${attr_class(clsx([
    "text-slate-800 dark:text-zinc-200 text-xs font-medium mx-3 my-1.5 flex items-center gap-1",
    hidden && "sr-only"
  ]))}><div${attr_class(clsx([!showLabel && "sr-only"]))}>`);
  children?.($$renderer);
  $$renderer.push(`<!----></div> <hr${attr_class(clsx([
    "shrink flex-1 border-slate-100 dark:border-zinc-800",
    !showLabel && "-mx-4"
  ]))}/></div>`);
}
export {
  MenuDivider as M
};
//# sourceMappingURL=MenuDivider.js.map
