import { a as attr_class, c as clsx, e as escape_html, f as bind_props } from "./index3.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { B as Button } from "./client.svelte.js";
import { p as page } from "./index4.js";
import { X as XMark } from "./XMark.js";
import "./index.js";
import { P as Portal } from "./Portal.js";
function Modal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      action = void 0,
      open = false,
      title = void 0,
      dismissable = true,
      customTitle,
      children,
      actions,
      ondismissed,
      onaction,
      class: clazz = ""
    } = $$props;
    const modalId = Math.random().toString();
    function onclose() {
      open = false;
      if ((page.state.openModals ?? []).includes(modalId)) history.back();
      ondismissed?.();
    }
    Portal($$renderer2, {
      children: ($$renderer3) => {
        if (open) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<div role="dialog"${attr_class(clsx([
            "overflow-hidden fixed top-0 left-0 w-screen h-screen z-100",
            "flex flex-col items-center justify-center backdrop-blur-xs",
            "bg-white/50 dark:bg-black/50 box-border p-4"
          ]))}><div${attr_class(clsx([
            "w-full border border-slate-200 border-b-slate-300 dark:border-zinc-900",
            "rounded-2xl max-w-lg box-border mx-auto overscroll-contain shadow-lg overflow-auto",
            "p-5 flex flex-col gap-2 dark:bg-zinc-950 bg-slate-50 relative",
            clazz
          ]))}>`);
          if (dismissable) {
            $$renderer3.push("<!--[-->");
            Button($$renderer3, {
              class: "absolute top-0 right-0 m-2 text-slate-600 dark:text-zinc-400",
              color: "tertiary",
              size: "square-sm",
              onclick: onclose,
              icon: XMark
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (title !== null) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<h1 class="font-medium tracking-tight text-xl leading-5 max-w-full">`);
            if (customTitle) {
              $$renderer3.push("<!--[-->");
              customTitle?.($$renderer3);
              $$renderer3.push(`<!---->`);
            } else {
              $$renderer3.push("<!--[!-->");
              if (title) {
                $$renderer3.push("<!--[-->");
                $$renderer3.push(`${escape_html(title)}`);
              } else {
                $$renderer3.push("<!--[!-->");
              }
              $$renderer3.push(`<!--]-->`);
            }
            $$renderer3.push(`<!--]--></h1>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          children?.($$renderer3);
          $$renderer3.push(`<!----> `);
          if (action) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="mt-2 flex w-full">`);
            if (actions) {
              $$renderer3.push("<!--[-->");
              actions($$renderer3, { action });
              $$renderer3.push(`<!---->`);
            } else {
              $$renderer3.push("<!--[!-->");
              Button($$renderer3, {
                class: "w-full",
                onclick: () => {
                  onaction?.();
                  onclose();
                },
                color: "primary",
                size: "lg",
                rounding: "xl",
                children: ($$renderer4) => {
                  $$renderer4.push(`<!---->${escape_html(action)}`);
                },
                $$slots: { default: true }
              });
            }
            $$renderer3.push(`<!--]--></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></div></div>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      }
    });
    bind_props($$props, { open });
  });
}
export {
  Modal as M
};
//# sourceMappingURL=Modal.js.map
