import { e as escape_html, s as store_get, k as stringify, u as unsubscribe_stores, f as bind_props } from "./index3.js";
import { p as profile, Q as isPostView, w as isCommentView, a as getClient, t as toast, e as errorMessage } from "./client.svelte.js";
import { t } from "./index.js";
import { I as Icon } from "./Icon.js";
import { A as ArrowsUpDown } from "./ArrowsUpDown.js";
import { F as Fire } from "./Fire.js";
import { L as LockClosed, M as Megaphone } from "./Megaphone.js";
import { L as LockOpen } from "./LockOpen.js";
import { N as Newspaper } from "./Newspaper.js";
import { S as ShieldExclamation } from "./ShieldExclamation.js";
import { T as Trash } from "./Trash.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { M as Menu, a as MenuButton } from "./MenuButton.js";
import { M as MenuDivider } from "./MenuDivider.js";
import { a as remove, b as ban, v as viewVotes } from "./moderation.js";
function ModerationMenu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { item = void 0, target: passedTarget } = $$props;
    let acting = false;
    async function lock(lock2) {
      if (!profile.current?.jwt || !isPostView(item)) return;
      acting = true;
      try {
        await getClient().lockPost({ locked: lock2, post_id: item.post.id });
        item.post.locked = lock2;
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
      acting = false;
    }
    async function pin(pinned, toInstance = false) {
      if (!profile.current?.jwt || !isPostView(item)) return;
      acting = true;
      try {
        await getClient().featurePost({
          feature_type: toInstance ? "Local" : "Community",
          featured: pinned,
          post_id: item.post.id
        });
        item.post.featured_community = pinned;
      } catch (err) {
        toast({ content: errorMessage(err), type: "error" });
      }
      acting = false;
    }
    {
      let target = function($$renderer3, attachment) {
        passedTarget($$renderer3, attachment, acting);
        $$renderer3.push(`<!---->`);
      };
      Menu($$renderer2, {
        placement: "bottom-end",
        target,
        children: ($$renderer3) => {
          if (profile.isMod(item.community) || profile.isAdmin) {
            $$renderer3.push("<!--[-->");
            MenuDivider($$renderer3, {
              showLabel: true,
              children: ($$renderer4) => {
                if (!item.community.local && !profile.isMod(item.community)) {
                  $$renderer4.push("<!--[-->");
                  $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.labelInstanceOnly"))}`);
                } else {
                  $$renderer4.push("<!--[!-->");
                  $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.label"))}`);
                }
                $$renderer4.push(`<!--]-->`);
              }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "warning-subtle",
              onclick: () => lock(!item.post.locked),
              loading: acting,
              icon: item.post.locked ? LockOpen : LockClosed,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(item.post.locked ? store_get($$store_subs ??= {}, "$t", t)("moderation.unlock") : store_get($$store_subs ??= {}, "$t", t)("moderation.lock"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "success-subtle",
              onclick: () => pin(isPostView(item) ? !item.post.featured_community : false),
              loading: acting,
              children: ($$renderer4) => {
                Icon($$renderer4, { src: Megaphone, size: "16", mini: true });
                $$renderer4.push(`<!----> <div class="flex flex-row gap-2 text-left items-center justify-between w-full"><span>${escape_html(item.post.featured_community ? store_get($$store_subs ??= {}, "$t", t)("moderation.unfeature") : store_get($$store_subs ??= {}, "$t", t)("moderation.feature"))}</span> `);
                if (profile.isAdmin) {
                  $$renderer4.push("<!--[-->");
                  $$renderer4.push(`<span class="text-xs opacity-80">${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.post.community"))}</span>`);
                } else {
                  $$renderer4.push("<!--[!-->");
                }
                $$renderer4.push(`<!--]--></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "danger-subtle",
              onclick: () => remove(item),
              children: ($$renderer4) => {
                Icon($$renderer4, { src: Trash, size: "16", mini: true });
                $$renderer4.push(`<!----> `);
                if (isCommentView(item)) {
                  $$renderer4.push("<!--[-->");
                  $$renderer4.push(`${escape_html(item.comment.removed ? store_get($$store_subs ??= {}, "$t", t)("moderation.restore") : store_get($$store_subs ??= {}, "$t", t)("moderation.remove"))}`);
                } else {
                  $$renderer4.push("<!--[!-->");
                  $$renderer4.push(`${escape_html(item.post.removed ? store_get($$store_subs ??= {}, "$t", t)("moderation.restore") : store_get($$store_subs ??= {}, "$t", t)("moderation.remove"))}`);
                }
                $$renderer4.push(`<!--]-->`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            if (profile.current?.user && profile.current.user.local_user_view.person.id != item.creator.id) {
              $$renderer3.push("<!--[-->");
              MenuButton($$renderer3, {
                color: "danger-subtle",
                onclick: () => ban(item.creator_banned_from_community, item.creator, item.community),
                children: ($$renderer4) => {
                  Icon($$renderer4, { src: ShieldExclamation, size: "16", mini: true });
                  $$renderer4.push(`<!----> ${escape_html(item.creator_banned_from_community ? store_get($$store_subs ??= {}, "$t", t)("moderation.ban.unbanFromCommunity") : store_get($$store_subs ??= {}, "$t", t)("moderation.ban.banFromCommunity"))}`);
                },
                $$slots: { default: true }
              });
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]--> `);
            MenuButton($$renderer3, {
              color: "success-subtle",
              href: `/modlog?user=${stringify(item.creator.id)}`,
              children: ($$renderer4) => {
                Icon($$renderer4, { src: Newspaper, size: "16", micro: true });
                $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.modlog.user"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "success-subtle",
              href: `/modlog?post=${stringify(item.post.id)}`,
              children: ($$renderer4) => {
                Icon($$renderer4, { src: Newspaper, size: "16", micro: true });
                $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.modlog.post"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "blue-subtle",
              onclick: () => viewVotes(item),
              children: ($$renderer4) => {
                Icon($$renderer4, { src: ArrowsUpDown, size: "16", micro: true });
                $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.votes"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!---->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (profile.isAdmin) {
            $$renderer3.push("<!--[-->");
            MenuDivider($$renderer3, {
              showLabel: true,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("admin.label"))}`);
              }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "success-subtle",
              onclick: () => pin(isPostView(item) ? !item.post.featured_local : false, true),
              children: ($$renderer4) => {
                Icon($$renderer4, { src: Megaphone, size: "16", mini: true });
                $$renderer4.push(`<!----> <div class="flex flex-row gap-2 text-left items-center justify-between w-full"><span>${escape_html(item.post.featured_local ? store_get($$store_subs ??= {}, "$t", t)("moderation.unfeature") : store_get($$store_subs ??= {}, "$t", t)("moderation.feature"))}</span> <span class="text-xs opacity-80">${escape_html(store_get($$store_subs ??= {}, "$t", t)("admin.instance"))}</span></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----> `);
            MenuButton($$renderer3, {
              color: "danger-subtle",
              onclick: () => remove(item, true),
              children: ($$renderer4) => {
                Icon($$renderer4, { src: Fire, size: "16", mini: true });
                $$renderer4.push(`<!----> ${escape_html(store_get($$store_subs ??= {}, "$t", t)("admin.purge"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!---->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { target: true, default: true }
      });
    }
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { item });
  });
}
export {
  ModerationMenu as default
};
//# sourceMappingURL=ModerationMenu.js.map
