import { e as escape_html } from "./index3.js";
import "clsx";
import { I as Icon } from "./Icon.js";
import { I as InformationCircle } from "./InformationCircle.js";
import { M as Material } from "./client.svelte.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
function Note($$renderer, $$props) {
  let { content = void 0, children, class: clazz = "" } = $$props;
  Material($$renderer, {
    color: "info",
    rounding: "2xl",
    class: ["flex flex-row items-center px-3 py-2.5", clazz],
    children: ($$renderer2) => {
      Icon($$renderer2, {
        src: InformationCircle,
        size: "20",
        micro: true,
        class: "inline-block rounded-lg clear-both float-left mr-2"
      });
      $$renderer2.push(`<!----> <div class="flex flex-col md:flex-row items-center w-full">`);
      if (children) {
        $$renderer2.push("<!--[-->");
        children?.($$renderer2);
        $$renderer2.push(`<!---->`);
      } else {
        $$renderer2.push("<!--[!-->");
        if (content) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<p class="text-left justify-self-start">${escape_html(content)}</p>`);
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]--></div>`);
    },
    $$slots: { default: true }
  });
}
export {
  Note as N
};
//# sourceMappingURL=Note.js.map
