import { f as bind_props, l as spread_props, e as escape_html } from "./index3.js";
import { a as getClient, h as Avatar } from "./client.svelte.js";
import { I as Icon } from "./Icon.js";
import { S as ServerStack } from "./ServerStack.js";
import { X as XCircle } from "./XCircle.js";
import "./index.js";
import { c as createEventDispatcher } from "./index-server.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { a as MenuButton } from "./MenuButton.js";
import { S as Search } from "./Search.js";
function ObjectAutocomplete($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      type = "community",
      q = "",
      instance = void 0,
      listing_type = "Subscribed",
      showWhenEmpty = false,
      required,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    const dispatcher = createEventDispatcher();
    let instances = type == "instance" && getClient().getFederatedInstances();
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (type == "community") {
        $$renderer3.push("<!--[-->");
        {
          let noresults = function($$renderer4) {
            $$renderer4.push(`<div class="w-full h-full">`);
            if (q == "" && showWhenEmpty) {
              $$renderer4.push("<!--[-->");
              MenuButton($$renderer4, {
                onclick: () => dispatcher("select", void 0),
                children: ($$renderer5) => {
                  Icon($$renderer5, { src: XCircle, size: "16", mini: true });
                  $$renderer5.push(`<!----> <div class="flex flex-col text-left"><span>None</span></div>`);
                },
                $$slots: { default: true }
              });
            } else {
              $$renderer4.push("<!--[!-->");
              $$renderer4.push(`<span class="mx-auto my-auto">No results.</span>`);
            }
            $$renderer4.push(`<!--]--></div>`);
          }, children = function($$renderer4, { item, select }) {
            $$renderer4.push(`<div>`);
            MenuButton($$renderer4, {
              onclick: () => select(item),
              children: ($$renderer5) => {
                Avatar($$renderer5, {
                  url: item.community.icon,
                  alt: item.community.title,
                  width: 24
                });
                $$renderer5.push(`<!----> <div class="flex flex-col text-left"><span>${escape_html(item.community.title)}</span> <span class="text-xs opacity-80">${escape_html(new URL(item.community.actor_id).hostname)}</span></div>`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></div>`);
          };
          Search($$renderer3, spread_props([
            {
              search: async (q2) => {
                const results = await getClient(instance).search({
                  q: q2 || " ",
                  type_: "Communities",
                  limit: 20,
                  listing_type,
                  sort: "TopAll"
                });
                return results.communities;
              },
              extractName: (c) => `${c.community.name}@${new URL(c.community.actor_id).hostname}`,
              required
            },
            rest,
            {
              get query() {
                return q;
              },
              set query($$value) {
                q = $$value;
                $$settled = false;
              },
              noresults,
              children,
              $$slots: { noresults: true, default: true }
            }
          ]));
        }
      } else {
        $$renderer3.push("<!--[!-->");
        if (type == "instance") {
          $$renderer3.push("<!--[-->");
          {
            let noresults = function($$renderer4) {
              $$renderer4.push(`<div class="w-full h-full">`);
              if (q == "" && showWhenEmpty) {
                $$renderer4.push("<!--[-->");
                MenuButton($$renderer4, {
                  onclick: () => dispatcher("select", void 0),
                  children: ($$renderer5) => {
                    $$renderer5.push(`<div class="flex flex-col text-left"><span>None (Start typing to search)</span></div>`);
                  },
                  $$slots: { default: true }
                });
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<span class="mx-auto my-auto">No results.</span>`);
              }
              $$renderer4.push(`<!--]--></div>`);
            }, children = function($$renderer4, { item, select }) {
              $$renderer4.push(`<div>`);
              MenuButton($$renderer4, {
                onclick: () => select(item),
                children: ($$renderer5) => {
                  Icon($$renderer5, { src: ServerStack, size: "16", mini: true });
                  $$renderer5.push(`<!----> <div class="flex flex-col text-left"><span>${escape_html(item.domain)}</span></div>`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----></div>`);
            };
            Search($$renderer3, spread_props([
              {
                search: async (q2) => {
                  const results = await instances || {};
                  return q2 ? (results.federated_instances?.linked || []).filter((i) => i.software === "lemmy" && i.domain.includes(q2)) : [];
                },
                extractName: (i) => `${i.domain}`
              },
              rest,
              {
                get query() {
                  return q;
                },
                set query($$value) {
                  q = $$value;
                  $$settled = false;
                },
                noresults,
                children,
                $$slots: { noresults: true, default: true }
              }
            ]));
          }
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!--]-->`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { q });
  });
}
export {
  ObjectAutocomplete as O
};
//# sourceMappingURL=ObjectAutocomplete.js.map
