import { b as attr, a as attr_class, s as store_get, c as clsx, e as escape_html, u as unsubscribe_stores, f as bind_props } from "./index3.js";
import { B as Button, k as invalidate, l as SvelteURLSearchParams } from "./client.svelte.js";
import { p as page } from "./index4.js";
import { t } from "./index.js";
import { I as Icon } from "./Icon.js";
import { C as ChevronLeft } from "./ChevronLeft.js";
import { C as ChevronRight } from "./ChevronRight.js";
function Pageination($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      page: page$1 = 0,
      cursor = void 0,
      hasMore = true,
      children,
      href,
      back = true
    } = $$props;
    let customHref = (href2) => {
      if (href2?.startsWith("?")) {
        const current = new SvelteURLSearchParams(page.url.searchParams);
        const newParams = new SvelteURLSearchParams(href2);
        current.delete(Array.from(newParams.keys())[0]);
        current.append(Array.from(newParams.entries())[0][0], Array.from(newParams.entries())[0][1]);
        return `?${current.toString()}`;
      } else return href2;
    };
    if (hasMore || page$1 != 1) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<nav${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("aria.pagination.nav"))}${attr_class(clsx([
        "flex flex-row gap-2 items-center justify-center bg-white dark:bg-zinc-950",
        "border border-slate-200 dark:border-zinc-800 rounded-full overflow-hidden w-max mx-auto p-0.5",
        "shadow-md"
      ]))}>`);
      if (children) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<span class="text-sm text-slate-600 dark:text-zinc-400 font-medium">`);
        children?.($$renderer2);
        $$renderer2.push(`<!----></span> <hr class="border-slate-200 dark:border-zinc-800 flex-1"/>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (back) {
        $$renderer2.push("<!--[-->");
        {
          let suffix = function($$renderer3) {
            Icon($$renderer3, { src: ChevronLeft, size: "24", mini: true });
          };
          Button($$renderer2, {
            href: customHref(href?.(cursor?.back ?? page$1 - 1)),
            color: "tertiary",
            onclick: () => invalidate(page.url),
            title: store_get($$store_subs ??= {}, "$t", t)("common.back"),
            rounding: "pill",
            size: "custom",
            class: "text-inherit dark:text-inherit p-1",
            disabled: cursor?.back == void 0 && cursor?.next != void 0 || page$1 <= 1,
            suffix,
            $$slots: { suffix: true }
          });
        }
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (page$1) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div style="display: grid;"><!---->`);
        {
          $$renderer2.push(`<div class="text-lg font-medium" style="grid-column: 1; grid-row: 1;">${escape_html(page$1)}</div>`);
        }
        $$renderer2.push(`<!----></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      {
        let suffix = function($$renderer3) {
          Icon($$renderer3, { src: ChevronRight, size: "24", mini: true });
        };
        Button($$renderer2, {
          href: customHref(href?.(cursor?.next ?? page$1 + 1)),
          color: "tertiary",
          onclick: () => invalidate(page.url),
          title: store_get($$store_subs ??= {}, "$t", t)("common.next"),
          size: "custom",
          rounding: "pill",
          class: "text-inherit dark:text-inherit p-1",
          disabled: !hasMore,
          suffix,
          $$slots: { suffix: true }
        });
      }
      $$renderer2.push(`<!----></nav>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { page: page$1 });
  });
}
export {
  Pageination as P
};
//# sourceMappingURL=Pageination.js.map
