import { k as stringify, s as store_get, u as unsubscribe_stores, b as attr } from "./index3.js";
import { U as UserLink, q as publishedToDate, B as Button, A as ArrowDownTray, x as instanceToURL, p as profile, c as client, t as toast } from "./client.svelte.js";
import { t } from "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { T as Trash } from "./Trash.js";
import { m as modal, a as action } from "./modal2.js";
import { R as RelativeDate } from "./RelativeDate.js";
function PictrsImage($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let loading = false;
    async function deleteImage(image2) {
      if (!profile.current?.jwt) return;
      try {
        loading = true;
        const res = await client().deleteImage({
          token: image2.pictrs_delete_token,
          filename: image2.pictrs_alias
        });
        ondelete?.(res);
      } catch (e) {
        toast({ content: e, type: "error" });
      }
      loading = false;
    }
    let { image, user, ondelete } = $$props;
    function img($$renderer3) {
      $$renderer3.push(`<button class="cursor-pointer"><img${attr("src", `${stringify(instanceToURL(profile.current.instance))}/pictrs/image/${stringify(image.pictrs_alias)}`)} width="500" height="500" class="aspect-square w-full h-full object-cover rounded-xl" alt="pictrs"/></button>`);
    }
    $$renderer2.push(`<div class="flex flex-col gap-1">`);
    img($$renderer2);
    $$renderer2.push(`<!----> `);
    if (user) {
      $$renderer2.push("<!--[-->");
      UserLink($$renderer2, { user });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="flex items-center gap-2">`);
    RelativeDate($$renderer2, {
      class: "text-sm text-slate-700 dark:text-zinc-300",
      date: publishedToDate(image.published)
    });
    $$renderer2.push(`<!----> `);
    Button($$renderer2, {
      title: store_get($$store_subs ??= {}, "$t", t)("routes.profile.media.download"),
      href: `${stringify(instanceToURL(profile.current.instance))}/pictrs/image/${stringify(image.pictrs_alias)}`,
      size: "square-md",
      class: "ml-auto",
      icon: ArrowDownTray
    });
    $$renderer2.push(`<!----> `);
    Button($$renderer2, {
      title: store_get($$store_subs ??= {}, "$t", t)("post.actions.more.delete"),
      onclick: () => {
        modal({
          title: store_get($$store_subs ??= {}, "$t", t)("routes.theme.preset.delete.confirm"),
          body: "",
          snippet: img,
          actions: [
            action({
              close: true,
              content: store_get($$store_subs ??= {}, "$t", t)("common.cancel")
            }),
            action({
              type: "danger",
              action: () => deleteImage(image),
              close: true,
              content: store_get($$store_subs ??= {}, "$t", t)("post.actions.more.delete")
            })
          ]
        });
      },
      size: "square-md",
      loading,
      disabled: loading,
      icon: Trash
    });
    $$renderer2.push(`<!----></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  PictrsImage as P
};
//# sourceMappingURL=PictrsImage.js.map
