import { a as attr_class, c as clsx, e as escape_html, k as stringify } from "./index3.js";
import { I as Icon } from "./Icon.js";
function Placeholder($$renderer, $$props) {
  let {
    icon = void 0,
    title,
    description = void 0,
    class: clazz = "",
    children,
    iconClass
  } = $$props;
  $$renderer.push(`<div${attr_class(`text-slate-500 dark:text-zinc-500 contrast-more:text-slate-700 contrast-more:dark:text-zinc-300 flex flex-col w-max mx-auto items-center gap-4 ${stringify(clazz)}`)}><div class="flex flex-col gap-2 items-center max-w-sm">`);
  if (icon) {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<div${attr_class(clsx([
      iconClass ? iconClass : "bg-slate-100 dark:bg-zinc-900 p-3 rounded-2xl text-primary-900 dark:text-primary-100"
    ]))}>`);
    Icon($$renderer, { src: icon, size: "28", solid: true });
    $$renderer.push(`<!----></div>`);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--> <div${attr_class(clsx(["space-y-2", clazz]))}><h1 class="text-slate-900 dark:text-zinc-100 text-xl font-medium text-center">${escape_html(title)}</h1> `);
  if (description) {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<p class="text-center font-normal max-w-80 mx-auto text-balance">${escape_html(description)}</p>`);
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]--></div></div> `);
  children?.($$renderer);
  $$renderer.push(`<!----></div>`);
}
export {
  Placeholder as P
};
//# sourceMappingURL=Placeholder.js.map
