import { a as attr_class, c as clsx, f as bind_props } from "./index3.js";
import { computePosition, autoUpdate, offset, shift, flip } from "@floating-ui/dom";
import { M as Material } from "./client.svelte.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { P as Portal } from "./Portal.js";
import "clsx";
import { o as onDestroy, t as tick } from "./index-server.js";
const createFloatingActions = (initOptions) => {
  let referenceElement;
  let floatingElement;
  const defaultOptions = {
    autoUpdate: true
  };
  let options = initOptions ?? {};
  const getOptions = (mixin) => {
    return { ...defaultOptions, ...initOptions || {}, ...mixin || {} };
  };
  const update = (updateOptions) => {
    if (referenceElement && floatingElement) {
      options = getOptions(updateOptions);
      computePosition(referenceElement, floatingElement, options).then((v) => {
        Object.assign(floatingElement.style, {
          position: v.strategy,
          left: `${v.x}px`,
          top: `${v.y}px`
        });
        options?.onComputed && options.onComputed(v);
      });
    }
  };
  const referenceAction = (node) => {
    if ("subscribe" in node) {
      setupVirtualElementObserver(node);
      return {};
    } else {
      referenceElement = node;
      update();
    }
  };
  const contentAction = (node, contentOptions) => {
    let autoUpdateDestroy;
    floatingElement = node;
    options = getOptions(contentOptions);
    setTimeout(() => update(contentOptions), 0);
    update(contentOptions);
    const destroyAutoUpdate = () => {
      if (autoUpdateDestroy) {
        autoUpdateDestroy();
        autoUpdateDestroy = void 0;
      }
    };
    const initAutoUpdate = (_options = options) => {
      return new Promise((resolve) => {
        const { autoUpdate: autoUpdate$1 } = _options || {};
        destroyAutoUpdate();
        if (autoUpdate$1 !== false) {
          tick().then(() => {
            resolve(autoUpdate(referenceElement, floatingElement, () => update(_options), autoUpdate$1 === true ? {} : autoUpdate$1));
          });
        }
      });
    };
    initAutoUpdate().then((destroy) => autoUpdateDestroy = destroy);
    return {
      update(contentOptions2) {
        update(contentOptions2);
        initAutoUpdate().then((destroy) => autoUpdateDestroy = destroy);
      },
      destroy() {
        destroyAutoUpdate();
      }
    };
  };
  const setupVirtualElementObserver = (node) => {
    const unsubscribe = node.subscribe(($node) => {
      if (referenceElement === void 0) {
        referenceElement = $node;
        update();
      } else {
        Object.assign(referenceElement, $node);
        update();
      }
    });
    onDestroy(unsubscribe);
  };
  return [referenceAction, contentAction, update];
};
function Popover($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      openOnHover = false,
      open = false,
      autoClose = true,
      placement = "bottom-start",
      middleware = [offset(6), shift(), flip()],
      strategy = "fixed",
      popoverClass = "",
      target,
      popover,
      children
    } = $$props;
    const [floatingRef] = createFloatingActions({
      strategy,
      placement,
      middleware,
      onComputed: ({ placement: placement2 }) => {
      }
    });
    const menuAttach = (element) => {
      const e = element;
      function toggle(force) {
        if (!open && force == false) return;
        const newOpen = force ?? !open;
        if (!newOpen) {
          e.focus();
        }
        open = newOpen;
      }
      const mouseover = () => openOnHover && toggle(true);
      const mouseleave = () => openOnHover && toggle(false);
      const focus = () => openOnHover && toggle(true);
      const focusout = () => openOnHover && toggle(false);
      const click = () => {
        toggle();
        if (autoClose) {
          const clickHandler = (event) => {
            if (!e) return;
            const target2 = event.target;
            if (!e?.contains(event.target)) {
              if (target2?.closest("[data-autoclose='false']") == null) {
                toggle(false);
                document.removeEventListener("click", clickHandler);
              }
            }
          };
          document.addEventListener("click", clickHandler);
        }
      };
      e.addEventListener("mouseover", mouseover);
      e.addEventListener("mouseleave", mouseleave);
      e.addEventListener("focus", focus);
      e.addEventListener("focusout", focusout);
      e.addEventListener("click", click);
      floatingRef(e);
      return () => {
        e.addEventListener("mouseover", mouseover);
        e.removeEventListener("mouseleave", mouseleave);
        e.removeEventListener("focus", focus);
        e.removeEventListener("focusout", focusout);
        e.removeEventListener("click", click);
      };
    };
    target?.($$renderer2, menuAttach);
    $$renderer2.push(`<!----> `);
    if (open) {
      $$renderer2.push("<!--[-->");
      Portal($$renderer2, {
        class: "z-150",
        children: ($$renderer3) => {
          $$renderer3.push(`<div${attr_class(clsx(["z-150", popoverClass]))}>`);
          if (popover) {
            $$renderer3.push("<!--[-->");
            popover($$renderer3, open);
            $$renderer3.push(`<!---->`);
          } else {
            $$renderer3.push("<!--[!-->");
            Material($$renderer3, {
              elevation: "high",
              color: "distinct",
              rounding: "xl",
              padding: "sm",
              class: "flex flex-col",
              children: ($$renderer4) => {
                children?.($$renderer4, open);
                $$renderer4.push(`<!---->`);
              },
              $$slots: { default: true }
            });
          }
          $$renderer3.push(`<!--]--></div>`);
        }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    bind_props($$props, { open });
  });
}
export {
  Popover as P
};
//# sourceMappingURL=Popover.js.map
