import { f as bind_props, a as attr_class, b as attr, j as attr_style, c as clsx, k as stringify, e as escape_html, s as store_get, u as unsubscribe_stores, d as ensure_array_like, l as spread_props, i as element, g as await_block } from "./index3.js";
import { a7 as mediaType, q as publishedToDate, p as profile, M as Material, _ as Blobs, B as Button, a8 as PostIframe, a9 as iframeType, aa as bestImageURL, V as VideoCamera, W as postLink, Z as optimizeImageURL, L as LINKED_INSTANCE_URL, y as Spinner, x as instanceToURL, t as toast } from "./client.svelte.js";
import { s as settings } from "./settings.svelte.js";
import { p as parseTags, P as PostMeta, c as PostVote, B as BookmarkSlash, a as save } from "./PostVote.js";
import { P as PostBody } from "./PostBody.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { c as locale, t } from "./index.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import "clsx";
import "@dicebear/core";
import "@dicebear/initials";
import { I as Icon } from "./Icon.js";
import { a as Calendar, C as Clock } from "./Clock.js";
import { D as DocumentText, A as ArrowTopRightOnSquare } from "./DocumentText.js";
import { E as ExclamationTriangle } from "./ExclamationTriangle.js";
import { L as Link } from "./Link.js";
import { P as Photo } from "./Photo.js";
import { m as modal } from "./modal2.js";
import { p as page } from "./index4.js";
import { F as FormattedNumber } from "./FormattedNumber.js";
import { B as Bookmark } from "./Bookmark.js";
import { B as BugAnt } from "./BugAnt.js";
import { C as ChatBubbleOvalLeft } from "./ChatBubbleOvalLeft.js";
import { C as ChatBubbleOvalLeftEllipsis } from "./ChatBubbleOvalLeftEllipsis.js";
import { E as EllipsisHorizontal } from "./EllipsisHorizontal.js";
import { G as GlobeAlt } from "./GlobeAlt.js";
import { M as MapPin } from "./MapPin.js";
import { S as Share } from "./Share.js";
import { S as ShieldCheck } from "./ShieldCheck.js";
import { M as Modal } from "./Modal.js";
import { M as Menu, a as MenuButton } from "./MenuButton.js";
import { M as MenuDivider } from "./MenuDivider.js";
import { P as PostFormState } from "./postform.svelte.js";
import { C as CommonList } from "./CommonList.js";
import { E as EndPlaceholder } from "./EndPlaceholder.js";
import { p as parseURL } from "./Link2.js";
const CurrencyDollar = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M6.375 5.5h.875v1.75h-.875a.875.875 0 1 1 0-1.75ZM8.75 10.5V8.75h.875a.875.875 0 0 1 0 1.75H8.75Z"
      },
      {
        "fill-rule": "evenodd",
        "d": "M15 8A7 7 0 1 1 1 8a7 7 0 0 1 14 0ZM7.25 3.75a.75.75 0 0 1 1.5 0V4h2.5a.75.75 0 0 1 0 1.5h-2.5v1.75h.875a2.375 2.375 0 1 1 0 4.75H8.75v.25a.75.75 0 0 1-1.5 0V12h-2.5a.75.75 0 0 1 0-1.5h2.5V8.75h-.875a2.375 2.375 0 1 1 0-4.75h.875v-.25Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M10.75 10.818v2.614A3.13 3.13 0 0 0 11.888 13c.482-.315.612-.648.612-.875 0-.227-.13-.56-.612-.875a3.13 3.13 0 0 0-1.138-.432ZM8.33 8.62c.053.055.115.11.184.164.208.16.46.284.736.363V6.603a2.45 2.45 0 0 0-.35.13c-.14.065-.27.143-.386.233-.377.292-.514.627-.514.909 0 .184.058.39.202.592.037.051.08.102.128.152Z"
      },
      {
        "fill-rule": "evenodd",
        "d": "M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-8-6a.75.75 0 0 1 .75.75v.316a3.78 3.78 0 0 1 1.653.713c.426.33.744.74.925 1.2a.75.75 0 0 1-1.395.55 1.35 1.35 0 0 0-.447-.563 2.187 2.187 0 0 0-.736-.363V9.3c.698.093 1.383.32 1.959.696.787.514 1.29 1.27 1.29 2.13 0 .86-.504 1.616-1.29 2.13-.576.377-1.261.603-1.96.696v.299a.75.75 0 1 1-1.5 0v-.3c-.697-.092-1.382-.318-1.958-.695-.482-.315-.857-.717-1.078-1.188a.75.75 0 1 1 1.359-.636c.08.173.245.376.54.569.313.205.706.353 1.138.432v-2.748a3.782 3.782 0 0 1-1.653-.713C6.9 9.433 6.5 8.681 6.5 7.875c0-.805.4-1.558 1.097-2.096a3.78 3.78 0 0 1 1.653-.713V4.75A.75.75 0 0 1 10 4Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M12 6v12m-3-2.818.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M10.464 8.746c.227-.18.497-.311.786-.394v2.795a2.252 2.252 0 0 1-.786-.393c-.394-.313-.546-.681-.546-1.004 0-.323.152-.691.546-1.004ZM12.75 15.662v-2.824c.347.085.664.228.921.421.427.32.579.686.579.991 0 .305-.152.671-.579.991a2.534 2.534 0 0 1-.921.42Z"
      },
      {
        "fill-rule": "evenodd",
        "d": "M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25ZM12.75 6a.75.75 0 0 0-1.5 0v.816a3.836 3.836 0 0 0-1.72.756c-.712.566-1.112 1.35-1.112 2.178 0 .829.4 1.612 1.113 2.178.502.4 1.102.647 1.719.756v2.978a2.536 2.536 0 0 1-.921-.421l-.879-.66a.75.75 0 0 0-.9 1.2l.879.66c.533.4 1.169.645 1.821.75V18a.75.75 0 0 0 1.5 0v-.81a4.124 4.124 0 0 0 1.821-.749c.745-.559 1.179-1.344 1.179-2.191 0-.847-.434-1.632-1.179-2.191a4.122 4.122 0 0 0-1.821-.75V8.354c.29.082.559.213.786.393l.415.33a.75.75 0 0 0 .933-1.175l-.415-.33a3.836 3.836 0 0 0-1.719-.755V6Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const PresentationChartBar = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M1.75 2a.75.75 0 0 0 0 1.5H2V9a2 2 0 0 0 2 2h.043l-1.004 3.013a.75.75 0 0 0 1.423.474L4.624 14h6.752l.163.487a.75.75 0 1 0 1.422-.474L11.957 11H12a2 2 0 0 0 2-2V3.5h.25a.75.75 0 0 0 0-1.5H1.75Zm8.626 9 .5 1.5H5.124l.5-1.5h4.752ZM5.25 7a.75.75 0 0 0-.75.75v.5a.75.75 0 0 0 1.5 0v-.5A.75.75 0 0 0 5.25 7ZM10 4.75a.75.75 0 0 1 1.5 0v3.5a.75.75 0 0 1-1.5 0v-3.5ZM8 5.5a.75.75 0 0 0-.75.75v2a.75.75 0 0 0 1.5 0v-2A.75.75 0 0 0 8 5.5Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M1 2.75A.75.75 0 0 1 1.75 2h16.5a.75.75 0 0 1 0 1.5H18v8.75A2.75 2.75 0 0 1 15.25 15h-1.072l.798 3.06a.75.75 0 0 1-1.452.38L13.41 18H6.59l-.114.44a.75.75 0 0 1-1.452-.38L5.823 15H4.75A2.75 2.75 0 0 1 2 12.25V3.5h-.25A.75.75 0 0 1 1 2.75ZM7.373 15l-.391 1.5h6.037l-.392-1.5H7.373ZM13.25 5a.75.75 0 0 1 .75.75v5.5a.75.75 0 0 1-1.5 0v-5.5a.75.75 0 0 1 .75-.75Zm-6.5 4a.75.75 0 0 1 .75.75v1.5a.75.75 0 0 1-1.5 0v-1.5A.75.75 0 0 1 6.75 9Zm4-1.25a.75.75 0 0 0-1.5 0v3.5a.75.75 0 0 0 1.5 0v-3.5Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5M9 11.25v1.5M12 9v3.75m3-6v6"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2.25 2.25a.75.75 0 0 0 0 1.5H3v10.5a3 3 0 0 0 3 3h1.21l-1.172 3.513a.75.75 0 0 0 1.424.474l.329-.987h8.418l.33.987a.75.75 0 0 0 1.422-.474l-1.17-3.513H18a3 3 0 0 0 3-3V3.75h.75a.75.75 0 0 0 0-1.5H2.25Zm6.04 16.5.5-1.5h6.42l.5 1.5H8.29Zm7.46-12a.75.75 0 0 0-1.5 0v6a.75.75 0 0 0 1.5 0v-6Zm-3 2.25a.75.75 0 0 0-1.5 0v3.75a.75.75 0 0 0 1.5 0V9Zm-3 2.25a.75.75 0 0 0-1.5 0v1.5a.75.75 0 0 0 1.5 0v-1.5Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function Post($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    function getTagRule(tags2) {
      const tagContent = tags2.map((t2) => t2.content.toLowerCase());
      let rule2;
      if (settings.nsfwBlur && (post.post.nsfw || post.community.nsfw)) rule2 = "blur-sm";
      tagContent.forEach(() => {
        if (rule2 == "hide") return rule2;
      });
      return rule2;
    }
    let {
      post = void 0,
      actions = true,
      hideCommunity = false,
      view = settings.view,
      style = "",
      class: clazz = "",
      extraBadges,
      onhide
    } = $$props;
    let tags = (() => {
      const parsed = parseTags(post.post.name);
      return {
        title: parsed.title,
        tags: [
          ...parsed.tags,
          ...post.flair_list?.map((i) => ({
            content: i.flair_title,
            color: i.background_color,
            icon: null,
            type: "flair",
            textColor: i.text_color
          })) ?? []
        ]
      };
    })();
    let type = mediaType(post.post);
    let rule = getTagRule(tags.tags);
    let hideTitle = settings.posts.deduplicateEmbed && post.post.embed_title == post.post.name && view != "compact" && type != "iframe";
    let badges = {
      deleted: post.post.deleted,
      removed: post.post.removed,
      locked: post.post.locked,
      featured: post.post.featured_local || post.post.featured_community,
      nsfw: post.post.nsfw || post.community.nsfw,
      saved: post.saved,
      admin: post.creator_is_admin,
      moderator: post.creator_is_moderator
    };
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<article${attr_class(
        clsx([
          "relative group/post",
          settings.leftAlign && "left-align",
          view == "compact" && "py-3 list-type compact",
          view == "cozy" && "py-5 flex flex-col gap-2",
          clazz
        ]),
        "svelte-jjm1lj"
      )}${attr("id", post.post.id.toString())}${attr_style(style)}>`);
      PostMeta($$renderer3, {
        community: post.community,
        showCommunity: !hideCommunity,
        user: post.creator,
        published: publishedToDate(post.post.published),
        badges,
        subscribed: profile.current?.user?.follows.map((c) => c.community.id).includes(post.community.id) ? "Subscribed" : "NotSubscribed",
        id: post.post.id,
        title: hideTitle ? void 0 : tags?.title ? tags.title : post.post.name,
        read: post.read,
        style: "grid-area: meta;",
        edited: post.post.updated,
        tags: tags?.tags,
        postUrl: post.post.url,
        view,
        extraBadges
      });
      $$renderer3.push(`<!----> <!---->`);
      {
        $$renderer3.push(`<div style="grid-area:embed;"${attr_class(clsx({ contents: view == "cozy" }))}>`);
        if (rule != "hide") {
          $$renderer3.push("<!--[-->");
          PostMedia($$renderer3, {
            post: post.post,
            blur: rule == "blur-sm" ? true : void 0,
            view,
            type
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div> `);
        if (view == "compact") {
          $$renderer3.push("<!--[-->");
          PostMediaCompact($$renderer3, {
            post: post.post,
            type,
            class: `${stringify(settings.leftAlign ? "mr-3" : "ml-3")} shrink no-list-margin`,
            style: "grid-area: media;",
            blur: rule == "blur-sm" ? true : void 0,
            view
          });
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]-->`);
      }
      $$renderer3.push(`<!----> `);
      if (post.post.body && !post.post.nsfw && view != "compact") {
        $$renderer3.push("<!--[-->");
        PostBody($$renderer3, {
          element: "section",
          body: post.post.body,
          style: "grid-area: body",
          class: "relative"
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (actions) {
        $$renderer3.push("<!--[-->");
        PostActions($$renderer3, {
          onhide,
          style: "grid-area: actions;",
          view,
          get post() {
            return post;
          },
          set post($$value) {
            post = $$value;
            $$settled = false;
          }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></article>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { post });
  });
}
function formatRelativeDate(date, options, locale2, relativeTo, absolute) {
  try {
    const now = relativeTo?.getTime() ?? Date.now();
    const diffInMillis = now - date.getTime();
    const thresholds = [
      { unit: "second", threshold: 1e3 },
      { unit: "minute", threshold: 60 * 1e3 },
      { unit: "hour", threshold: 60 * 60 * 1e3 },
      { unit: "day", threshold: 24 * 60 * 60 * 1e3 },
      { unit: "week", threshold: 7 * 24 * 60 * 60 * 1e3 },
      { unit: "month", threshold: 30 * 24 * 60 * 60 * 1e3 },
      { unit: "year", threshold: 365 * 24 * 60 * 60 * 1e3 }
    ];
    for (let i = thresholds.length - 1; i >= 0; i--) {
      if (Math.abs(diffInMillis) >= thresholds[i].threshold) {
        const value = Math.round(diffInMillis / thresholds[i].threshold);
        let language = locale2 ?? "en";
        if (absolute) {
          const rtf = new Intl.DateTimeFormat(language, { ...options, timeStyle: "short", dateStyle: "short" });
          return rtf.format(date);
        } else {
          const rtf = new Intl.RelativeTimeFormat(language, options);
          return rtf.format(-value, thresholds[i].unit);
        }
      }
    }
    return "Now";
  } catch {
    return "Invalid Date";
  }
}
function RelativeDate($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const toLocaleDateString = (date2) => {
      try {
        return date2.toLocaleString();
      } catch {
        return "Invalid Date";
      }
    };
    let {
      date,
      relativeTo = void 0,
      options = { numeric: "always", style: "narrow" },
      absolute = settings.absoluteDates,
      style = "",
      class: clazz = ""
    } = $$props;
    let dateTime = toLocaleDateString(date);
    $$renderer2.push(`<time${attr("datetime", dateTime)}${attr("title", dateTime)}${attr_class(clsx(clazz))}${attr_style(style)}>${escape_html(formatRelativeDate(date, options, store_get($$store_subs ??= {}, "$locale", locale), relativeTo, absolute))}</time>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function PostEvent($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { post } = $$props;
    $$renderer2.push(`<div class="grid grid-cols-2 gap-4">`);
    Material($$renderer2, {
      rounding: "2xl",
      color: "info",
      class: "relative z-0 flex flex-col overflow-hidden col-span-2",
      children: ($$renderer3) => {
        $$renderer3.push(`<div class="-m-4 mask-b-from-0 scale-125 -z-10">`);
        Blobs($$renderer3, { seed: post.name });
        $$renderer3.push(`<!----></div> <h3 class="font-display text-3xl tracking-tight">${escape_html(post.name)}</h3>`);
      },
      $$slots: { default: true }
    });
    $$renderer2.push(`<!----> `);
    if (post.event.start) {
      $$renderer2.push("<!--[-->");
      const startDate = publishedToDate(post.event.start);
      Material($$renderer2, {
        rounding: "2xl",
        color: "info",
        class: "space-y-1",
        children: ($$renderer3) => {
          Icon($$renderer3, { src: Calendar, size: "20", mini: true });
          $$renderer3.push(`<!----> <h4 class="capitalize text-xl font-display"><date>${escape_html(startDate.toLocaleDateString(store_get($$store_subs ??= {}, "$locale", locale), { dateStyle: "long" }))}</date></h4> `);
          RelativeDate($$renderer3, { options: { style: "long" }, date: startDate });
          $$renderer3.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      Material($$renderer2, {
        rounding: "2xl",
        color: "info",
        class: "space-y-1",
        children: ($$renderer3) => {
          Icon($$renderer3, { src: Clock, size: "20", mini: true });
          $$renderer3.push(`<!----> <h4 class="capitalize text-xl font-display"><time>${escape_html(startDate.toLocaleTimeString(store_get($$store_subs ??= {}, "$locale", locale), { timeStyle: "long" }))}</time></h4> <time>${escape_html(startDate.toLocaleTimeString(store_get($$store_subs ??= {}, "$locale", locale), { timeZone: "GMT", timeStyle: "long" }))}</time>`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!---->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (post.event.event_fee_amount) {
      $$renderer2.push("<!--[-->");
      Material($$renderer2, {
        rounding: "2xl",
        color: "info",
        class: "space-y-1",
        children: ($$renderer3) => {
          Icon($$renderer3, { src: CurrencyDollar, size: "20", mini: true });
          $$renderer3.push(`<!----> <h5 class="capitalize text-lg font-display">${escape_html(post.event.event_fee_amount)}
        ${escape_html(post.event.event_fee_currency ?? "")}</h5>`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (post.event.location && Object.keys(post.event.location).length > 0) {
      $$renderer2.push("<!--[-->");
      Material($$renderer2, {
        rounding: "2xl",
        color: "info",
        class: "space-y-1",
        children: ($$renderer3) => {
          Icon($$renderer3, { src: MapPin, size: "20", mini: true });
          $$renderer3.push(`<!----> <h4 class="capitalize text-xl font-display">${escape_html(store_get($$store_subs ??= {}, "$t", t)("filter.location.label"))}</h4> <dl class="space-y-2"><!--[-->`);
          const each_array = ensure_array_like(Object.keys(post.event.location));
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let key = each_array[$$index];
            $$renderer3.push(`<div class="flex flex-row justify-between flex-wrap"><dt class="capitalize font-medium">${escape_html(key)}</dt> <dd>${escape_html(post.event.location[key])}</dd></div>`);
          }
          $$renderer3.push(`<!--]--></dl>`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function PostPoll($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { post } = $$props;
    let selected = post.poll.my_votes?.length == 1 ? post.poll.my_votes[0] : post.poll.my_votes;
    let canVote = !(post.poll.end_poll && publishedToDate(post.poll.end_poll).getTime() < Date.now() || !profile.current.jwt || (post.poll.my_votes?.length ?? 0) > 0);
    let chosen = canVote ? void 0 : -1;
    let options = post.poll.choices.map((i) => ({
      ...i,
      num_votes: typeof chosen !== "number" && chosen?.includes(i.id) || chosen == i.id ? i.num_votes + 1 : i.num_votes
    }));
    let totalVotes = options.reduce((a, b) => a + b.num_votes, 0);
    let loading = false;
    $$renderer2.push(`<form class="space-y-2 svelte-wwgx53">`);
    CommonList($$renderer2, {
      class: "",
      children: ($$renderer3) => {
        $$renderer3.push(`<!--[-->`);
        const each_array = ensure_array_like(options.toSorted((a, b) => a.sort_order - b.sort_order));
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let choice = each_array[$$index];
          const active = selected == choice.id || typeof selected !== "number" && selected?.includes(choice.id);
          const percentage = Math.floor((choice.num_votes / totalVotes || 0) * 100);
          const multi = post.poll.mode != "single";
          $$renderer3.push(`<li class="relative z-10 overflow-hidden has-disabled:pointer-events-none svelte-wwgx53" role="progressbar" aria-valuemin="0" aria-valuemax="100"${attr("aria-valuenow", percentage)}>`);
          if (chosen) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div${attr_class(clsx([
              "absolute inset-0 -z-10 p-0!",
              active ? "bg-primary-900/10 dark:bg-primary-100/10" : "bg-primary-900/5 dark:bg-primary-100/5"
            ]))}${attr_style(`width: ${stringify(percentage)}%; transition: all 0.5s cubic-bezier(0.075, 0.82, 0.165, 1);`)}></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> <label class="px-4 py-2 w-full text-left flex flex-row gap-2 items-center svelte-wwgx53">`);
          if (!multi) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<input class="appearance-none absolute inset-0 cursor-pointer w-full h-full peer svelte-wwgx53"${attr("name", `poll=${stringify(post.id)}`)}${attr("value", choice.id)}${attr("checked", selected === choice.id, true)} type="radio"${attr("disabled", !canVote, true)}/>`);
          } else {
            $$renderer3.push("<!--[!-->");
            $$renderer3.push(`<input class="appearance-none absolute inset-0 cursor-pointer w-full h-full peer svelte-wwgx53"${attr("name", `poll=${stringify(post.id)}`)}${attr("value", choice.id)}${attr("checked", selected.includes(choice.id), true)} type="checkbox"${attr("disabled", !canVote, true)}/>`);
          }
          $$renderer3.push(`<!--]--> <div${attr_class(clsx(["choice-indicator", multi ? "rounded-md" : "rounded-full"]), "svelte-wwgx53")}><div class="svelte-wwgx53"></div></div> <div${attr_class(clsx(["choice-text", "text-slate-600 dark:text-zinc-400"]), "svelte-wwgx53")}>${escape_html(choice.choice_text)}</div> `);
          if (chosen) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="ml-auto">${escape_html(percentage)}%</div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></label></li>`);
        }
        $$renderer3.push(`<!--]-->`);
      }
    });
    $$renderer2.push(`<!----> `);
    {
      let action = function($$renderer3) {
        if (selected && canVote || loading) {
          $$renderer3.push("<!--[-->");
          Button($$renderer3, {
            class: "w-24",
            color: "primary",
            submit: true,
            loading,
            disabled: loading,
            children: ($$renderer4) => {
              $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer3.push("<!--[!-->");
          if (post.poll.end_poll) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.poll.results.ends", {
              time: formatRelativeDate(publishedToDate(post.poll.end_poll), {})
            }))}`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]-->`);
      };
      EndPlaceholder($$renderer2, {
        size: "md",
        margin: "bottom-sm",
        action,
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.poll.votes", { votes: totalVotes }))}`);
        }
      });
    }
    $$renderer2.push(`<!----></form>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function PostMedia($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      view = "cozy",
      post,
      type = "none",
      opened = void 0,
      blur = post.nsfw && settings.nsfwBlur,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    if (type == "image" && view == "cozy") {
      $$renderer2.push("<!--[-->");
      PostImage($$renderer2, spread_props([{ post, blur }, rest]));
    } else {
      $$renderer2.push("<!--[!-->");
      if ((type == "iframe" || type == "video") && view == "cozy" && post.url) {
        $$renderer2.push("<!--[-->");
        PostIframe($$renderer2, spread_props([
          {
            thumbnail: post.thumbnail_url,
            type: iframeType(post.url),
            url: post.url,
            opened,
            title: post.name
          },
          rest
        ]));
      } else {
        $$renderer2.push("<!--[!-->");
        if (type == "poll" && post.poll && view == "cozy") {
          $$renderer2.push("<!--[-->");
          PostPoll($$renderer2, { post: { ...post, poll: post.poll } });
        } else {
          $$renderer2.push("<!--[!-->");
          if (type == "event" && post.event && view == "cozy") {
            $$renderer2.push("<!--[-->");
            PostEvent($$renderer2, { post: { ...post, event: post.event } });
          } else {
            $$renderer2.push("<!--[!-->");
            if (type == "embed" && post.url) {
              $$renderer2.push("<!--[-->");
              PostLink($$renderer2, spread_props([
                {
                  url: post.url,
                  thumbnail_url: post.thumbnail_url,
                  nsfw: post.nsfw,
                  embed_title: post.embed_title,
                  view
                },
                rest
              ]));
            } else {
              $$renderer2.push("<!--[!-->");
            }
            $$renderer2.push(`<!--]-->`);
          }
          $$renderer2.push(`<!--]-->`);
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]-->`);
  });
}
function PostMediaCompact($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const thumbnailSize = (view2) => view2 == "compact" ? "w-22 h-22 sm:w-28" : "w-24 h-24 sm:w-32";
    let {
      post,
      type = "none",
      view = "cozy",
      blur = post.nsfw && settings.nsfwBlur,
      style = "",
      class: clazz = ""
    } = $$props;
    let size = thumbnailSize(view);
    $$renderer2.push(`<div${attr_class(clsx([size, "relative group/media", clazz]), "svelte-1yaihdv")}${attr_style(style)} role="presentation">`);
    element(
      $$renderer2,
      !settings.expandImages || type != "image" ? "a" : "button",
      () => {
        $$renderer2.push(`${attr("href", postLink(post))}${attr("aria-label", type == "image" ? store_get($$store_subs ??= {}, "$t", t)("aria.postDecor.openImage", { default: post.name }) : store_get($$store_subs ??= {}, "$t", t)("aria.postDecor.openPost", { default: post.name }))}${attr("role", type == "image" ? "button" : "link")} tabindex="0" class="cursor-pointer h-full block svelte-1yaihdv"`);
      },
      () => {
        $$renderer2.push(`<div${attr_class(
          clsx([
            "relative overflow-hidden rounded-2xl max-h-full h-full",
            "border border-slate-200 dark:border-zinc-800 hover-scale-effect bg-slate-200 dark:bg-zinc-800"
          ]),
          "svelte-1yaihdv"
        )}>`);
        if (post.thumbnail_url || type == "image") {
          $$renderer2.push("<!--[-->");
          const thumbnail = post.thumbnail_url != void 0 && type != "image";
          $$renderer2.push(`<picture class="svelte-1yaihdv"><!--[-->`);
          const each_array = ensure_array_like(["webp"]);
          for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
            let format = each_array[$$index];
            $$renderer2.push(`<source${attr("srcset", `${stringify(bestImageURL(post, thumbnail, 128, format))} 1x, ${stringify(bestImageURL(post, thumbnail, 256, format))} 2x, ${stringify(bestImageURL(post, thumbnail, 512, format))} 3x`)} media="(min-width: 0px)"${attr("type", `image/${stringify(format)}`)}/>`);
          }
          $$renderer2.push(`<!--]--> <img${attr("src", blur ? "" : bestImageURL(post, thumbnail, -1, null))} loading="lazy"${attr_class(
            clsx([
              "object-cover relative overflow-hidden rounded-xl h-full",
              size
            ]),
            "svelte-1yaihdv",
            { "blur-xl": blur }
          )}${attr("alt", post.alt_text ?? " ")}/></picture> `);
          if (type != "image") {
            $$renderer2.push("<!--[-->");
            $$renderer2.push(`<div${attr_class(
              clsx([
                "absolute w-8 h-8 bottom-1 left-1 rounded-xl bg-slate-25 dark:bg-zinc-900 grid place-items-center"
              ]),
              "svelte-1yaihdv"
            )}>`);
            Icon($$renderer2, {
              src: type == "iframe" ? VideoCamera : Link,
              micro: true,
              size: "16"
            });
            $$renderer2.push(`<!----></div>`);
          } else {
            $$renderer2.push("<!--[!-->");
          }
          $$renderer2.push(`<!--]-->`);
        } else {
          $$renderer2.push("<!--[!-->");
          const typeIconMap = /* @__PURE__ */ new Map([
            ["embed", Link],
            ["iframe", VideoCamera],
            ["poll", PresentationChartBar],
            ["event", Calendar]
          ]);
          $$renderer2.push(`<div${attr_class(
            clsx([
              "bg-slate-100 dark:bg-zinc-900 w-full h-full rounded-xl grid place-items-center",
              "text-slate-600 dark:text-zinc-400"
            ]),
            "svelte-1yaihdv"
          )}>`);
          Icon($$renderer2, {
            src: typeIconMap.get(type) ?? DocumentText,
            solid: true,
            size: "32"
          });
          $$renderer2.push(`<!----></div>`);
        }
        $$renderer2.push(`<!--]--></div> `);
        if (blur) {
          $$renderer2.push("<!--[-->");
          Icon($$renderer2, {
            src: ExclamationTriangle,
            solid: true,
            size: "32",
            class: "absolute w-8 h-8 mx-auto my-auto z-30 inset-0 opacity-30"
          });
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]-->`);
      }
    );
    $$renderer2.push(` `);
    if (post.alt_text) {
      $$renderer2.push("<!--[-->");
      Button($$renderer2, {
        onclick: () => modal({ title: "Alt text", body: post.alt_text }),
        "aria-label": "Alt text",
        class: "absolute bottom-0 left-0 z-20 m-1",
        size: "square-md",
        rounding: "xl",
        children: ($$renderer3) => {
          Icon($$renderer3, { src: Photo, size: "16", micro: true });
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function PostImage($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { post, blur = false } = $$props;
    element(
      $$renderer2,
      settings.expandImages ? "button" : "a",
      () => {
        $$renderer2.push(`${attr("href", postLink(post))}${attr_class(clsx([
          "container/a z-10 rounded-2xl cursor-pointer relative overflow-hidden",
          "bg-slate-100 dark:bg-zinc-900 transition-colors",
          "border border-slate-200 dark:border-zinc-800 group"
        ]))} data-sveltekit-preload-data="off"${attr("aria-label", post.name)} role="button" tabindex="0"`);
      },
      () => {
        $$renderer2.push(`<div class="inset-0 absolute -z-10 rounded-xl overflow-hidden"><img loading="lazy" fetchpriority="auto"${attr("src", bestImageURL(post, false, 64))} class="object-cover w-full h-full opacity-50 blur-lg"/></div> <picture class="max-h-[60vh]"><!--[-->`);
        const each_array = ensure_array_like(["webp"]);
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let format = each_array[$$index];
          $$renderer2.push(`<source${attr("srcset", `${stringify(bestImageURL(post, false, 512, format))} 512w, ${stringify(bestImageURL(post, false, 768, format))} 768w, ${stringify(bestImageURL(post, false, 1024, format))} 1024w`)} media="(min-width: 0px)"${attr("type", `image/${stringify(format)}`)}/>`);
        }
        $$renderer2.push(`<!--]--> <img${attr("src", blur ? "" : bestImageURL(post, false, -1, null))} loading="lazy"${attr_class(clsx([
          "max-w-full rounded-xl z-30 transition-all max-h-[60vh] duration-500 object-contain mx-auto group-hover:scale-98 group-active:scale-95",
          "duration-200 ease-cubic",
          "opacity-100",
          blur && "blur-3xl"
        ]))}${attr("width", 512)}${attr("height", 300)}${attr("alt", post.alt_text ?? "")} onload="this.__e=event"/></picture>  <div class="absolute bottom-0 left-0 right-0 flex justify-between items-center rounded-full ml-auto w-max m-2 p-0 gap-1 *:bg-white *:border *:border-slate-200 dark:*:border-zinc-800 dark:*:bg-zinc-900">`);
        if (post.alt_text) {
          $$renderer2.push("<!--[-->");
          Button($$renderer2, {
            onclick: (e) => {
              e.stopPropagation();
              modal({ title: "Alt", body: post.alt_text ?? "" });
            },
            color: "tertiary",
            size: "md",
            rounding: "pill",
            children: ($$renderer3) => {
              $$renderer3.push(`<!---->ALT`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]--></div>`);
      }
    );
  });
}
function PostLink($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { url, thumbnail_url, nsfw = false, embed_title, view = "cozy" } = $$props;
    let richURL = parseURL(url);
    if (embed_title && view == "cozy") {
      $$renderer2.push("<!--[-->");
      Material($$renderer2, {
        color: "default",
        class: [
          "post-link group/link hover:bg-slate-50 hover:dark:bg-zinc-800 transition-colors"
        ],
        rounding: "xl",
        element: "a",
        padding: "none",
        href: url,
        target: "_blank",
        rel: "noopener",
        children: ($$renderer3) => {
          $$renderer3.push(`<div${attr_class(clsx(["post-link-url", thumbnail_url && "-mt-2 sm:mt-0"]), "svelte-11ve8xr")}>`);
          if (richURL) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="link-hostname svelte-11ve8xr">${escape_html(richURL.hostname)}</div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> <p class="post-link-title svelte-11ve8xr">${escape_html(embed_title)}</p></div> `);
          if (thumbnail_url) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div class="post-link-image svelte-11ve8xr"><picture class="contents"><!--[-->`);
            const each_array = ensure_array_like(["webp"]);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let format = each_array[$$index];
              $$renderer3.push(`<source${attr("srcset", `${stringify(optimizeImageURL(thumbnail_url, 256, format))} 256w, ${stringify(optimizeImageURL(thumbnail_url, 512, format))} 512w`)} media="(min-width: 0px)"${attr("type", `image/${stringify(format)}`)}/>`);
            }
            $$renderer3.push(`<!--]--> <img${attr("src", optimizeImageURL(thumbnail_url, -1))}${attr_class("svelte-11ve8xr", void 0, { "blur-3xl": nsfw })}${attr("width", 600)}${attr("height", 400)} alt=""/></picture> `);
            Material($$renderer3, {
              padding: "xs",
              color: "uniform",
              class: "absolute top-0 right-0 m-2 z-50",
              role: "presentation",
              children: ($$renderer4) => {
                Icon($$renderer4, {
                  src: ArrowTopRightOnSquare,
                  size: "16",
                  micro: true,
                  class: "text-slate-500 dark:text-zinc-300"
                });
              },
              $$slots: { default: true }
            });
            $$renderer3.push(`<!----></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<a${attr("href", url)} target="_blank" rel="noopener noreferrer" class="post-link-compact svelte-11ve8xr">`);
      Icon($$renderer2, { src: Link, size: "16", micro: true, class: "shrink-0" });
      $$renderer2.push(`<!----> `);
      if (richURL) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="post-link-url svelte-11ve8xr">${escape_html(richURL.hostname)} `);
        if (richURL.pathname != "/") {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<span class="post-link-extended svelte-11ve8xr">${escape_html(richURL.pathname)}</span>`);
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]--></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`${escape_html(url)}`);
      }
      $$renderer2.push(`<!--]--></a>`);
    }
    $$renderer2.push(`<!--]-->`);
  });
}
const photon = {
  a: {
    viewBox: "0 0 100 100",
    fill: "currentColor"
  },
  path: [
    {
      "fill-rule": "evenodd",
      d: "M45.5 10.8868C48.594 9.10042 52.406 9.10042 55.5 10.8868L82.3061 26.3632C85.4001 28.1496 87.3061 31.4508 87.3061 35.0235V65.9765C87.3061 69.5492 85.4001 72.8504 82.3061 74.6368L55.5 90.1132C52.406 91.8996 48.594 91.8996 45.5 90.1132L18.6939 74.6368C15.5999 72.8504 13.6939 69.5492 13.6939 65.9765V35.0235C13.6939 31.4508 15.5999 28.1496 18.6939 26.3632L45.5 10.8868Z",
      "clip-rule": "evenodd"
    }
  ]
};
const outline = {
  a: {
    viewBox: "0 0 100 100",
    fill: "currentColor",
    "stroke-width": "1.5",
    stroke: "currentColor"
  },
  path: [
    {
      d: "M45.5 10.8868C48.594 9.10042 52.406 9.10042 55.5 10.8868L82.3061 26.3632C85.4001 28.1496 87.3061 31.4508 87.3061 35.0235V65.9765C87.3061 69.5492 85.4001 72.8504 82.3061 74.6368L55.5 90.1132C52.406 91.8996 48.594 91.8996 45.5 90.1132L18.6939 74.6368C15.5999 72.8504 13.6939 69.5492 13.6939 65.9765V35.0235C13.6939 31.4508 15.5999 28.1496 18.6939 26.3632L45.5 10.8868Z",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }
  ]
};
const Photon = {
  micro: photon,
  mini: photon,
  solid: photon,
  outline
};
function PostActions($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let saving = false;
    let editing = false;
    let {
      post = void 0,
      view = "cozy",
      debug = false,
      style = "",
      onedit,
      onhide
    } = $$props;
    let buttonHeight = view == "compact" ? "h-7.5" : "h-8";
    let buttonSquare = view == "compact" ? "w-7.5 h-7.5" : "w-8 h-8";
    function share(global = true, url) {
      const link = url ?? (global ? post.post.ap_id : `${instanceToURL(profile.current.instance)}/post/${post.post.id}`);
      if (navigator.share) navigator.share?.({ url: link });
      else {
        navigator.clipboard.writeText(link);
        toast({
          content: store_get($$store_subs ??= {}, "$t", t)("toast.copied")
        });
      }
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (editing) {
        $$renderer3.push("<!--[-->");
        {
          let customTitle = function($$renderer4) {
            $$renderer4.push(`<h1 class="text-2xl font-bold">${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.edit"))}</h1>`);
          };
          Modal($$renderer3, {
            get open() {
              return editing;
            },
            set open($$value) {
              editing = $$value;
              $$settled = false;
            },
            customTitle,
            children: ($$renderer4) => {
              await_block(
                $$renderer4,
                import("./PostForm.js"),
                () => {
                  $$renderer4.push(`<div class="mx-auto h-96 flex justify-center items-center">`);
                  Spinner($$renderer4, { width: 32 });
                  $$renderer4.push(`<!----></div>`);
                },
                ({ default: PostForm }) => {
                  $$renderer4.push(`<!---->`);
                  {
                    let title = function($$renderer5) {
                    };
                    PostForm($$renderer4, {
                      editPost: post.post.id,
                      onsubmit: (e) => {
                        editing = false;
                        post = e;
                        onedit?.(e);
                      },
                      init: new PostFormState({
                        type: post.post.poll ? "poll" : post.post.event ? "event" : "normal",
                        ...post.post
                      }),
                      title,
                      $$slots: { title: true }
                    });
                  }
                  $$renderer4.push(`<!---->`);
                }
              );
              $$renderer4.push(`<!--]-->`);
            },
            $$slots: { customTitle: true, default: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <footer${attr_class(
        clsx([
          "flex flex-row gap-2 items-center shrink-0 text-slate-600 dark:text-zinc-400",
          buttonHeight
        ]),
        void 0,
        { "flex-row-reverse": settings.posts.reverseActions }
      )}${attr_style(style)}>`);
      PostVote($$renderer3, {
        post: post.post,
        get vote() {
          return post.my_vote;
        },
        set vote($$value) {
          post.my_vote = $$value;
          $$settled = false;
        },
        get score() {
          return post.counts.score;
        },
        set score($$value) {
          post.counts.score = $$value;
          $$settled = false;
        },
        get upvotes() {
          return post.counts.upvotes;
        },
        set upvotes($$value) {
          post.counts.upvotes = $$value;
          $$settled = false;
        },
        get downvotes() {
          return post.counts.downvotes;
        },
        set downvotes($$value) {
          post.counts.downvotes = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      Button($$renderer3, {
        size: "custom",
        href: `${stringify(postLink(post.post))}#comments`,
        class: "text-inherit! h-full px-3 relative",
        rounding: "xl",
        target: settings.openLinksInNewTab ? "_blank" : "",
        "aria-label": store_get($$store_subs ??= {}, "$t", t)("post.actions.comments"),
        children: ($$renderer4) => {
          const newComment = publishedToDate(post.counts.newest_comment_time).getTime() > (/* @__PURE__ */ new Date()).getTime() - 5 * 60 * 1e3;
          Icon($$renderer4, {
            src: newComment ? ChatBubbleOvalLeftEllipsis : ChatBubbleOvalLeft,
            size: "16",
            mini: true
          });
          $$renderer4.push(`<!----> `);
          FormattedNumber($$renderer4, { number: post.counts.comments });
          $$renderer4.push(`<!---->`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> <div class="flex-1"></div> `);
      if (settings.debugInfo) {
        $$renderer3.push("<!--[-->");
        if (debug) {
          $$renderer3.push("<!--[-->");
          await_block($$renderer3, import("./DebugObject.js"), () => {
          }, ({ default: DebugObject }) => {
            $$renderer3.push(`<!---->`);
            DebugObject($$renderer3, {
              object: post,
              get open() {
                return debug;
              },
              set open($$value) {
                debug = $$value;
                $$settled = false;
              }
            });
            $$renderer3.push(`<!---->`);
          });
          $$renderer3.push(`<!--]-->`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        Button($$renderer3, {
          onclick: () => debug = true,
          title: "Debug",
          size: "custom",
          rounding: "xl",
          class: buttonSquare,
          icon: BugAnt
        });
        $$renderer3.push(`<!---->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (profile.isMod(post.community) || profile.isAdmin) {
        $$renderer3.push("<!--[-->");
        await_block($$renderer3, import("./ModerationMenu.js"), () => {
        }, ({ default: ModerationMenu }) => {
          $$renderer3.push(`<!---->`);
          {
            let target = function($$renderer4, attachment, acting) {
              Button($$renderer4, {
                size: "custom",
                rounding: "xl",
                loading: acting,
                class: buttonSquare,
                children: ($$renderer5) => {
                  Icon($$renderer5, { src: ShieldCheck, size: "18", mini: true });
                },
                $$slots: { default: true }
              });
            };
            ModerationMenu($$renderer3, {
              get item() {
                return post;
              },
              set item($$value) {
                post = $$value;
                $$settled = false;
              },
              target,
              $$slots: { target: true }
            });
          }
          $$renderer3.push(`<!---->`);
        });
        $$renderer3.push(`<!--]-->`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (profile.current?.jwt) {
        $$renderer3.push("<!--[-->");
        Button($$renderer3, {
          onclick: async () => {
            if (!profile.current?.jwt) return;
            saving = true;
            post.saved = await save(post, !post.saved);
            saving = false;
          },
          size: "custom",
          class: buttonSquare,
          rounding: "xl",
          loading: saving,
          disabled: saving,
          title: post.saved ? store_get($$store_subs ??= {}, "$t", t)("post.actions.unsave") : store_get($$store_subs ??= {}, "$t", t)("post.actions.save"),
          icon: post.saved ? BookmarkSlash : Bookmark
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      {
        let target = function($$renderer4, attachment) {
          Button($$renderer4, {
            rounding: "xl",
            size: "custom",
            class: buttonSquare,
            onclick: () => {
              if (post.post.local) share();
            },
            icon: Share,
            title: store_get($$store_subs ??= {}, "$t", t)("post.actions.more.share")
          });
        };
        Menu($$renderer3, {
          placement: "bottom-end",
          target,
          children: ($$renderer4) => {
            MenuDivider($$renderer4, {
              showLabel: true,
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.actions.more.share.from"))}`);
              }
            });
            $$renderer4.push(`<!----> `);
            MenuButton($$renderer4, {
              onclick: () => share(true),
              icon: GlobeAlt,
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.actions.more.share.global"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            MenuButton($$renderer4, {
              onclick: () => share(false),
              icon: MapPin,
              children: ($$renderer5) => {
                $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.actions.more.share.local"))}`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----> `);
            if (!LINKED_INSTANCE_URL) {
              $$renderer4.push("<!--[-->");
              MenuDivider($$renderer4, {
                children: ($$renderer5) => {
                }
              });
              $$renderer4.push(`<!----> `);
              MenuButton($$renderer4, {
                onclick: () => share(false, new URL(`/go/${post.post.ap_id}`, page.url.origin).toString()),
                icon: Photon,
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.actions.more.share.photon"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!---->`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { target: true, default: true }
        });
      }
      $$renderer3.push(`<!----> `);
      if (profile.current.jwt) {
        $$renderer3.push("<!--[-->");
        {
          let target = function($$renderer4, popover) {
            Button($$renderer4, {
              title: store_get($$store_subs ??= {}, "$t", t)("post.actions.more.label"),
              rounding: "xl",
              size: "custom",
              class: buttonSquare,
              icon: EllipsisHorizontal
            });
          }, children = function($$renderer4, open) {
            if (open) {
              $$renderer4.push("<!--[-->");
              await_block(
                $$renderer4,
                import("./PostActionsMenu.js"),
                () => {
                  $$renderer4.push(`<div class="p-8 w-full h-full grid place-items-center">`);
                  Spinner($$renderer4, { width: 20 });
                  $$renderer4.push(`<!----></div>`);
                },
                ({ default: PostActionsMenu }) => {
                  $$renderer4.push(`<!---->`);
                  PostActionsMenu($$renderer4, {
                    onhide,
                    get post() {
                      return post;
                    },
                    set post($$value) {
                      post = $$value;
                      $$settled = false;
                    },
                    get editing() {
                      return editing;
                    },
                    set editing($$value) {
                      editing = $$value;
                      $$settled = false;
                    }
                  });
                  $$renderer4.push(`<!---->`);
                }
              );
              $$renderer4.push(`<!--]-->`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          };
          Menu($$renderer3, {
            placement: "bottom-end",
            target,
            children,
            $$slots: { target: true, default: true }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></footer>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { post, debug });
  });
}
export {
  Post as P,
  PostMedia as a,
  PostActions as b
};
//# sourceMappingURL=PostActions.js.map
