import { e as escape_html, s as store_get, k as stringify, u as unsubscribe_stores, f as bind_props } from "./index3.js";
import { p as profile, P as PiefedClient, T as hidePost } from "./client.svelte.js";
import { t } from "./index.js";
import { s as settings } from "./settings.svelte.js";
import { m as markAsRead, d as deleteItem } from "./PostVote.js";
import { c as report } from "./moderation.js";
import { A as ArrowTopRightOnSquare } from "./DocumentText.js";
import { E as EyeSlash, a as Eye } from "./EyeSlash.js";
import { F as Flag } from "./Flag.js";
import { P as PencilSquare } from "./PencilSquare.js";
import { T as Trash } from "./Trash.js";
import { X as XMark } from "./XMark.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { a as MenuButton } from "./MenuButton.js";
function PostActionsMenu($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { post = void 0, onhide, editing = void 0 } = $$props;
    function crosspostB64() {
      return JSON.stringify({
        body: `${settings.crosspostOriginalLink ? `cross-posted from: ${post.post.ap_id}` : ``}
${post.post.body ? ">" + post.post.body.split("\n").join("\n> ") : ""}`,
        name: post.post.name,
        url: post.post.url,
        nsfw: post.post.nsfw
      });
    }
    if (profile.current?.user && profile.current?.jwt && profile.current.user.local_user_view.person.id == post.creator.id) {
      $$renderer2.push("<!--[-->");
      MenuButton($$renderer2, {
        onclick: () => editing = true,
        icon: PencilSquare,
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.actions.more.edit"))}`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (profile.current?.jwt) {
      $$renderer2.push("<!--[-->");
      MenuButton($$renderer2, {
        onclick: async () => {
          if (profile.current?.jwt) post.read = await markAsRead(post.post, !post.read);
        },
        icon: post.read ? EyeSlash : Eye,
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(post.read ? store_get($$store_subs ??= {}, "$t", t)("post.actions.more.markUnread") : store_get($$store_subs ??= {}, "$t", t)("post.actions.more.markRead"))}`);
        },
        $$slots: { default: true }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (profile.current?.jwt) {
      $$renderer2.push("<!--[-->");
      MenuButton($$renderer2, {
        href: `/create/post?crosspost=${stringify(crosspostB64())}`,
        icon: ArrowTopRightOnSquare,
        children: ($$renderer3) => {
          $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("post.actions.more.crosspost"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer2.push(`<!----> `);
      if (profile.current.user && post.creator.id == profile.current.user.local_user_view.person.id) {
        $$renderer2.push("<!--[-->");
        MenuButton($$renderer2, {
          onclick: async () => {
            if (profile.current?.jwt) post.post.deleted = await deleteItem(post, !post.post.deleted);
          },
          color: "danger-subtle",
          icon: Trash,
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(post.post.deleted ? store_get($$store_subs ??= {}, "$t", t)("post.actions.more.restore") : store_get($$store_subs ??= {}, "$t", t)("post.actions.more.delete"))}`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (profile.current.user?.local_user_view.person.id != post.creator.id) {
        $$renderer2.push("<!--[-->");
        if (!(profile.client instanceof PiefedClient)) {
          $$renderer2.push("<!--[-->");
          MenuButton($$renderer2, {
            onclick: async () => {
              if (!profile.current?.jwt) return;
              const hidden = await hidePost(post.post.id, !post.hidden, profile.current?.jwt);
              post.hidden = hidden;
              if (hidden) onhide?.(hidden);
            },
            color: "danger-subtle",
            icon: XMark,
            children: ($$renderer3) => {
              $$renderer3.push(`<!---->${escape_html(post.hidden ? store_get($$store_subs ??= {}, "$t", t)("post.actions.more.unhide") : store_get($$store_subs ??= {}, "$t", t)("post.actions.more.hide"))}`);
            },
            $$slots: { default: true }
          });
        } else {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]--> `);
        MenuButton($$renderer2, {
          onclick: () => report(post),
          color: "danger-subtle",
          icon: Flag,
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.report"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer2.push(`<!---->`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { post, editing });
  });
}
export {
  PostActionsMenu as default
};
//# sourceMappingURL=PostActionsMenu.js.map
