import { i as element, j as attr_style, a as attr_class, c as clsx } from "./index3.js";
import { i as Markdown } from "./client.svelte.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
function PostBody($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      body,
      clickThrough = false,
      element: htmlElement = "div",
      style = "",
      class: clazz = ""
    } = $$props;
    element(
      $$renderer2,
      htmlElement,
      () => {
        $$renderer2.push(`${attr_style(style)}${attr_class(clsx([
          [
            "overflow-hidden bg-linear-to-b text-transparent from-slate-600 via-slate-600",
            "dark:from-zinc-400 dark:via-zinc-400 bg-clip-text z-0 max-h-36"
          ],
          clickThrough && "pointer-events-none",
          clazz
        ]))}`);
      },
      () => {
        Markdown($$renderer2, { source: body.slice(0, 1e3) });
        $$renderer2.push(`<!----> `);
        {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]-->`);
      }
    );
  });
}
export {
  PostBody as P
};
//# sourceMappingURL=PostBody.js.map
