import { f as bind_props, e as escape_html, i as element, b as attr } from "./index3.js";
import { b as browser } from "./index5.js";
import { p as page } from "./index4.js";
import { s as settings } from "./settings.svelte.js";
import { L as Location } from "./Location.js";
import { S as Sort } from "./Sort.js";
import { V as ViewSelect } from "./ViewSelect.js";
import { V as VirtualFeed, P as PostFeed, A as ArrowRight } from "./VirtualFeed.js";
import { B as Button } from "./client.svelte.js";
import { I as Icon } from "./Icon.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { H as Header } from "./Header.js";
import { P as Pageination } from "./Pageination.js";
function PostListShell($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let {
      params,
      posts = void 0,
      cursor = void 0,
      title,
      extended: passedExtended,
      getParams,
      client = void 0,
      header = true
    } = $$props;
    let filters = { location: params.location, sort: params.sort };
    const FeedComponent = settings.infiniteScroll && browser ? VirtualFeed : PostFeed;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      var bind_get = () => client.lastSeen ?? 0;
      var bind_set = (v) => client.lastSeen = v;
      $$renderer3.push(`<div class="flex flex-col gap-2 max-w-full w-full min-w-0">`);
      if (header) {
        $$renderer3.push("<!--[-->");
        {
          let extended = function($$renderer4) {
            passedExtended?.($$renderer4);
            $$renderer4.push(`<!----> <form method="get"${attr("action", page.url.pathname)}><div class="flex flex-row gap-2">`);
            if (filters.location) {
              $$renderer4.push("<!--[-->");
              Location($$renderer4, {
                name: "type",
                navigate: true,
                get selected() {
                  return filters.location;
                },
                set selected($$value) {
                  filters.location = $$value;
                  $$settled = false;
                }
              });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> `);
            if (filters.sort) {
              $$renderer4.push("<!--[-->");
              Sort($$renderer4, {
                placement: "bottom",
                name: "sort",
                navigate: true,
                get selected() {
                  return filters.sort;
                },
                set selected($$value) {
                  filters.sort = $$value;
                  $$settled = false;
                }
              });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> `);
            ViewSelect($$renderer4, { placement: "bottom" });
            $$renderer4.push(`<!----> <noscript>`);
            Button($$renderer4, {
              class: "self-end h-[34px] aspect-square",
              size: "custom",
              submit: true,
              children: ($$renderer5) => {
                Icon($$renderer5, { src: ArrowRight, size: "16", micro: true });
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></noscript></div></form>`);
          };
          Header($$renderer3, {
            pageHeader: true,
            extended,
            children: ($$renderer4) => {
              if (title) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`${escape_html(title)}`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            }
          });
        }
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <!---->`);
      FeedComponent($$renderer3, {
        get lastSeen() {
          return bind_get();
        },
        set lastSeen($$value) {
          bind_set($$value);
        },
        virtualList: { itemHeights: client?.itemHeights ?? [] },
        get posts() {
          return posts;
        },
        set posts($$value) {
          posts = $$value;
          $$settled = false;
        },
        get params() {
          return getParams;
        },
        set params($$value) {
          getParams = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      element(
        $$renderer3,
        settings.infiniteScroll && !settings.posts.noVirtualize ? "noscript" : "div",
        () => {
          $$renderer3.push(` class="mt-auto flex flex-col"`);
        },
        () => {
          Pageination($$renderer3, {
            cursor: { next: cursor },
            href: (page2) => typeof page2 == "number" ? `?page=${page2}` : `?cursor=${page2}`,
            back: false
          });
        }
      );
      $$renderer3.push(`</div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { posts, cursor, client });
  });
}
export {
  PostListShell as P
};
//# sourceMappingURL=PostListShell.js.map
