import { s as store_get, a as attr_class, j as attr_style, c as clsx, b as attr, d as ensure_array_like, i as element, e as escape_html, k as stringify, u as unsubscribe_stores, f as bind_props, g as await_block } from "./index3.js";
import { n as SvelteMap, U as UserLink, q as publishedToDate, b as Badge, p as profile, i as Markdown, h as Avatar, M as Material, a as getClient, w as isCommentView, a4 as isComment, a5 as buttonColor, s as site } from "./client.svelte.js";
import { t } from "./index.js";
import { s as settings } from "./settings.svelte.js";
import { I as Icon } from "./Icon.js";
import { B as Bookmark } from "./Bookmark.js";
import { E as ExclamationTriangle } from "./ExclamationTriangle.js";
import { M as Megaphone, L as LockClosed } from "./Megaphone.js";
import { P as PaperAirplane } from "./PaperAirplane.js";
import { S as ShieldCheck } from "./ShieldCheck.js";
import { T as Tag } from "./Tag.js";
import { T as Trash } from "./Trash.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { P as Popover } from "./Popover.js";
import { R as RelativeDate, f as formatRelativeDate } from "./RelativeDate.js";
import { C as CommunityLink } from "./CommunityLink.js";
import { F as FormattedNumber } from "./FormattedNumber.js";
import { C as ChevronDown } from "./ChevronDown.js";
import { C as ChevronUp } from "./ChevronUp.js";
const BookmarkSlash = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M13 2.75v7.775L4.475 2h7.775a.75.75 0 0 1 .75.75ZM3 13.25V5.475l4.793 4.793L4.28 13.78A.75.75 0 0 1 3 13.25ZM2.22 2.22a.75.75 0 0 1 1.06 0l10.5 10.5a.75.75 0 1 1-1.06 1.06L2.22 3.28a.75.75 0 0 1 0-1.06Z"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M17 4.517v9.301L5.433 2.252a41.44 41.44 0 0 1 9.637.058C16.194 2.45 17 3.414 17 4.517ZM3 17.25V6.182l10.654 10.654L10 15.082l-5.925 2.844A.75.75 0 0 1 3 17.25ZM3.28 2.22a.75.75 0 0 0-1.06 1.06l14.5 14.5a.75.75 0 1 0 1.06-1.06L3.28 2.22Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "m3 3 1.664 1.664M21 21l-1.5-1.5m-5.485-1.242L12 17.25 4.5 21V8.742m.164-4.078a2.15 2.15 0 0 1 1.743-1.342 48.507 48.507 0 0 1 11.186 0c1.1.128 1.907 1.077 1.907 2.185V19.5M4.664 4.664 19.5 19.5"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M3.53 2.47a.75.75 0 0 0-1.06 1.06l18 18a.75.75 0 1 0 1.06-1.06l-18-18ZM20.25 5.507v11.561L5.853 2.671c.15-.043.306-.075.467-.094a49.255 49.255 0 0 1 11.36 0c1.497.174 2.57 1.46 2.57 2.93ZM3.75 21V6.932l14.063 14.063L12 18.088l-7.165 3.583A.75.75 0 0 1 3.75 21Z"
      }
    ]
  }
};
const Pencil = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M11.013 2.513a1.75 1.75 0 0 1 2.475 2.474L6.226 12.25a2.751 2.751 0 0 1-.892.596l-2.047.848a.75.75 0 0 1-.98-.98l.848-2.047a2.75 2.75 0 0 1 .596-.892l7.262-7.261Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "m2.695 14.762-1.262 3.155a.5.5 0 0 0 .65.65l3.155-1.262a4 4 0 0 0 1.343-.886L17.5 5.501a2.121 2.121 0 0 0-3-3L3.58 13.419a4 4 0 0 0-.885 1.343Z"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L6.832 19.82a4.5 4.5 0 0 1-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 0 1 1.13-1.897L16.863 4.487Zm0 0L19.5 7.125"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "d": "M21.731 2.269a2.625 2.625 0 0 0-3.712 0l-1.157 1.157 3.712 3.712 1.157-1.157a2.625 2.625 0 0 0 0-3.712ZM19.513 8.199l-3.712-3.712-12.15 12.15a5.25 5.25 0 0 0-1.32 2.214l-.8 2.685a.75.75 0 0 0 .933.933l2.685-.8a5.25 5.25 0 0 0 2.214-1.32L19.513 8.2Z"
      }
    ]
  }
};
const textToTag = /* @__PURE__ */ new Map([
  ["OC", { content: "OC", color: "#03A8F240", type: "custom" }],
  [
    "NSFL",
    { content: "NSFL", color: "#ff000040", type: "custom" }
  ],
  ["CW", { content: "CW", color: "#ff000040", type: "custom" }]
]);
const parseTags = (title) => {
  if (!title) return { tags: [] };
  let extracted = [];
  const newTitle = title.toString().replace(/^(\[.[^\]]+\])|(\[.[^\]]+\])$/g, (match) => {
    const contents = match.split(",").map((part) => part.trim());
    contents.map((i) => i.replaceAll(/(\[|\])/g, "")).forEach((content) => {
      extracted.push(textToTag.get(content) ?? { content, type: "custom" });
    });
    return "";
  });
  return { tags: extracted, title: newTitle };
};
function PostMeta($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      community = void 0,
      showCommunity = true,
      subscribed = void 0,
      user,
      published,
      title,
      id,
      read = false,
      edited,
      view = "cozy",
      badges = {
        nsfw: false,
        saved: false,
        featured: false,
        deleted: false,
        removed: false,
        locked: false,
        moderator: false,
        admin: false
      },
      tags = [],
      postUrl,
      style = "",
      titleClass = "",
      extraBadges
    } = $$props;
    const badgeToData = new SvelteMap([
      [
        "nsfw",
        {
          icon: ExclamationTriangle,
          color: "red-subtle",
          label: store_get($$store_subs ??= {}, "$t", t)("post.badges.nsfw")
        }
      ],
      [
        "saved",
        {
          icon: Bookmark,
          color: "yellow-subtle",
          label: store_get($$store_subs ??= {}, "$t", t)("post.badges.saved")
        }
      ],
      [
        "featured",
        {
          icon: Megaphone,
          color: "green-subtle",
          label: store_get($$store_subs ??= {}, "$t", t)("post.badges.featured")
        }
      ],
      [
        "removed",
        {
          icon: Trash,
          color: "green-subtle",
          label: store_get($$store_subs ??= {}, "$t", t)("post.badges.removed")
        }
      ],
      [
        "deleted",
        {
          icon: Trash,
          color: "red-subtle",
          label: store_get($$store_subs ??= {}, "$t", t)("post.badges.deleted")
        }
      ],
      [
        "locked",
        {
          icon: LockClosed,
          color: "yellow-subtle",
          label: store_get($$store_subs ??= {}, "$t", t)("post.badges.locked")
        }
      ]
    ]);
    $$renderer2.push(`<header${attr_class(
      clsx([
        "grid w-full meta",
        community ? "grid-rows-2" : "grid-rows-1 minimal",
        "text-xs min-w-0 max-w-full text-slate-600 dark:text-zinc-400"
      ]),
      "svelte-1rfhh88",
      { "compact": view == "compact" }
    )}${attr_style(style)}>`);
    if (showCommunity && community) {
      $$renderer2.push("<!--[-->");
      {
        let target = function($$renderer3, attachment) {
          $$renderer3.push(`<button${attr_class(clsx([
            "row-span-2 shrink-0 mr-2 self-center group/btn",
            "bg-slate-200 dark:bg-zinc-800 rounded-lg cursor-pointer"
          ]))}>`);
          if (community.nsfw && settings.nsfwBlur) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<div${attr_style(`width: ${stringify(view == "compact" ? 24 : 32)}; height: ${stringify(view == "compact" ? 24 : 32)}`)} class="bg-red-400 rounded-xl"></div>`);
          } else {
            $$renderer3.push("<!--[!-->");
            Avatar($$renderer3, {
              url: community?.icon,
              width: view == "compact" ? 24 : 32,
              alt: community?.name,
              circle: false,
              class: "group-hover/btn:scale-90 group-active/btn:scale-[.85] transition-transform"
            });
          }
          $$renderer3.push(`<!--]--></button>`);
        }, popover = function($$renderer3, open) {
          if (open && community && subscribed) {
            $$renderer3.push("<!--[-->");
            Material($$renderer3, {
              color: "uniform",
              rounding: "2xl",
              elevation: "high",
              class: "max-w-2xl w-screen max-h-128 overflow-auto",
              "data-autoclose": "false",
              children: ($$renderer4) => {
                await_block($$renderer4, import("./CommunityHeader.js"), () => {
                }, ({ default: CommunityHeader }) => {
                  $$renderer4.push(`<!---->`);
                  CommunityHeader($$renderer4, { community, subscribed });
                  $$renderer4.push(`<!---->`);
                });
                $$renderer4.push(`<!--]-->`);
              },
              $$slots: { default: true }
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        };
        Popover($$renderer2, { target, popover, $$slots: { target: true, popover: true } });
      }
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (showCommunity && community) {
      $$renderer2.push("<!--[-->");
      CommunityLink($$renderer2, {
        community,
        style: "grid-area: community;",
        class: "shrink no-list-margin",
        badges: { nsfw: community.nsfw }
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div${attr_class(`flex flex-row gap-1.5 items-center no-list-margin ${stringify(view == "compact" && showCommunity ? "min-sm:mx-2" : "")}`)} style="grid-area: stats;">`);
    if (user) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<address class="contents not-italic">`);
      if (view == "compact" && showCommunity) {
        $$renderer2.push("<!--[-->");
        Icon($$renderer2, {
          src: PaperAirplane,
          size: "12",
          micro: true,
          class: "rotate-180 text-slate-400 dark:text-zinc-600 max-sm:hidden"
        });
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      {
        let extraBadges2 = function($$renderer3) {
          if (badges.moderator) {
            $$renderer3.push("<!--[-->");
            Icon($$renderer3, {
              src: ShieldCheck,
              size: "14",
              mini: true,
              class: "text-green-500"
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--> `);
          if (badges.admin) {
            $$renderer3.push("<!--[-->");
            Icon($$renderer3, {
              src: ShieldCheck,
              size: "14",
              mini: true,
              class: "text-red-500"
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        };
        UserLink($$renderer2, {
          avatarSize: 20,
          user,
          avatar: !showCommunity,
          class: "shrink",
          extraBadges: extraBadges2
        });
      }
      $$renderer2.push(`<!----></address>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (published) {
      $$renderer2.push("<!--[-->");
      RelativeDate($$renderer2, { date: published, class: "shrink-0" });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (edited) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<button${attr("title", store_get($$store_subs ??= {}, "$t", t)("post.meta.lastEdited", {
        default: formatRelativeDate(publishedToDate(edited), { style: "long" })
      }))}>`);
      Icon($$renderer2, { src: Pencil, micro: true, size: "14" });
      $$renderer2.push(`<!----></button>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div> <div class="flex flex-row min-sm:justify-end items-center self-center flex-wrap gap-2 *:shrink-0 badges min-sm:ml-2" style="grid-area: badges;">`);
    if (tags) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<!--[-->`);
      const each_array = ensure_array_like(tags);
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let tag = each_array[$$index];
        const href = tag.type == "flair" ? null : `/search?community=${community?.id}&q=[${tag.content}]&type=Posts`;
        element(
          $$renderer2,
          href ? "a" : "div",
          () => {
            $$renderer2.push(`${attr("href", href)} class="hover:brightness-110"${attr_style(`${stringify(tag.color ? `--tag-color: ${tag.color};` : "")} ${stringify(tag.textColor ? `--tag-text-color: ${tag.textColor}` : "")}`)}`);
          },
          () => {
            {
              let icon = function($$renderer3) {
                if (tag.icon) {
                  $$renderer3.push("<!--[-->");
                  Icon($$renderer3, { src: tag.icon, micro: true, size: "14" });
                } else {
                  $$renderer3.push("<!--[!-->");
                  if (tag === void 0) {
                    $$renderer3.push("<!--[-->");
                    Icon($$renderer3, { src: Tag, micro: true, size: "14" });
                  } else {
                    $$renderer3.push("<!--[!-->");
                  }
                  $$renderer3.push(`<!--]-->`);
                }
                $$renderer3.push(`<!--]-->`);
              };
              Badge($$renderer2, {
                class: tag.color ? "badge-tag-color" : "",
                icon,
                children: ($$renderer3) => {
                  $$renderer3.push(`<!---->${escape_html(tag.content)}`);
                },
                $$slots: { icon: true, default: true }
              });
            }
          }
        );
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <!--[-->`);
    const each_array_1 = ensure_array_like(Object.keys(badges).filter((i) => badges[i] == true).map((i) => badgeToData.get(i)).filter((i) => i != void 0));
    for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
      let badge = each_array_1[$$index_1];
      {
        let icon = function($$renderer3) {
          Icon($$renderer3, { src: badge.icon, micro: true, size: "14" });
        };
        Badge($$renderer2, {
          label: badge.label,
          color: badge.color,
          allowIconOnly: true,
          icon,
          children: ($$renderer3) => {
            $$renderer3.push(`<!---->${escape_html(badge.label)}`);
          },
          $$slots: { icon: true, default: true }
        });
      }
    }
    $$renderer2.push(`<!--]--> `);
    extraBadges?.($$renderer2);
    $$renderer2.push(`<!----></div></header> `);
    if (title && id) {
      $$renderer2.push("<!--[-->");
      const useAttachedUrl = settings.posts.titleOpensUrl && postUrl;
      $$renderer2.push(`<h3${attr_class(
        clsx([
          "font-medium max-sm:mt-0! font-display",
          titleClass,
          settings.markReadPosts && read && "text-slate-600 dark:text-zinc-400",
          view == "compact" ? "text-base" : "text-lg"
        ]),
        "svelte-1rfhh88"
      )} style="grid-area: title;"><a${attr("href", useAttachedUrl ? postUrl : `/post/${encodeURIComponent(profile.current.instance)}/${id}`)}${attr("target", useAttachedUrl ? "_blank" : void 0)}${attr("rel", useAttachedUrl ? "noopener noreferrer" : void 0)} class="inline-block hover:underline hover:text-primary-900 dark:hover:text-primary-100 transition-colors">`);
      Markdown($$renderer2, {
        inline: true,
        source: title,
        class: view != "compact" ? "" : "leading-[1.3]"
      });
      $$renderer2.push(`<!----></a></h3>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<div style="grid-area: title; margin: 0;"></div>`);
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { community, subscribed });
  });
}
const isSubmissionView = (item) => !("type" in item);
const isSubmission = (item) => !("type" in item);
const contentView = (item) => {
  if (isCommentView(item))
    return {
      type: "comment",
      body: item.comment.content,
      creator: item.creator,
      id: item.comment.id
    };
  else
    return {
      type: "post",
      body: item.post.body ?? item.post.name,
      title: item.post.name,
      creator: item.creator,
      id: item.post.id
    };
};
const contentItem = (item) => {
  if (isComment(item))
    return {
      type: "comment",
      body: item.content,
      id: item.id
    };
  else
    return {
      type: "post",
      body: item.body ?? item.name,
      title: item.name,
      id: item.id
    };
};
async function save(item, save2) {
  if (isSubmissionView(item)) item = contentView(item);
  if (item.type == "post") {
    return (await getClient().savePost({
      post_id: item.id,
      save: save2
    })).post_view.saved;
  } else if (item.type == "comment") {
    return (await getClient().saveComment({
      comment_id: item.id,
      save: save2
    })).comment_view.saved;
  }
  return save2;
}
async function deleteItem(item, deleted) {
  if (isSubmissionView(item)) item = contentView(item);
  if (item.type == "post") {
    return (await getClient().deletePost({
      post_id: item.id,
      deleted
    })).post_view.post.deleted;
  } else if (item.type == "comment") {
    return (await getClient().deleteComment({
      comment_id: item.id,
      deleted
    })).comment_view.comment.deleted;
  }
  return deleted;
}
async function markAsRead(item, read) {
  if (isSubmission(item)) item = contentItem(item);
  if (item.type == "post") {
    getClient().markPostAsRead({
      post_ids: [item.id],
      read
    });
    return read;
  }
  return false;
}
const voteColor = (vote) => vote == 1 ? `btn-primary border-0!` : vote == -1 ? `bg-red-500 text-slate-50 dark:bg-red-400 dark:text-zinc-900` : "";
const shouldShowVoteColor = (vote, type) => vote == -1 && type == "downvotes" || vote == 1 && type == "upvotes" ? voteColor(vote) : "";
function PostVote($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      post = void 0,
      vote = void 0,
      score = void 0,
      upvotes = void 0,
      downvotes = void 0,
      showCounts = true,
      children
    } = $$props;
    function voteButton($$renderer3, votes, target, vote2) {
      const targetNum = target == "upvote" ? 1 : -1;
      $$renderer3.push(`<button${attr_class(
        clsx([
          "flex items-center gap-0.5 transition-colors relative cursor-pointer h-full p-2",
          "first:rounded-l-[inherit] last:rounded-r-[inherit]",
          "last:flex-row-reverse",
          vote2 == targetNum ? shouldShowVoteColor(vote2, target == "upvote" ? "upvotes" : "downvotes") : "btn-tertiary"
        ]),
        "svelte-9vi3oj"
      )}${attr("aria-pressed", vote2 == targetNum)}${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)(target == "upvote" ? "post.actions.vote.upvote" : "post.actions.vote.downvote"))}>`);
      Icon($$renderer3, {
        src: target == "upvote" ? ChevronUp : ChevronDown,
        size: "20",
        micro: true
      });
      $$renderer3.push(`<!----> `);
      if (showCounts) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="grid text-sm z-20"><!---->`);
        {
          $$renderer3.push(`<span style="grid-column: 1; grid-row: 1;"${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)(target == "upvote" ? "aria.vote.upvotes" : "aria.vote.downvotes", { default: votes }))}>`);
          FormattedNumber($$renderer3, { number: votes ?? 0 });
          $$renderer3.push(`<!----></span>`);
        }
        $$renderer3.push(`<!----></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></button>`);
    }
    if (children) {
      $$renderer2.push("<!--[-->");
      children($$renderer2, { vote, score });
      $$renderer2.push(`<!---->`);
    } else {
      $$renderer2.push("<!--[!-->");
      const voteRatio = Math.floor((upvotes ?? 0) / ((upvotes ?? 0) + (downvotes ?? 0)) * 100);
      $$renderer2.push(`<div${attr_class(
        clsx([
          buttonColor.secondary,
          "rounded-xl h-full font-medium flex relative hover:bg-transparent! shadow-xs",
          voteRatio < 85 && settings.voteRatioBar && "vote-ratio"
        ]),
        "svelte-9vi3oj"
      )}${attr("aria-label", store_get($$store_subs ??= {}, "$t", t)("aria.vote.group"))}${attr_style(`--vote-ratio: ${stringify(voteRatio)}%;`)}>`);
      voteButton($$renderer2, upvotes, "upvote", vote);
      $$renderer2.push(`<!----> <div class="h-full p-0! border-l border-slate-200 dark:border-zinc-800"></div> `);
      if (site.data?.site_view.local_site.enable_downvotes ?? true) {
        $$renderer2.push("<!--[-->");
        voteButton($$renderer2, downvotes, "downvote", vote);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div>`);
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { post, vote, score, upvotes, downvotes });
  });
}
export {
  BookmarkSlash as B,
  PostMeta as P,
  save as a,
  Pencil as b,
  PostVote as c,
  deleteItem as d,
  markAsRead as m,
  parseTags as p,
  shouldShowVoteColor as s
};
//# sourceMappingURL=PostVote.js.map
