import { j as attr_style } from "./index3.js";
import { U as UserLink, p as profile, i as Markdown } from "./client.svelte.js";
function PrivateMessage($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { message, meta = true, style = "" } = $$props;
    $$renderer2.push(`<div class="flex flex-col gap-2 text-sm"${attr_style(style)}>`);
    if (meta) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="flex flex-row gap-2 items-center flex-wrap"><span class="font-medium text-xs">From</span> `);
      UserLink($$renderer2, {
        showInstance: false,
        user: message.creator,
        avatar: true,
        avatarSize: 20
      });
      $$renderer2.push(`<!----> `);
      if (profile.current?.user?.local_user_view.person.id != message.recipient.id) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`to `);
        UserLink($$renderer2, {
          showInstance: false,
          user: message.recipient,
          avatar: true,
          avatarSize: 20
        });
        $$renderer2.push(`<!---->`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    Markdown($$renderer2, {
      rendererOptions: { autoloadImages: false },
      source: message.private_message.content
    });
    $$renderer2.push(`<!----></div>`);
  });
}
export {
  PrivateMessage as P
};
//# sourceMappingURL=PrivateMessage.js.map
