import { e as escape_html, s as store_get, u as unsubscribe_stores } from "./index3.js";
import { p as public_env } from "./shared-server.js";
import { p as profile, b as Badge, B as Button, s as site, y as Spinner } from "./client.svelte.js";
import { t } from "./index.js";
import { s as settings } from "./settings.svelte.js";
import { t as theme } from "./theme.svelte.js";
import { I as InstanceCard } from "./InstanceCard.js";
import { I as Icon } from "./Icon.js";
import { A as ArrowLeftOnRectangle } from "./ArrowLeftOnRectangle.js";
import { B as Bookmark } from "./Bookmark.js";
import { B as BugAnt } from "./BugAnt.js";
import { C as Cog6Tooth } from "./Cog6Tooth.js";
import { C as ComputerDesktop } from "./ComputerDesktop.js";
import { I as Identification } from "./Identification.js";
import { I as Inbox } from "./Inbox.js";
import { U as UserGroup, S as Swatch, c as chords, M as Moon } from "./_layout.js";
import { S as ServerStack } from "./ServerStack.js";
import { S as ShieldCheck } from "./ShieldCheck.js";
import { S as Sun } from "./Sun.js";
import { U as UserCircle } from "./UserCircle.js";
import { S as Select, O as Option } from "./Select.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { m as modal } from "./modal2.js";
import { a as MenuButton } from "./MenuButton.js";
import { M as MenuDivider } from "./MenuDivider.js";
const CodeBracketSquare = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 4a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V4Zm4.78 1.97a.75.75 0 0 1 0 1.06L5.81 8l.97.97a.75.75 0 1 1-1.06 1.06l-1.5-1.5a.75.75 0 0 1 0-1.06l1.5-1.5a.75.75 0 0 1 1.06 0Zm2.44 1.06a.75.75 0 0 1 1.06-1.06l1.5 1.5a.75.75 0 0 1 0 1.06l-1.5 1.5a.75.75 0 1 1-1.06-1.06l.97-.97-.97-.97Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M4.25 2A2.25 2.25 0 0 0 2 4.25v11.5A2.25 2.25 0 0 0 4.25 18h11.5A2.25 2.25 0 0 0 18 15.75V4.25A2.25 2.25 0 0 0 15.75 2H4.25Zm4.03 6.28a.75.75 0 0 0-1.06-1.06L4.97 9.47a.75.75 0 0 0 0 1.06l2.25 2.25a.75.75 0 0 0 1.06-1.06L6.56 10l1.72-1.72Zm4.5-1.06a.75.75 0 1 0-1.06 1.06L13.44 10l-1.72 1.72a.75.75 0 1 0 1.06 1.06l2.25-2.25a.75.75 0 0 0 0-1.06l-2.25-2.25Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M14.25 9.75 16.5 12l-2.25 2.25m-4.5 0L7.5 12l2.25-2.25M6 20.25h12A2.25 2.25 0 0 0 20.25 18V6A2.25 2.25 0 0 0 18 3.75H6A2.25 2.25 0 0 0 3.75 6v12A2.25 2.25 0 0 0 6 20.25Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3 6a3 3 0 0 1 3-3h12a3 3 0 0 1 3 3v12a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm14.25 6a.75.75 0 0 1-.22.53l-2.25 2.25a.75.75 0 1 1-1.06-1.06L15.44 12l-1.72-1.72a.75.75 0 1 1 1.06-1.06l2.25 2.25c.141.14.22.331.22.53Zm-10.28-.53a.75.75 0 0 0 0 1.06l2.25 2.25a.75.75 0 1 0 1.06-1.06L8.56 12l1.72-1.72a.75.75 0 1 0-1.06-1.06l-2.25 2.25Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
const CommandLine = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2 4a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V4Zm2.22 1.97a.75.75 0 0 0 0 1.06l.97.97-.97.97a.75.75 0 1 0 1.06 1.06l1.5-1.5a.75.75 0 0 0 0-1.06l-1.5-1.5a.75.75 0 0 0-1.06 0ZM8.75 8.5a.75.75 0 0 0 0 1.5h2.5a.75.75 0 0 0 0-1.5h-2.5Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M3.25 3A2.25 2.25 0 0 0 1 5.25v9.5A2.25 2.25 0 0 0 3.25 17h13.5A2.25 2.25 0 0 0 19 14.75v-9.5A2.25 2.25 0 0 0 16.75 3H3.25Zm.943 8.752a.75.75 0 0 1 .055-1.06L6.128 9l-1.88-1.693a.75.75 0 1 1 1.004-1.114l2.5 2.25a.75.75 0 0 1 0 1.114l-2.5 2.25a.75.75 0 0 1-1.06-.055ZM9.75 10.25a.75.75 0 0 0 0 1.5h2.5a.75.75 0 0 0 0-1.5h-2.5Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "m6.75 7.5 3 2.25-3 2.25m4.5 0h3m-9 8.25h13.5A2.25 2.25 0 0 0 21 18V6a2.25 2.25 0 0 0-2.25-2.25H5.25A2.25 2.25 0 0 0 3 6v12a2.25 2.25 0 0 0 2.25 2.25Z"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M2.25 6a3 3 0 0 1 3-3h13.5a3 3 0 0 1 3 3v12a3 3 0 0 1-3 3H5.25a3 3 0 0 1-3-3V6Zm3.97.97a.75.75 0 0 1 1.06 0l2.25 2.25a.75.75 0 0 1 0 1.06l-2.25 2.25a.75.75 0 0 1-1.06-1.06l1.72-1.72-1.72-1.72a.75.75 0 0 1 0-1.06Zm4.28 4.28a.75.75 0 0 0 0 1.5h3a.75.75 0 0 0 0-1.5h-3Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function siteSnippet($$renderer) {
  if (site.data) {
    $$renderer.push("<!--[-->");
    InstanceCard($$renderer, {
      site: site.data.site_view,
      admins: site.data.admins,
      taglines: site.data.taglines,
      version: site.data.version
    });
  } else {
    $$renderer.push("<!--[!-->");
    Spinner($$renderer, {});
  }
  $$renderer.push(`<!--]-->`);
}
function notifBadge($$renderer, number) {
  if (number > 0) {
    $$renderer.push("<!--[-->");
    Badge($$renderer, {
      color: "red-subtle",
      class: "min-w-5 h-5 p-0! px-0.5 grid place-items-center ml-auto",
      children: ($$renderer2) => {
        $$renderer2.push(`<!---->${escape_html(number > 99 ? "∞" : number)}`);
      },
      $$slots: { default: true }
    });
  } else {
    $$renderer.push("<!--[!-->");
  }
  $$renderer.push(`<!--]-->`);
}
function key($$renderer, label) {
  $$renderer.push(`<span class="text-[12px] rounded-md border border-slate-300 dark:border-zinc-700 border-b-2 px-2 py-0.5">${escape_html(label)}</span>`);
}
function Profile($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      if (profile.current?.jwt) {
        $$renderer3.push("<!--[-->");
        const notifications = profile.inbox.notifications;
        MenuButton($$renderer3, {
          href: "/inbox",
          icon: Inbox,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("profile.inbox"))} `);
            if (notifications.inbox > 0) {
              $$renderer4.push("<!--[-->");
              Badge($$renderer4, {
                color: "red-subtle",
                class: "text-xs ml-auto font-bold py-0.5!",
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(notifications.inbox > 99 ? "∞" : notifications.inbox)}`);
                },
                $$slots: { default: true }
              });
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        if (profile.isMod()) {
          $$renderer3.push("<!--[-->");
          {
            let suffix = function($$renderer4) {
              notifBadge($$renderer4, notifications.reports);
            };
            MenuButton($$renderer3, {
              href: "/moderation",
              icon: ShieldCheck,
              suffix,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.moderation.feed"))}`);
              },
              $$slots: { suffix: true, default: true }
            });
          }
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (profile.isAdmin) {
          $$renderer3.push("<!--[-->");
          {
            let suffix = function($$renderer4) {
              notifBadge($$renderer4, notifications.applications);
            };
            MenuButton($$renderer3, {
              href: "/admin/applications",
              icon: ServerStack,
              suffix,
              children: ($$renderer4) => {
                $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("routes.admin.applications.title"))}`);
              },
              $$slots: { suffix: true, default: true }
            });
          }
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        MenuDivider($$renderer3, {
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("profile.profile"))}`);
          }
        });
        $$renderer3.push(`<!----> `);
        MenuButton($$renderer3, {
          href: "/profile",
          icon: UserCircle,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("profile.profile"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        MenuButton($$renderer3, {
          href: "/saved",
          icon: Bookmark,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("profile.saved"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      } else {
        $$renderer3.push("<!--[!-->");
        MenuButton($$renderer3, {
          href: "/accounts/login",
          icon: ArrowLeftOnRectangle,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.login"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!----> `);
        MenuButton($$renderer3, {
          href: "/signup",
          icon: Identification,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.signup"))}`);
          },
          $$slots: { default: true }
        });
        $$renderer3.push(`<!---->`);
      }
      $$renderer3.push(`<!--]--> `);
      MenuButton($$renderer3, {
        href: "/accounts",
        icon: UserGroup,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("account.accounts"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      MenuDivider($$renderer3, {
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.app"))}`);
        }
      });
      $$renderer3.push(`<!----> `);
      MenuButton($$renderer3, {
        href: "/settings",
        icon: Cog6Tooth,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.settings"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      {
        let target = function($$renderer4, attachment) {
          MenuButton($$renderer4, {
            icon: theme.colorScheme == "system" ? ComputerDesktop : theme.colorScheme == "light" ? Sun : Moon,
            class: " w-full",
            nest: true,
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.label"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Option($$renderer4, {
            value: "system",
            class: "hidden",
            icon: ComputerDesktop,
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.system"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Option($$renderer4, {
            value: "light",
            class: "hidden",
            icon: Sun,
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.light"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Option($$renderer4, {
            value: "dark",
            class: "hidden",
            icon: Moon,
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.colorscheme.dark"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!---->`);
        };
        Select($$renderer3, {
          size: "sm",
          placement: "bottom",
          get value() {
            return theme.colorScheme;
          },
          set value($$value) {
            theme.colorScheme = $$value;
            $$settled = false;
          },
          target,
          $$slots: { target: true }
        });
      }
      $$renderer3.push(`<!----> `);
      MenuButton($$renderer3, {
        href: "/theme",
        icon: Swatch,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.menu.theme"))}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      MenuButton($$renderer3, {
        onclick: () => chords.commands = !chords.commands,
        icon: CommandLine,
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("nav.commands.prompt"))} <div class="text-slate-600 dark:text-zinc-400 text-xs ml-auto max-sm:hidden">`);
          key($$renderer4, "Ctrl");
          $$renderer4.push(`<!----> `);
          key($$renderer4, "K");
          $$renderer4.push(`<!----></div>`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if (settings.debugInfo) {
        $$renderer3.push("<!--[-->");
        MenuButton($$renderer3, {
          href: "/util",
          icon: BugAnt,
          children: ($$renderer4) => {
            $$renderer4.push(`<!---->Debug`);
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <li class="flex flex-col px-2 py-1 mx-auto my-1 text-xs w-full"><div class="flex flex-row gap-2 w-full items-center"><div class="flex-1"><button class="hover:brightness-110 transition-all">`);
      Badge($$renderer3, {
        color: "blue-subtle",
        children: ($$renderer4) => {
          $$renderer4.push(`<!---->${escape_html("2.2.2")}`);
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----></button></div> `);
      Button($$renderer3, {
        onclick: () => {
          modal({
            title: store_get($$store_subs ??= {}, "$t", t)("nav.menu.instance"),
            snippet: siteSnippet,
            body: ""
          });
        },
        color: "tertiary",
        title: store_get($$store_subs ??= {}, "$t", t)("nav.menu.instance"),
        size: "square-md",
        children: ($$renderer4) => {
          Icon($$renderer4, { src: ServerStack, size: "16", micro: true });
        },
        $$slots: { default: true }
      });
      $$renderer3.push(`<!----> `);
      if (public_env.PUBLIC_XYLIGHT_MODE?.toLowerCase() == "true") {
        $$renderer3.push("<!--[-->");
        Button($$renderer3, {
          color: "tertiary",
          href: "https://github.com/Xyphyn/Photon",
          title: store_get($$store_subs ??= {}, "$t", t)("nav.menu.source"),
          size: "square-md",
          children: ($$renderer4) => {
            Icon($$renderer4, { src: CodeBracketSquare, size: "16", micro: true });
          },
          $$slots: { default: true }
        });
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div></li>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  Profile as default
};
//# sourceMappingURL=Profile.js.map
