import { j as attr_style, a as attr_class, c as clsx, k as stringify } from "./index3.js";
import { h as Avatar } from "./client.svelte.js";
function ProfileAvatar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { profile = void 0, selected = false, size = 22 } = $$props;
    if (profile) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div${attr_style(`width: ${stringify(size)}px; height: ${stringify(size)}px;`)}${attr_class(clsx([
        profile.avatar && "bg-slate-200 rounded-full dark:bg-zinc-700"
      ]))}>`);
      Avatar($$renderer2, {
        url: profile.avatar,
        alt: profile.username,
        width: size,
        class: [
          "shrink-0 rounded-full",
          selected && "scale-75",
          "transition-transform"
        ]
      });
      $$renderer2.push(`<!----></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
  });
}
export {
  ProfileAvatar as P
};
//# sourceMappingURL=ProfileAvatar.js.map
