import { a as attr_class, e as escape_html, k as stringify } from "./index3.js";
import { p as profile, L as LINKED_INSTANCE_URL, g as goto } from "./client.svelte.js";
import { p as page } from "./index4.js";
import { S as SidebarButton } from "./SidebarButton.js";
import { I as Icon } from "./Icon.js";
import { Q as QuestionMarkCircle } from "./QuestionMarkCircle.js";
import { P as ProfileAvatar } from "./ProfileAvatar.js";
function ProfileButton($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let switching = false;
    let { prof, index, guest = false } = $$props;
    {
      let customIcon = function($$renderer3) {
        ProfileAvatar($$renderer3, {
          profile: prof,
          selected: profile.current?.id == prof.id
        });
      };
      SidebarButton($$renderer2, {
        alignment: "left",
        loading: switching,
        rounding: "lg",
        loaderWidth: 22,
        selected: profile.current?.id == prof.id,
        onclick: async () => {
          switching = true;
          if (profile.current?.id != prof.id) {
            profile.meta.profile = prof.id;
          }
          await goto(page.url, {});
          switching = false;
        },
        class: "w-full font-normal",
        customIcon,
        children: ($$renderer3) => {
          $$renderer3.push(`<span${attr_class(`inline-flex flex-col gap-0 ${stringify(profile.current?.id == prof.id ? "font-semibold" : "")}`)}>${escape_html(prof.username ?? prof.user?.local_user_view.person.name)} `);
          if (!guest && !LINKED_INSTANCE_URL) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<span class="text-slate-500 dark:text-zinc-400 font-normal text-xs">${escape_html(prof.instance)}</span>`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]--></span> `);
          if (!prof.jwt) {
            $$renderer3.push("<!--[-->");
            Icon($$renderer3, {
              src: QuestionMarkCircle,
              size: "14",
              micro: true,
              class: "ml-auto opacity-50"
            });
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        },
        $$slots: { customIcon: true, default: true }
      });
    }
  });
}
export {
  ProfileButton as P
};
//# sourceMappingURL=ProfileButton.js.map
