import { b as attr, a as attr_class, j as attr_style, e as escape_html, c as clsx, s as store_get, u as unsubscribe_stores } from "./index3.js";
import { c as locale } from "./index.js";
import { s as settings } from "./settings.svelte.js";
function formatRelativeDate(date, options, locale2, relativeTo) {
  try {
    const now = relativeTo?.getTime() ?? Date.now();
    const diffInMillis = now - date.getTime();
    const thresholds = [
      { unit: "second", threshold: 1e3 },
      { unit: "minute", threshold: 60 * 1e3 },
      { unit: "hour", threshold: 60 * 60 * 1e3 },
      { unit: "day", threshold: 24 * 60 * 60 * 1e3 },
      { unit: "week", threshold: 7 * 24 * 60 * 60 * 1e3 },
      { unit: "month", threshold: 30 * 24 * 60 * 60 * 1e3 },
      { unit: "year", threshold: 365 * 24 * 60 * 60 * 1e3 }
    ];
    for (let i = thresholds.length - 1; i >= 0; i--) {
      if (diffInMillis >= thresholds[i].threshold) {
        const value = Math.round(diffInMillis / thresholds[i].threshold);
        let language = locale2 ?? "en";
        if (settings.absoluteDates) {
          const rtf = new Intl.DateTimeFormat(language, { ...options, timeStyle: "short", dateStyle: "short" });
          return rtf.format(date);
        } else {
          const rtf = new Intl.RelativeTimeFormat(language, options);
          return rtf.format(-value, thresholds[i].unit);
        }
      }
    }
    return "Now";
  } catch {
    return "Invalid Date";
  }
}
function RelativeDate($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    const toLocaleDateString = (date2) => {
      try {
        return date2.toLocaleString();
      } catch {
        return "Invalid Date";
      }
    };
    let {
      date,
      relativeTo = void 0,
      options = { numeric: "always", style: "narrow" },
      style = "",
      class: clazz = ""
    } = $$props;
    let dateTime = toLocaleDateString(date);
    $$renderer2.push(`<time${attr("datetime", dateTime)}${attr("title", dateTime)}${attr_class(clsx(clazz))}${attr_style(style)}>${escape_html(formatRelativeDate(date, options, store_get($$store_subs ??= {}, "$locale", locale), relativeTo))}</time>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  RelativeDate as R,
  formatRelativeDate as f
};
//# sourceMappingURL=RelativeDate.js.map
