import { u as unsubscribe_stores, f as bind_props, s as store_get, e as escape_html, d as ensure_array_like } from "./index3.js";
import { w as isCommentView, Q as isPostView, B as Button } from "./client.svelte.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { t } from "./index.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { F as Fire } from "./Fire.js";
import { T as Trash } from "./Trash.js";
import { S as Select, O as Option } from "./Select.js";
import { S as Switch } from "./Switch.js";
import { M as Modal } from "./Modal.js";
import { M as MarkdownEditor } from "./MarkdownEditor.js";
import { s as settings } from "./settings.svelte.js";
import { S as Switch$1 } from "./Switch2.js";
import { r as run } from "./legacy-server.js";
import { C as Comment } from "./Comment.js";
import { P as Post } from "./PostActions.js";
import "@dicebear/core";
import "@dicebear/initials";
function RemoveModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { open = void 0, item = void 0, purge = false } = $$props;
    let reason = "";
    let commentReason = settings.moderation.defaultRemoveAction != null;
    let privateMessage = settings.moderation.defaultRemoveAction == "message";
    let loading = false;
    let preset = settings.moderation.presets[0]?.content ?? "";
    let removed = item ? isCommentView(item) ? item.comment.removed : item.post.removed : false;
    let replyReason = "";
    const resetText = () => {
      reason = "";
    };
    run(() => {
      if (item) {
        resetText();
      }
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        title: purge ? store_get($$store_subs ??= {}, "$t", t)("moderation.removeSubmission.titlePurge") : removed ? store_get($$store_subs ??= {}, "$t", t)("moderation.removeSubmission.titleRestore") : store_get($$store_subs ??= {}, "$t", t)("moderation.removeSubmission.title"),
        get open() {
          return open;
        },
        set open($$value) {
          open = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          if (item) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<form class="flex flex-col gap-4 list-none">`);
            if (isCommentView(item)) {
              $$renderer4.push("<!--[-->");
              Comment($$renderer4, {
                node: { children: [], comment_view: item, depth: 1 },
                postId: item.post.id,
                actions: false
              });
            } else {
              $$renderer4.push("<!--[!-->");
              if (isPostView(item)) {
                $$renderer4.push("<!--[-->");
                Post($$renderer4, { actions: false, post: item });
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]--> `);
            MarkdownEditor($$renderer4, {
              rows: 3,
              label: "Reason",
              placeholder: "Optional",
              get value() {
                return reason;
              },
              set value($$value) {
                reason = $$value;
                $$settled = false;
              }
            });
            $$renderer4.push(`<!----> `);
            if (!removed) {
              $$renderer4.push("<!--[-->");
              Switch($$renderer4, {
                get checked() {
                  return commentReason;
                },
                set checked($$value) {
                  commentReason = $$value;
                  $$settled = false;
                },
                children: ($$renderer5) => {
                  $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.removeSubmission.withReason"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer4.push(`<!----> `);
              if (commentReason) {
                $$renderer4.push("<!--[-->");
                Switch$1($$renderer4, {
                  options: [false, true],
                  optionNames: [
                    store_get($$store_subs ??= {}, "$t", t)("moderation.removeSubmission.comment"),
                    store_get($$store_subs ??= {}, "$t", t)("moderation.removeSubmission.message")
                  ],
                  get selected() {
                    return privateMessage;
                  },
                  set selected($$value) {
                    privateMessage = $$value;
                    $$settled = false;
                  }
                });
                $$renderer4.push(`<!----> `);
                {
                  let customLabel = function($$renderer5) {
                    $$renderer5.push(`<div class="flex justify-between items-end mb-1">${escape_html(store_get($$store_subs ??= {}, "$t", t)("comment.reply"))} `);
                    Select($$renderer5, {
                      placeholder: "No preset",
                      get value() {
                        return preset;
                      },
                      set value($$value) {
                        preset = $$value;
                        $$settled = false;
                      },
                      children: ($$renderer6) => {
                        $$renderer6.push(`<!--[-->`);
                        const each_array = ensure_array_like(settings.moderation.presets);
                        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                          let preset2 = each_array[$$index];
                          Option($$renderer6, {
                            value: preset2.content,
                            children: ($$renderer7) => {
                              $$renderer7.push(`<!---->${escape_html(preset2.title)}`);
                            },
                            $$slots: { default: true }
                          });
                        }
                        $$renderer6.push(`<!--]-->`);
                      },
                      $$slots: { default: true }
                    });
                    $$renderer5.push(`<!----></div>`);
                  };
                  MarkdownEditor($$renderer4, {
                    placeholder: replyReason,
                    rows: 3,
                    get value() {
                      return replyReason;
                    },
                    set value($$value) {
                      replyReason = $$value;
                      $$settled = false;
                    },
                    customLabel,
                    $$slots: { customLabel: true }
                  });
                }
                $$renderer4.push(`<!---->`);
              } else {
                $$renderer4.push("<!--[!-->");
              }
              $$renderer4.push(`<!--]-->`);
            } else {
              $$renderer4.push("<!--[!-->");
            }
            $$renderer4.push(`<!--]--> `);
            Button($$renderer4, {
              color: purge ? "danger" : "primary",
              size: "lg",
              loading,
              disabled: loading,
              submit: true,
              icon: purge ? Fire : Trash,
              children: ($$renderer5) => {
                if (purge) {
                  $$renderer5.push("<!--[-->");
                  $$renderer5.push(`${escape_html(store_get($$store_subs ??= {}, "$t", t)("admin.purge"))}`);
                } else {
                  $$renderer5.push("<!--[!-->");
                  $$renderer5.push(`${escape_html(removed ? store_get($$store_subs ??= {}, "$t", t)("moderation.restore") : store_get($$store_subs ??= {}, "$t", t)("moderation.remove"))}`);
                }
                $$renderer5.push(`<!--]-->`);
              },
              $$slots: { default: true }
            });
            $$renderer4.push(`<!----></form>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]-->`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { open, item });
  });
}
export {
  RemoveModal as default
};
//# sourceMappingURL=RemoveModal.js.map
