import { u as unsubscribe_stores, f as bind_props, s as store_get, e as escape_html } from "./index3.js";
import { B as Button, o as Plus } from "./client.svelte.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { t } from "./index.js";
import "@sveltejs/kit";
import "lemmy-js-client";
import "openapi-fetch";
import { B as ButtonGroup } from "./ButtonGroup.js";
import { M as Modal } from "./Modal.js";
import { M as MarkdownEditor } from "./MarkdownEditor.js";
import { r as run } from "./legacy-server.js";
import { C as CommentItem } from "./CommentItem.js";
import { P as PrivateMessage } from "./PrivateMessage.js";
import { P as PostItem } from "./PostItem.js";
function ReportModal($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { open = void 0, item = void 0 } = $$props;
    const isComment = (item2) => "comment" in item2;
    const isPost = (item2) => !isComment(item2) && "post" in item2;
    let loading = false;
    let reason = "";
    const resetText = () => reason = "";
    run(() => {
      if (item) {
        resetText();
      }
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      Modal($$renderer3, {
        title: store_get($$store_subs ??= {}, "$t", t)("moderation.reportModal.title"),
        get open() {
          return open;
        },
        set open($$value) {
          open = $$value;
          $$settled = false;
        },
        children: ($$renderer4) => {
          $$renderer4.push(`<form class="flex flex-col gap-4">`);
          if (item) {
            $$renderer4.push("<!--[-->");
            $$renderer4.push(`<div class="pointer-events-none list-none">`);
            if (isComment(item)) {
              $$renderer4.push("<!--[-->");
              CommentItem($$renderer4, { actions: false, comment: item });
            } else {
              $$renderer4.push("<!--[!-->");
              if (isPost(item)) {
                $$renderer4.push("<!--[-->");
                PostItem($$renderer4, { post: item });
              } else {
                $$renderer4.push("<!--[!-->");
                PrivateMessage($$renderer4, { message: item });
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]--></div>`);
          } else {
            $$renderer4.push("<!--[!-->");
          }
          $$renderer4.push(`<!--]--> `);
          MarkdownEditor($$renderer4, {
            required: true,
            rows: 4,
            label: store_get($$store_subs ??= {}, "$t", t)("moderation.reason"),
            get value() {
              return reason;
            },
            set value($$value) {
              reason = $$value;
              $$settled = false;
            }
          });
          $$renderer4.push(`<!----> `);
          ButtonGroup($$renderer4, {
            orientation: "horizontal",
            class: "flex flex-wrap",
            children: ($$renderer5) => {
              Button($$renderer5, {
                onclick: () => reason = store_get($$store_subs ??= {}, "$t", t)("moderation.reportModal.presets.spam"),
                disabled: reason == store_get($$store_subs ??= {}, "$t", t)("moderation.reportModal.presets.spam"),
                icon: Plus,
                children: ($$renderer6) => {
                  $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.reportModal.presets.spam"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer5.push(`<!----> `);
              Button($$renderer5, {
                onclick: () => reason = store_get($$store_subs ??= {}, "$t", t)("moderation.reportModal.presets.rules.content"),
                disabled: reason.startsWith(store_get($$store_subs ??= {}, "$t", t)("moderation.reportModal.presets.rules.content").slice(0, -3)),
                icon: Plus,
                children: ($$renderer6) => {
                  $$renderer6.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("moderation.reportModal.presets.rules"))}`);
                },
                $$slots: { default: true }
              });
              $$renderer5.push(`<!---->`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----> `);
          Button($$renderer4, {
            submit: true,
            loading,
            disabled: loading,
            color: "primary",
            size: "lg",
            children: ($$renderer5) => {
              $$renderer5.push(`<!---->${escape_html(store_get($$store_subs ??= {}, "$t", t)("form.submit"))}`);
            },
            $$slots: { default: true }
          });
          $$renderer4.push(`<!----></form>`);
        },
        $$slots: { default: true }
      });
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { open, item });
  });
}
export {
  ReportModal as default
};
//# sourceMappingURL=ReportModal.js.map
