import { f as bind_props, d as ensure_array_like, e as escape_html, l as spread_props } from "./index3.js";
import { I as Icon } from "./Icon.js";
import { M as MagnifyingGlass } from "./MagnifyingGlass.js";
import { y as Spinner } from "./client.svelte.js";
import { T as TextInput } from "./TextInput.js";
import "./index.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
import { M as Menu, a as MenuButton } from "./MenuButton.js";
import { d as debounce } from "./time.js";
function Search($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let items = [];
    let openMenu = false;
    let searching = false;
    let {
      query = "",
      selected = void 0,
      search,
      extractName,
      select = (item) => {
        selected = item;
        query = extractName(item);
        onselect?.(item);
      },
      required,
      input,
      noresults,
      children,
      onselect,
      oninput,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    const debounceFunc = debounce(async () => {
      searching = true;
      openMenu = true;
      items = await search(query);
      searching = false;
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="relative">`);
      {
        let target = function($$renderer4, attachment) {
          if (input) {
            $$renderer4.push("<!--[-->");
            input($$renderer4);
            $$renderer4.push(`<!---->`);
          } else {
            $$renderer4.push("<!--[!-->");
            {
              let prefix = function($$renderer5) {
                $$renderer5.push(`<div class="h-5 flex items-center">`);
                Icon($$renderer5, { src: MagnifyingGlass, mini: true, size: "16" });
                $$renderer5.push(`<!----></div>`);
              };
              TextInput($$renderer4, spread_props([
                {
                  oninput: (e) => {
                    searching = true;
                    openMenu = true;
                    oninput?.(e);
                    debounceFunc();
                  },
                  onfocus: (e) => {
                    searching = true;
                    openMenu = true;
                    oninput?.(e);
                    debounceFunc();
                  },
                  required
                },
                rest,
                {
                  inlineAffixes: true,
                  get value() {
                    return query;
                  },
                  set value($$value) {
                    query = $$value;
                    $$settled = false;
                  },
                  prefix,
                  $$slots: { prefix: true }
                }
              ]));
            }
          }
          $$renderer4.push(`<!--]-->`);
        };
        Menu($$renderer3, {
          get open() {
            return openMenu;
          },
          set open($$value) {
            openMenu = $$value;
            $$settled = false;
          },
          target,
          children: ($$renderer4) => {
            if (searching) {
              $$renderer4.push("<!--[-->");
              $$renderer4.push(`<div class="w-full h-24 grid place-items-center">`);
              Spinner($$renderer4, { width: 24 });
              $$renderer4.push(`<!----></div>`);
            } else {
              $$renderer4.push("<!--[!-->");
              if (items.length == 0) {
                $$renderer4.push("<!--[-->");
                $$renderer4.push(`<div class="text-center h-24 grid place-items-center">`);
                if (noresults) {
                  $$renderer4.push("<!--[-->");
                  noresults($$renderer4);
                  $$renderer4.push(`<!---->`);
                } else {
                  $$renderer4.push("<!--[!-->");
                  $$renderer4.push(`No results found.`);
                }
                $$renderer4.push(`<!--]--></div>`);
              } else {
                $$renderer4.push("<!--[!-->");
                $$renderer4.push(`<!--[-->`);
                const each_array = ensure_array_like(items);
                for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
                  let item = each_array[$$index];
                  if (children) {
                    $$renderer4.push("<!--[-->");
                    children($$renderer4, { extractName, item, select });
                    $$renderer4.push(`<!---->`);
                  } else {
                    $$renderer4.push("<!--[!-->");
                    MenuButton($$renderer4, {
                      onclick: () => select(item),
                      children: ($$renderer5) => {
                        $$renderer5.push(`<!---->${escape_html(extractName(item))}`);
                      },
                      $$slots: { default: true }
                    });
                  }
                  $$renderer4.push(`<!--]-->`);
                }
                $$renderer4.push(`<!--]-->`);
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { target: true, default: true }
        });
      }
      $$renderer3.push(`<!----></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { query, selected });
  });
}
export {
  Search as S
};
//# sourceMappingURL=Search.js.map
