import { f as bind_props, s as store_get, u as unsubscribe_stores } from "./index3.js";
import { n as navigating, p as page } from "./index4.js";
import { t } from "./index.js";
import { B as Button } from "./client.svelte.js";
import { M as MagnifyingGlass } from "./MagnifyingGlass.js";
import { T as TextInput } from "./TextInput.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "clsx";
import "@sveltejs/kit/internal/server";
function SearchBar($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { query = void 0 } = $$props;
    let searchElement = void 0;
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      $$renderer3.push(`<div class="flex gap-2 flex-row items-center w-full text-base h-10">`);
      TextInput($$renderer3, {
        name: "q",
        placeholder: store_get($$store_subs ??= {}, "$t", t)("routes.search.query"),
        size: "lg",
        class: "flex-1 rounded-full! h-full text-base!",
        get value() {
          return query;
        },
        set value($$value) {
          query = $$value;
          $$settled = false;
        },
        get element() {
          return searchElement;
        },
        set element($$value) {
          searchElement = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----> `);
      Button($$renderer3, {
        submit: true,
        color: "primary",
        size: "custom",
        class: "shrink-0 h-full aspect-square shadow-md",
        title: "Search",
        rounding: "pill",
        loading: navigating.to?.route.id == page.url.pathname,
        icon: MagnifyingGlass
      });
      $$renderer3.push(`<!----></div>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { query });
  });
}
export {
  SearchBar as S
};
//# sourceMappingURL=SearchBar.js.map
