import "clsx";
import { o as getContext, r as setContext, f as bind_props, d as ensure_array_like, e as escape_html } from "./index3.js";
import "./index.js";
import { o as onDestroy, t as tick } from "./index-server.js";
import { $ as html, a0 as buttonSize } from "./client.svelte.js";
import { I as Icon } from "./Icon.js";
import { C as CheckCircle } from "./CheckCircle.js";
import { L as Label } from "./Label.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import { M as Menu, a as MenuButton } from "./MenuButton.js";
const ChevronUpDown = {
  "micro": {
    "a": {
      "viewBox": "0 0 16 16",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M5.22 10.22a.75.75 0 0 1 1.06 0L8 11.94l1.72-1.72a.75.75 0 1 1 1.06 1.06l-2.25 2.25a.75.75 0 0 1-1.06 0l-2.25-2.25a.75.75 0 0 1 0-1.06ZM10.78 5.78a.75.75 0 0 1-1.06 0L8 4.06 6.28 5.78a.75.75 0 0 1-1.06-1.06l2.25-2.25a.75.75 0 0 1 1.06 0l2.25 2.25a.75.75 0 0 1 0 1.06Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "mini": {
    "a": {
      "viewBox": "0 0 20 20",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M10.53 3.47a.75.75 0 0 0-1.06 0L6.22 6.72a.75.75 0 0 0 1.06 1.06L10 5.06l2.72 2.72a.75.75 0 1 0 1.06-1.06l-3.25-3.25Zm-4.31 9.81 3.25 3.25a.75.75 0 0 0 1.06 0l3.25-3.25a.75.75 0 1 0-1.06-1.06L10 14.94l-2.72-2.72a.75.75 0 0 0-1.06 1.06Z",
        "clip-rule": "evenodd"
      }
    ]
  },
  "outline": {
    "a": {
      "fill": "none",
      "viewBox": "0 0 24 24",
      "stroke-width": "1.5",
      "stroke": "currentColor"
    },
    "path": [
      {
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "d": "M8.25 15 12 18.75 15.75 15m-7.5-6L12 5.25 15.75 9"
      }
    ]
  },
  "solid": {
    "a": {
      "viewBox": "0 0 24 24",
      "fill": "currentColor"
    },
    "path": [
      {
        "fill-rule": "evenodd",
        "d": "M11.47 4.72a.75.75 0 0 1 1.06 0l3.75 3.75a.75.75 0 0 1-1.06 1.06L12 6.31 8.78 9.53a.75.75 0 0 1-1.06-1.06l3.75-3.75Zm-3.75 9.75a.75.75 0 0 1 1.06 0L12 17.69l3.22-3.22a.75.75 0 1 1 1.06 1.06l-3.75 3.75a.75.75 0 0 1-1.06 0l-3.75-3.75a.75.75 0 0 1 0-1.06Z",
        "clip-rule": "evenodd"
      }
    ]
  }
};
function Option($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { children, icon, $$slots, $$events, ...rest } = $$props;
    let optionElement = void 0;
    let option = {
      value: ""
    };
    const context = getContext("select");
    onDestroy(() => {
      const index = context.options.findIndex((i) => i.value == option.value);
      if (index != -1) {
        context.options.splice(index, 1);
      }
    });
    $$renderer2.push(`<!---->`);
    {
      $$renderer2.option({ ...rest, this: optionElement }, ($$renderer3) => {
        children($$renderer3);
        $$renderer3.push(`<!---->`);
      });
    }
    $$renderer2.push(`<!---->`);
  });
}
function Select($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let open = false;
    let element = void 0;
    const context = setContext("select", { options: [] });
    let {
      value = void 0,
      placeholder = void 0,
      label = void 0,
      size = "md",
      class: clazz = "",
      baseClass = "",
      selectClass = "",
      customLabel,
      children,
      customOption,
      oncontextmenu,
      onchange,
      placement = "bottom",
      target: passedTarget,
      $$slots,
      $$events,
      ...rest
    } = $$props;
    function selectTarget($$renderer3, attachment) {
      Label($$renderer3, {
        text: label,
        customText: customLabel,
        class: ["space-y-1 relative max-w-full w-max min-w-0", baseClass],
        children: ($$renderer4) => {
          $$renderer4.push(`<div class="relative max-w-full" role="presentation">`);
          $$renderer4.select(
            {
              ...rest,
              this: element,
              class: [
                buttonSize[size],
                "btn btn-secondary select rounded-xl appearance-none pr-6! w-full shadow-xs",
                selectClass,
                clazz
              ],
              value,
              onmousedown: (e) => {
                e.preventDefault();
              },
              onkeypress: (e) => {
                e.preventDefault();
                open = !open;
              },
              onchange,
              oncontextmenu,
              placeholder
            },
            ($$renderer5) => {
              if (placeholder) {
                $$renderer5.push("<!--[-->");
                $$renderer5.option({ disabled: true, selected: true, value: "" }, ($$renderer6) => {
                  $$renderer6.push(`${escape_html(placeholder)}`);
                });
              } else {
                $$renderer5.push("<!--[!-->");
              }
              $$renderer5.push(`<!--]-->`);
              children?.($$renderer5);
              $$renderer5.push(`<!---->`);
            }
          );
          $$renderer4.push(` `);
          Icon($$renderer4, {
            src: ChevronUpDown,
            micro: true,
            size: "16",
            class: "absolute bottom-1/2 translate-y-1/2 right-1 box-border pointer-events-none z-10 text-slate-600 dark:text-zinc-400"
          });
          $$renderer4.push(`<!----></div>`);
        },
        $$slots: { default: true }
      });
    }
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      {
        let target = function($$renderer4, attachment) {
          const render = passedTarget ?? selectTarget;
          render?.($$renderer4, attachment);
          $$renderer4.push(`<!---->`);
        };
        Menu($$renderer3, {
          placement,
          get open() {
            return open;
          },
          set open($$value) {
            open = $$value;
            $$settled = false;
          },
          target,
          children: ($$renderer4) => {
            $$renderer4.push(`<!--[-->`);
            const each_array = ensure_array_like(context.options);
            for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
              let option = each_array[$$index];
              if (customOption) {
                $$renderer4.push("<!--[-->");
                customOption($$renderer4, { option, selected: option.value == value });
                $$renderer4.push(`<!---->`);
              } else {
                $$renderer4.push("<!--[!-->");
                MenuButton($$renderer4, {
                  onclick: async () => {
                    value = option.value;
                    await tick();
                  },
                  size: "custom",
                  disabled: option.disabled,
                  color: "none",
                  class: [
                    "min-h-0! py-1 hover:bg-slate-100 dark:hover:bg-zinc-800",
                    option.value == value && "bg-slate-100 dark:bg-zinc-800 text-primary-900 dark:text-primary-100 font-medium",
                    option.disabled && "pointer-events-none text-slate-600 dark:text-zinc-400",
                    option.isLabel && "text-xs mt-2"
                  ],
                  children: ($$renderer5) => {
                    if (option.value == value) {
                      $$renderer5.push("<!--[-->");
                      Icon($$renderer5, {
                        src: CheckCircle,
                        size: "16",
                        micro: true,
                        class: "text-primary-900 dark:text-primary-100"
                      });
                    } else {
                      $$renderer5.push("<!--[!-->");
                      if (option.icon) {
                        $$renderer5.push("<!--[-->");
                        Icon($$renderer5, {
                          src: option.icon,
                          size: "16",
                          micro: true,
                          class: "text-slate-600 dark:text-zinc-400"
                        });
                      } else {
                        $$renderer5.push("<!--[!-->");
                      }
                      $$renderer5.push(`<!--]-->`);
                    }
                    $$renderer5.push(`<!--]--> ${html(option.label)}`);
                  },
                  $$slots: { default: true }
                });
              }
              $$renderer4.push(`<!--]-->`);
            }
            $$renderer4.push(`<!--]-->`);
          },
          $$slots: { target: true, default: true }
        });
      }
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    bind_props($$props, { value });
  });
}
export {
  ChevronUpDown as C,
  Option as O,
  Select as S
};
//# sourceMappingURL=Select.js.map
